/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.EventListener;
import java.util.Iterator;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;

@NonUITestCase
public class ListenerListTest
extends RienaTestCase {
    private final ListenerList<TestListener> listenerList = new ListenerList(TestListener.class);

    public void testFresh() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener.pieps = 0;
        TestListener[] testListenerArray = (TestListener[])this.listenerList.getListeners();
        int n = testListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestListener listener = testListenerArray[n2];
            listener.piep();
            ++n2;
        }
        ListenerListTest.assertEquals((int)0, (int)TestListener.pieps);
    }

    public void testFreshUsingIterator() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener.pieps = 0;
        for (TestListener listener : this.listenerList) {
            listener.piep();
        }
        ListenerListTest.assertEquals((int)0, (int)TestListener.pieps);
    }

    public void testAddOneRemoveOne() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener t = new TestListener();
        this.listenerList.add((Object)t);
        ListenerListTest.assertEquals((int)1, (int)((TestListener[])this.listenerList.getListeners()).length);
        TestListener.pieps = 0;
        TestListener[] testListenerArray = (TestListener[])this.listenerList.getListeners();
        int n = testListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestListener listener = testListenerArray[n2];
            listener.piep();
            ++n2;
        }
        ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
        this.listenerList.remove((Object)t);
        ListenerListTest.assertEquals((int)0, (int)((TestListener[])this.listenerList.getListeners()).length);
    }

    public void testAddOneRemoveOneUsingIterator() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener t = new TestListener();
        this.listenerList.add((Object)t);
        ListenerListTest.assertEquals((int)1, (int)((TestListener[])this.listenerList.getListeners()).length);
        TestListener.pieps = 0;
        for (TestListener listener : this.listenerList) {
            listener.piep();
        }
        ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
        this.listenerList.remove((Object)t);
        ListenerListTest.assertEquals((int)0, (int)((TestListener[])this.listenerList.getListeners()).length);
    }

    public void testAddMoreRemoveAll() {
        TestListener listener;
        int n;
        int n2;
        TestListener[] testListenerArray;
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener[] listeners = new TestListener[10];
        int i = 0;
        while (i < listeners.length) {
            listeners[i] = new TestListener();
            this.listenerList.add((Object)listeners[i]);
            TestListener.pieps = 0;
            testListenerArray = (TestListener[])this.listenerList.getListeners();
            n2 = testListenerArray.length;
            n = 0;
            while (n < n2) {
                listener = testListenerArray[n];
                listener.piep();
                ++n;
            }
            ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
            ++i;
        }
        i = listeners.length - 1;
        while (i >= 0) {
            this.listenerList.remove((Object)listeners[i]);
            ListenerListTest.assertEquals((int)i, (int)((TestListener[])this.listenerList.getListeners()).length);
            TestListener.pieps = 0;
            testListenerArray = (TestListener[])this.listenerList.getListeners();
            n2 = testListenerArray.length;
            n = 0;
            while (n < n2) {
                listener = testListenerArray[n];
                listener.piep();
                ++n;
            }
            ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
            --i;
        }
        ListenerListTest.assertEquals((int)0, (int)((TestListener[])this.listenerList.getListeners()).length);
    }

    public void testAddMoreRemoveAllUsingIterator() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener[] listeners = new TestListener[10];
        int i = 0;
        while (i < listeners.length) {
            listeners[i] = new TestListener();
            this.listenerList.add((Object)listeners[i]);
            TestListener.pieps = 0;
            for (TestListener listener : this.listenerList) {
                listener.piep();
            }
            ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
            ++i;
        }
        i = listeners.length - 1;
        while (i >= 0) {
            this.listenerList.remove((Object)listeners[i]);
            ListenerListTest.assertEquals((int)i, (int)((TestListener[])this.listenerList.getListeners()).length);
            TestListener.pieps = 0;
            for (TestListener listener : this.listenerList) {
                listener.piep();
            }
            ListenerListTest.assertEquals((int)((TestListener[])this.listenerList.getListeners()).length, (int)TestListener.pieps);
            --i;
        }
        ListenerListTest.assertEquals((int)0, (int)((TestListener[])this.listenerList.getListeners()).length);
    }

    public void testFixArrayStoreExceptionWithAnonymousClasses() {
        ListenerList windowListenerList = new ListenerList(IWindowRidgetListener.class);
        IWindowRidgetListener listener1 = new IWindowRidgetListener(){

            public void activated() {
            }

            public void closed() {
            }
        };
        windowListenerList.add((Object)listener1);
        IWindowRidgetListener listener2 = new IWindowRidgetListener(){

            public void activated() {
            }

            public void closed() {
            }
        };
        windowListenerList.add((Object)listener2);
        windowListenerList.remove((Object)listener1);
        windowListenerList.remove((Object)listener2);
    }

    public void testRemoveWhileItering() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener[] listeners = new TestListener[10];
        int i = 0;
        while (i < listeners.length) {
            listeners[i] = new TestListener();
            this.listenerList.add((Object)listeners[i]);
            ++i;
        }
        TestListener.pieps = 0;
        i = 0;
        TestListener[] testListenerArray = (TestListener[])this.listenerList.getListeners();
        int n = testListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestListener listener = testListenerArray[n2];
            listener.piep();
            if (i % 2 == 0) {
                this.listenerList.remove((Object)listener);
            }
            ++i;
            ++n2;
        }
        ListenerListTest.assertEquals((int)10, (int)TestListener.pieps);
        ListenerListTest.assertEquals((int)5, (int)this.listenerList.size());
    }

    public void testRemoveWhileIteringUsingIterator() {
        EventListener[] list = (EventListener[])this.listenerList.getListeners();
        ListenerListTest.assertNotNull((Object)list);
        ListenerListTest.assertEquals((int)0, (int)list.length);
        TestListener[] listeners = new TestListener[10];
        int i = 0;
        while (i < listeners.length) {
            listeners[i] = new TestListener();
            this.listenerList.add((Object)listeners[i]);
            ++i;
        }
        TestListener.pieps = 0;
        Iterator iterator = this.listenerList.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            ((TestListener)iterator.next()).piep();
            if (i2 % 2 == 0) {
                iterator.remove();
            }
            ++i2;
        }
        ListenerListTest.assertEquals((int)10, (int)TestListener.pieps);
        ListenerListTest.assertEquals((int)5, (int)this.listenerList.size());
    }

    private static class TestListener
    implements EventListener {
        private static int pieps;

        private TestListener() {
        }

        public void piep() {
            ++pieps;
        }
    }
}

