/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.extension.IData;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.core.wire.IDataWithID;
import org.eclipse.riena.core.wire.IDataWithIDinAnnotation;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.core.wire.ExtensionInjectorBuilder;

@NonUITestCase
public class ExtensionInjectorBuilderTest
extends RienaTestCase {
    public void testBuildForUpdate1() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update1", IData.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"testA", (String)this.rawId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update1", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(id="testA")
    public void update1(IData data) {
    }

    public void testBuildForUpdate1Array() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update1Array", IData[].class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"testA[]", (String)this.rawId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)Integer.MAX_VALUE, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update1Array", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(id="testA[]")
    public void update1Array(IData[] data) {
    }

    public void testBuildForUpdate2() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update2", IData[].class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"testB", (String)this.rawId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)2, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)5, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update2", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(id="testB", doNotReplaceSymbols=true, heterogeneous=true, specific=true, min=2, max=5)
    public void update2(IData[] data) {
    }

    public void testBuildForUpdate3() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update3", IData.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"testC", (String)this.rawId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update3", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(id="testC", heterogeneous=true, specific=true, min=0, max=1)
    public void update3(IData data) {
    }

    public void testBuildForUpdateWithAnExtensionInterfaceWithID() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("updateWithID", IDataWithID.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        String expectedId = String.valueOf(this.getContext().getBundle().getSymbolicName()) + ".testWithID";
        try {
            injector.andStart(this.getContext());
        }
        catch (IllegalArgumentException e) {
            ExtensionInjectorBuilderTest.assertTrue((boolean)e.getMessage().contains(expectedId));
        }
        ExtensionInjectorBuilderTest.assertEquals((String)expectedId, (String)this.firstNormalizedId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IDataWithID.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"updateWithID", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(heterogeneous=true, specific=true, min=0, max=1)
    public void updateWithID(IDataWithID data) {
    }

    public void testBuildForUpdateWithAnExtensionInterfaceWithIDinAnnotation() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("updateWithIDinAnnotation", IDataWithIDinAnnotation.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        String expectedId = String.valueOf(this.getContext().getBundle().getSymbolicName()) + ".testWithIDinAnnotation";
        try {
            injector.andStart(this.getContext());
        }
        catch (IllegalArgumentException e) {
            ExtensionInjectorBuilderTest.assertTrue((boolean)e.getMessage().contains(expectedId));
        }
        ExtensionInjectorBuilderTest.assertEquals((String)expectedId, (String)this.firstNormalizedId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IDataWithIDinAnnotation.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"updateWithIDinAnnotation", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(heterogeneous=true, specific=true, min=0, max=1)
    public void updateWithIDinAnnotation(IDataWithIDinAnnotation data) {
    }

    public void testBuildForUpdate4WithAnExtensionInterfaceWithIDinAnnotationAndWithOnceOnlyViaStatic() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update4WithIDinAnnotation", IDataWithIDinAnnotation.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        String expectedId = String.valueOf(this.getContext().getBundle().getSymbolicName()) + ".testWithIDinAnnotation";
        try {
            injector.andStart(this.getContext());
        }
        catch (IllegalArgumentException e) {
            ExtensionInjectorBuilderTest.assertTrue((boolean)e.getMessage().contains(expectedId));
        }
        ExtensionInjectorBuilderTest.assertEquals((String)expectedId, (String)this.firstNormalizedId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IDataWithIDinAnnotation.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update4WithIDinAnnotation", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(heterogeneous=true, specific=true, min=0, max=1)
    public static void update4WithIDinAnnotation(IDataWithIDinAnnotation data) {
    }

    public void testBuildForUpdate5WithAnExtensionInterfaceWithIDinAnnotationAndWithOnceOnlyViaAnnotation() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update5WithIDinAnnotation", IDataWithIDinAnnotation.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        String expectedId = String.valueOf(this.getContext().getBundle().getSymbolicName()) + ".testWithIDinAnnotation";
        try {
            injector.andStart(this.getContext());
        }
        catch (IllegalArgumentException e) {
            ExtensionInjectorBuilderTest.assertTrue((boolean)e.getMessage().contains(expectedId));
        }
        ExtensionInjectorBuilderTest.assertEquals((String)expectedId, (String)this.firstNormalizedId(injector));
        ExtensionInjectorBuilderTest.assertEquals(IDataWithIDinAnnotation.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)0, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getTarget(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update5WithIDinAnnotation", (String)this.getUpdateMethodName(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getOnceOnly(injector));
    }

    @InjectExtension(heterogeneous=true, specific=true, min=0, max=1, onceOnly=true)
    public void update5WithIDinAnnotation(IDataWithIDinAnnotation data) {
    }

    private String rawId(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        Object extensionPointId = ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"extensionPointId");
        return (String)ReflectionUtils.getHidden((Object)extensionPointId, (String)"rawId");
    }

    private String firstNormalizedId(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        Object extensionPointId = ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"extensionPointId");
        List ids = (List)ReflectionUtils.getHidden((Object)extensionPointId, (String)"normalizedIds");
        return (String)ids.get(0);
    }

    private Object useType(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"interfaceType");
    }

    private int getMin(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Integer)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"minOccurrences");
    }

    private int getMax(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Integer)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"maxOccurrences");
    }

    private boolean getHomogenious(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Boolean)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"homogeneous");
    }

    private Object getTarget(ExtensionInjector injector) {
        WeakRef ref = (WeakRef)ReflectionUtils.getHidden((Object)injector, (String)"targetRef");
        return ref.get();
    }

    private String getUpdateMethodName(ExtensionInjector injector) {
        return (String)ReflectionUtils.getHidden((Object)injector, (String)"updateMethodName");
    }

    private boolean getDoNotReplaceSymbols(ExtensionInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"symbolReplace") == false;
    }

    private boolean getSpecific(ExtensionInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"nonSpecific") == false;
    }

    private boolean getOnceOnly(ExtensionInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"onceOnly");
    }
}

