/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.navigation.model.NavigationNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;

@NonUITestCase
public class NavigationSourceProviderTest
extends TestCase {
    private NavigationSourceProvider provider;

    protected void setUp() throws Exception {
        super.setUp();
        this.provider = new NavigationSourceProvider();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.provider = null;
        ApplicationNodeManager.clear();
    }

    public void testGetVariableNameForNode() {
        NavigationSourceProviderTest.assertNull((Object)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{null}));
        NavigationSourceProviderTest.assertNotNull((Object)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{new SubModuleNode()}));
        NavigationSourceProviderTest.assertNotNull((Object)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{new ModuleNode()}));
        NavigationSourceProviderTest.assertNotNull((Object)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{new ModuleGroupNode()}));
        NavigationSourceProviderTest.assertNotNull((Object)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{new SubApplicationNode()}));
        try {
            ReflectionUtils.invokeHidden((Object)this.provider, (String)"getVariableNameForNode", (Object[])new Object[]{new MockNavigationNode(null)});
            NavigationSourceProviderTest.fail((String)"Expected InvocationTargetFailure, but it wasn't thrown!");
        }
        catch (InvocationTargetFailure failure) {
            NavigationSourceProviderTest.assertTrue((boolean)(failure.getTargetException() instanceof NavigationModelFailure));
            Nop.reason((String)"Expected failure");
        }
    }

    public void testGetTypeNodeId() {
        SubModuleNode subModuleNode = new SubModuleNode();
        String ret = (String)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getTypeNodeId", (Object[])new Object[]{subModuleNode});
        NavigationSourceProviderTest.assertEquals((String)"", (String)ret);
        subModuleNode = new SubModuleNode(new NavigationNodeId("helloID"));
        ret = (String)ReflectionUtils.invokeHidden((Object)this.provider, (String)"getTypeNodeId", (Object[])new Object[]{subModuleNode});
        NavigationSourceProviderTest.assertEquals((String)"helloID", (String)ret);
    }

    public void testGetCurrentState() {
        Map state = this.provider.getCurrentState();
        NavigationSourceProviderTest.assertEquals((int)8, (int)state.keySet().size());
        NavigationSourceProviderTest.assertEquals((int)8, (int)state.values().size());
        for (Object value : state.values()) {
            if (value instanceof String) {
                NavigationSourceProviderTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)((String)value)));
                continue;
            }
            NavigationSourceProviderTest.assertNull(value);
        }
        ApplicationNode appNode = new ApplicationNode(new NavigationNodeId("app1"));
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)appNode);
        SubApplicationNode subApp = new SubApplicationNode(new NavigationNodeId("subApp1"));
        appNode.addChild((INavigationNode)subApp);
        ModuleGroupNode mg = new ModuleGroupNode(new NavigationNodeId("mg1"));
        subApp.addChild((INavigationNode)mg);
        ModuleNode mod = new ModuleNode(new NavigationNodeId("mod1"));
        mg.addChild((INavigationNode)mod);
        SubModuleNode subMod = new SubModuleNode(new NavigationNodeId("subMod1"));
        mod.addChild((INavigationNode)subMod);
        SubModuleNode subMod2 = new SubModuleNode(new NavigationNodeId("subMod2"));
        mod.addChild((INavigationNode)subMod2);
        state = this.provider.getCurrentState();
        NavigationSourceProviderTest.assertEquals((int)8, (int)state.values().size());
        for (Object value : state.values()) {
            if (value instanceof String) {
                NavigationSourceProviderTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)((String)value)));
                continue;
            }
            NavigationSourceProviderTest.assertNull(value);
        }
        subMod.activate();
        state = this.provider.getCurrentState();
        NavigationSourceProviderTest.assertEquals((int)8, (int)state.keySet().size());
        NavigationSourceProviderTest.assertTrue((boolean)state.values().contains("subMod1"));
        NavigationSourceProviderTest.assertTrue((boolean)state.values().contains("mod1"));
        NavigationSourceProviderTest.assertTrue((boolean)state.values().contains("mg1"));
        NavigationSourceProviderTest.assertTrue((boolean)state.values().contains("subApp1"));
        NavigationSourceProviderTest.assertFalse((boolean)state.values().contains("app1"));
        NavigationSourceProviderTest.assertFalse((boolean)state.values().contains("subMod2"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MockNavigationNode
    extends NavigationNode<ISubModuleNode, ISubModuleNode, ISubModuleNodeListener> {
        public MockNavigationNode(NavigationNodeId nodeId) {
            super(nodeId);
        }

        public Class<ISubModuleNode> getValidChildType() {
            return null;
        }
    }
}

