/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import org.easymock.EasyMock;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.SwitchSubApplication;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;

@NonUITestCase
public class SwitchSubApplicationTest
extends RienaTestCase {
    private SwitchSubApplication handler;
    private ISubApplicationNode nodeA;
    private ISubApplicationNode nodeB;
    private ISubApplicationNode nodeC;

    protected void setUp() throws Exception {
        super.setUp();
        this.handler = new SwitchSubApplication();
        this.nodeA = (ISubApplicationNode)EasyMock.createMock(ISubApplicationNode.class);
        this.nodeB = (ISubApplicationNode)EasyMock.createMock(ISubApplicationNode.class);
        this.nodeC = (ISubApplicationNode)EasyMock.createMock(ISubApplicationNode.class);
    }

    public void testFindNextSubApplicationAtoB() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertSame((Object)this.nodeB, (Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindNextSubApplicationCtoA() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)false).times(2);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        EasyMock.expect((Object)this.nodeC.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeC});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertSame((Object)this.nodeA, (Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindNextSubApplicationEmpty() {
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindNextSubApplicationAtoA() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindNextSubApplicationNoneSelected() {
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindNextSubApplicationTwoSelected() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        EasyMock.expect((Object)this.nodeB.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeB});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findNextNode((INavigationNode[])nodes));
    }

    public void testFindPrevSubApplicationCtoB() {
        EasyMock.expect((Object)this.nodeC.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeC});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertSame((Object)this.nodeB, (Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }

    public void testFindPrevSubApplicationAtoC() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        EasyMock.expect((Object)this.nodeC.isSelected()).andReturn((Object)false).times(2);
        EasyMock.replay((Object[])new Object[]{this.nodeC});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertSame((Object)this.nodeC, (Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }

    public void testFindPrevSubApplicationEmpty() {
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }

    public void testFindPrevSubApplicationAtoA() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }

    public void testFindPrevSubApplicationNoneSelected() {
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }

    public void testFindPrevSubApplicationTwoSelected() {
        EasyMock.expect((Object)this.nodeA.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeA});
        EasyMock.expect((Object)this.nodeB.isSelected()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.nodeB});
        ISubApplicationNode[] nodes = new ISubApplicationNode[]{this.nodeA, this.nodeB, this.nodeC};
        SwitchSubApplicationTest.assertNull((Object)this.handler.findPreviousNode((INavigationNode[])nodes, true));
    }
}

