/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common.authorization;

import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.util.ContainerModel;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.security.common.authorization.IPermissionCacheExtension;
import org.eclipse.riena.internal.security.common.authorization.PermissionCache;

@NonUITestCase
public class PermissionCacheTest
extends RienaTestCase {
    public void testConfigurationServer() {
        this.setContainerType(ContainerType.SERVER);
        PermissionCache cache = new PermissionCache();
        PermissionCacheTest.assertEquals((int)100, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)360000, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationClient() {
        this.setContainerType(ContainerType.CLIENT);
        PermissionCache cache = new PermissionCache();
        PermissionCacheTest.assertEquals((int)1, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)999999000, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationClientNoExtension() {
        this.setContainerType(ContainerType.CLIENT);
        PermissionCache cache = new PermissionCache();
        cache.update(null);
        PermissionCacheTest.assertEquals((int)1, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)999999000, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationServerNoExtension() {
        this.setContainerType(ContainerType.SERVER);
        PermissionCache cache = new PermissionCache();
        cache.update(null);
        PermissionCacheTest.assertEquals((int)100, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)360000, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationClientOneExtensionTimeoutMinusOne() {
        this.setContainerType(ContainerType.CLIENT);
        PermissionCache cache = new PermissionCache();
        cache.update((IPermissionCacheExtension)new PermissionCacheExtension(5, -1));
        PermissionCacheTest.assertEquals((int)5, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)Integer.MAX_VALUE, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationClientOneExtension() {
        this.setContainerType(ContainerType.CLIENT);
        PermissionCache cache = new PermissionCache();
        cache.update((IPermissionCacheExtension)new PermissionCacheExtension(5, 360));
        PermissionCacheTest.assertEquals((int)5, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)360, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationServerOneExtensionTimeoutMinusOne() {
        this.setContainerType(ContainerType.SERVER);
        PermissionCache cache = new PermissionCache();
        cache.update((IPermissionCacheExtension)new PermissionCacheExtension(5, -1));
        PermissionCacheTest.assertEquals((int)5, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)Integer.MAX_VALUE, (int)this.getCache(cache).getTimeout());
    }

    public void testConfigurationServerOneExtension() {
        this.setContainerType(ContainerType.SERVER);
        PermissionCache cache = new PermissionCache();
        cache.update((IPermissionCacheExtension)new PermissionCacheExtension(5, 360));
        PermissionCacheTest.assertEquals((int)5, (int)this.getCache(cache).getMinimumSize());
        PermissionCacheTest.assertEquals((int)360, (int)this.getCache(cache).getTimeout());
    }

    private void setContainerType(ContainerType containerType) {
        System.setProperty("riena.container.type", containerType == ContainerType.SERVER ? "server" : "client");
        ReflectionUtils.invokeHidden(ContainerModel.class, (String)"initialize", (Object[])new Object[0]);
    }

    private GenericObjectCache getCache(PermissionCache permissionCache) {
        return (GenericObjectCache)ReflectionUtils.getHidden((Object)permissionCache, (String)"permCache");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContainerType {
        SERVER,
        CLIENT;

    }

    private static class PermissionCacheExtension
    implements IPermissionCacheExtension {
        private final int minimumSize;
        private final int timeout;

        public PermissionCacheExtension(int minimumSize, int timeout) {
            this.minimumSize = minimumSize;
            this.timeout = timeout;
        }

        public int getMinimumSize() {
            return this.minimumSize;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }
}

