/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.ISelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.tests.base.TestMultiSelectionBean;
import org.eclipse.riena.ui.tests.base.TestSingleSelectionBean;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableRidgetTest
extends AbstractSWTRidgetTest {
    protected PersonManager manager;
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected TestSingleSelectionBean singleSelectionBean;
    protected TestMultiSelectionBean multiSelectionBean;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new PersonManager(this.createPersonList());
        Iterator it = this.manager.getPersons().iterator();
        this.person1 = (Person)it.next();
        this.person2 = (Person)it.next();
        this.person3 = (Person)it.next();
        this.bindRidgetToModel();
        this.singleSelectionBean = new TestSingleSelectionBean();
        this.getRidget().bindSingleSelectionToModel((Object)this.singleSelectionBean, "selection");
        this.multiSelectionBean = new TestMultiSelectionBean();
        this.getRidget().bindMultiSelectionToModel((Object)this.multiSelectionBean, "selectionList");
        this.getRidget().updateFromModel();
        UITestHelper.readAndDispatch((Widget)this.getWidget());
    }

    protected abstract void bindRidgetToModel();

    protected ISelectableIndexedRidget getRidget() {
        return (ISelectableIndexedRidget)super.getRidget();
    }

    public void testClearSelection() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.person1);
        AbstractTableRidgetTest.assertTrue((ridget.getSelection().size() > 0 ? 1 : 0) != 0);
        AbstractTableRidgetTest.assertTrue((this.getUIControlSelectedRowCount() > 0 ? 1 : 0) != 0);
        AbstractTableRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getSingleSelectionObservable().getValue());
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getMultiSelectionObservable().size());
        ridget.clearSelection();
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertNull((Object)ridget.getSingleSelectionObservable().getValue());
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getMultiSelectionObservable().size());
        if (this.supportsMulti()) {
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ridget.setSelection(Arrays.asList(this.person1, this.person2));
            AbstractTableRidgetTest.assertTrue((ridget.getSelection().size() > 0 ? 1 : 0) != 0);
            AbstractTableRidgetTest.assertTrue((this.getUIControlSelectedRowCount() > 0 ? 1 : 0) != 0);
            AbstractTableRidgetTest.assertNotNull((Object)ridget.getSingleSelectionObservable().getValue());
            AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getMultiSelectionObservable().size());
            ridget.clearSelection();
            AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
            AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
            AbstractTableRidgetTest.assertNull((Object)ridget.getSingleSelectionObservable().getValue());
            AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getMultiSelectionObservable().size());
        }
    }

    public void testClearSelectionWhenSelectionIsRemovedFromModel() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setSelection((Object)this.person2);
        AbstractTableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        AbstractTableRidgetTest.assertSame((Object)this.person2, (Object)this.manager.getSelectedPerson());
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
        AbstractTableRidgetTest.assertNull((Object)this.manager.getSelectedPerson());
    }

    public void testGetSelection() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertNotNull((Object)ridget.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
        if (this.supportsMulti()) {
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ridget.setSelection(new int[]{1, 2});
            AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), ridget.getSelection().get(0));
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), ridget.getSelection().get(1));
        }
    }

    public void testGetSelectionIndex() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setSelection(1);
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndex());
        int[] nArray = new int[2];
        nArray[0] = 2;
        ridget.setSelection(nArray);
        AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndex());
        ridget.clearSelection();
        AbstractTableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testGetSelectionIndices() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndices().length);
        if (this.supportsMulti()) {
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ArrayList<Object> selBeans = new ArrayList<Object>(2);
            selBeans.add(this.getRowValue(0));
            selBeans.add(this.getRowValue(1));
            ridget.setSelection(selBeans);
            AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
            AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndices()[0]);
            AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices()[1]);
        }
        ridget.setSelection(2);
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices()[0]);
    }

    public void testSetSelectionInt() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ridget.setSelection(0);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setSelection(1);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        try {
            ridget.setSelection(99);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        try {
            ridget.setSelection(-1);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testSetSelectionIntArray() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection(new int[]{1, 2});
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        if (this.supportsMulti()) {
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ridget.setSelection(new int[]{1, 2});
            AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
            AbstractTableRidgetTest.assertEquals((int)1, (int)this.getSelectedRows()[0]);
            AbstractTableRidgetTest.assertEquals((int)2, (int)this.getSelectedRows()[1]);
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
            AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        }
        ridget.setSelection(new int[0]);
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndices().length);
        try {
            ridget.setSelection(new int[]{1, -1, 2});
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionList() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ArrayList<Object> selBeans1 = new ArrayList<Object>(2);
        selBeans1.add(this.getRowValue(0));
        selBeans1.add(this.getRowValue(1));
        ridget.setSelection(selBeans1);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        if (this.supportsMulti()) {
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ArrayList<Object> selBeans2 = new ArrayList<Object>(2);
            selBeans2.add(this.getRowValue(0));
            selBeans2.add(this.getRowValue(1));
            ridget.setSelection(selBeans2);
            AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
            AbstractTableRidgetTest.assertEquals((int)0, (int)this.getSelectedRows()[0]);
            AbstractTableRidgetTest.assertEquals((int)1, (int)this.getSelectedRows()[1]);
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
            AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
            AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(1));
            ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
            ArrayList<Object> selBeans3 = new ArrayList<Object>(1);
            selBeans3.add(new Object());
            ridget.setSelection(selBeans3);
            AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
            AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
            AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
            try {
                ridget.setSelection(null);
                AbstractTableRidgetTest.fail();
            }
            catch (RuntimeException runtimeException) {
                this.ok();
            }
        }
    }

    public void testSetSelectionObject() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ridget.setSelection(this.getRowValue(0));
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setSelection(new Object());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.multiSelectionBean.getSelectionList().size());
        ridget.setSelection(null);
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.multiSelectionBean.getSelectionList().size());
    }

    public void testSetSelectionWithNoModel() {
        ISelectableIndexedRidget ridget = (ISelectableIndexedRidget)this.createRidget();
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.getOptionCount());
        try {
            ridget.setSelection(0);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSelection(new int[1]);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSelection(null);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSelection(Collections.EMPTY_LIST);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionWithNoBoundControl() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        AbstractTableRidgetTest.assertNotNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ridget.setUIControl(null);
        ridget.setSelection((Object)this.person1);
        AbstractTableRidgetTest.assertNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    public void testUpdateSingleSelectionFromModelWithNoBoundControl() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.person2);
        AbstractTableRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ridget.setUIControl(null);
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testUpdateMultiSelectionFromModelWithNoBoundControl() {
        if (!this.supportsMulti()) {
            System.out.println("skipping testUpdateMultiSelectionFromModelWithNoBoundControl() for " + this.getRidget());
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.person1, this.person2));
        AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        AbstractTableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(1));
        ridget.setUIControl(null);
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        AbstractTableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    public void testUpdateSingleSelectionFromModelWithBoundControl() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.person2);
        AbstractTableRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertNotNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testUpdateMultiSelectionFromModelWithBoundControl() {
        if (!this.supportsMulti()) {
            System.out.println("skipping testUpdateMultiSelectionFromModelWithBoundControl() for " + this.getRidget());
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.person1, this.person2));
        AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        AbstractTableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(1));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertNotNull((Object)ridget.getUIControl());
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        AbstractTableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    public void testUpdateMultiSelectionCustomBinding() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        WritableList customMultiSelectionObservable = new WritableList();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindList(ridget.getMultiSelectionObservable(), (IObservableList)customMultiSelectionObservable, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
        this.setUIControlRowSelectionInterval(0, 2);
        AbstractTableRidgetTest.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        AbstractTableRidgetTest.assertEquals((int)3, (int)customMultiSelectionObservable.size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)customMultiSelectionObservable.get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)customMultiSelectionObservable.get(1));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)customMultiSelectionObservable.get(2));
        customMultiSelectionObservable.add(this.getRowValue(0));
        customMultiSelectionObservable.clear();
        customMultiSelectionObservable.add(this.getRowValue(0));
        customMultiSelectionObservable.add(this.getRowValue(2));
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)customMultiSelectionObservable.size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)customMultiSelectionObservable.get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)customMultiSelectionObservable.get(1));
    }

    public void testUpdateMultiSelectionFromControl() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        this.setUIControlRowSelectionInterval(1, 2);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        int[] nArray = new int[2];
        nArray[1] = 2;
        this.setUIControlRowSelection(nArray);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromModel() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(0, 2);
        this.multiSelectionBean.setSelectionList(new ArrayList<Object>());
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(1));
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(2));
        AbstractTableRidgetTest.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.updateMultiSelectionFromModel();
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromModelWhenUnbound() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(0, 2);
        this.multiSelectionBean.setSelectionList(new ArrayList<Object>());
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(1));
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(2));
        AbstractTableRidgetTest.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.setUIControl(null);
        ridget.updateMultiSelectionFromModel();
        ridget.setUIControl((Object)this.getWidget());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromRidgetOnRebind() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(1, 2);
        ridget.setUIControl(null);
        this.clearUIControlRowSelection();
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.setUIControl((Object)this.getWidget());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRows()[0]);
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateSingleSelectionCustomBinding() {
        ISelectableIndexedRidget ridget = this.getRidget();
        WritableValue customSingleSelectionObservable = new WritableValue();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(ridget.getSingleSelectionObservable(), (IObservableValue)customSingleSelectionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.setUIControlRowSelectionInterval(1, 1);
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertNull((Object)customSingleSelectionObservable.getValue());
        customSingleSelectionObservable.setValue(this.getRowValue(0));
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)customSingleSelectionObservable.getValue());
    }

    public void testUpdateSingleSelectionFromControl() {
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        this.setUIControlRowSelectionInterval(1, 1);
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromModel() {
        ISelectableIndexedRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(1, 1);
        this.singleSelectionBean.setSelection(this.getRowValue(0));
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.updateSingleSelectionFromModel();
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromModelWhenUnbound() {
        ISelectableIndexedRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(1, 1);
        this.singleSelectionBean.setSelection(this.getRowValue(0));
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setUIControl(null);
        ridget.updateSingleSelectionFromModel();
        ridget.setUIControl((Object)this.getWidget());
        UITestHelper.readAndDispatch((Widget)this.getWidget());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromRidgetOnRebind() {
        ISelectableIndexedRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(2, 2);
        ridget.setUIControl(null);
        this.clearUIControlRowSelection();
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setUIControl((Object)this.getWidget());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        AbstractTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRow());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        AbstractTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testSelectionEventsSelectionTypeSingle() {
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        List<Object> oldSelection = Collections.EMPTY_LIST;
        List<Object> newSelection = Arrays.asList(this.person1);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection(0);
        this.verifyPropertyChangeEvents();
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Collections.EMPTY_LIST);
        this.verifyPropertyChangeEvents();
        oldSelection = Collections.EMPTY_LIST;
        newSelection = Arrays.asList(this.person2);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(new int[]{1, 2});
        this.verifyPropertyChangeEvents();
    }

    public void testSelectionEventsSelectionTypeMulti() {
        if (!this.supportsMulti()) {
            return;
        }
        ISelectableIndexedRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        AbstractTableRidgetTest.assertNull((Object)this.singleSelectionBean.getSelection());
        AbstractTableRidgetTest.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        AbstractTableRidgetTest.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        List<Object> oldSelection = Collections.EMPTY_LIST;
        List<Object> newSelection = Arrays.asList(this.person1);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection(0);
        this.verifyPropertyChangeEvents();
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Collections.EMPTY_LIST);
        this.verifyPropertyChangeEvents();
        oldSelection = Collections.EMPTY_LIST;
        newSelection = Arrays.asList(this.person2, this.person3);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(new int[]{1, 2});
        this.verifyPropertyChangeEvents();
    }

    public void testIndexOfOption() {
        ISelectableIndexedRidget ridget = this.getRidget();
        AbstractTableRidgetTest.assertEquals((int)-1, (int)ridget.indexOfOption(null));
        AbstractTableRidgetTest.assertEquals((int)-1, (int)ridget.indexOfOption(new Object()));
        AbstractTableRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        AbstractTableRidgetTest.assertEquals((int)1, (int)ridget.indexOfOption((Object)this.person2));
        AbstractTableRidgetTest.assertEquals((int)2, (int)ridget.indexOfOption((Object)this.person3));
    }

    public void testGetOption() {
        ISelectableIndexedRidget ridget = this.getRidget();
        try {
            ridget.getOption(-1);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            int tooBig = this.manager.getPersons().size() + 1;
            ridget.getOption(tooBig);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        AbstractTableRidgetTest.assertSame((Object)this.person1, (Object)ridget.getOption(0));
        AbstractTableRidgetTest.assertSame((Object)this.person2, (Object)ridget.getOption(1));
        AbstractTableRidgetTest.assertSame((Object)this.person3, (Object)ridget.getOption(2));
    }

    public void testGetOptionCount() {
        ISelectableIndexedRidget ridget = this.getRidget();
        int oldCount = this.manager.getPersons().size();
        AbstractTableRidgetTest.assertEquals((int)oldCount, (int)ridget.getOptionCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        AbstractTableRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        AbstractTableRidgetTest.assertEquals((int)oldCount, (int)ridget.getOptionCount());
        ridget.updateFromModel();
        AbstractTableRidgetTest.assertEquals((int)newCount, (int)ridget.getOptionCount());
    }

    public void testSetSelectionTypeNull() {
        ISelectableIndexedRidget ridget = this.getRidget();
        try {
            ridget.setSelectionType(null);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionTypeNONE() {
        ISelectableIndexedRidget ridget = this.getRidget();
        try {
            ridget.setSelectionType(ISelectableRidget.SelectionType.NONE);
            AbstractTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    protected abstract void clearUIControlRowSelection();

    protected abstract int getUIControlSelectedRowCount();

    protected abstract int getUIControlSelectedRow();

    protected abstract Object getRowValue(int var1);

    protected abstract int[] getSelectedRows();

    protected abstract int[] getUIControlSelectedRows();

    protected abstract void setUIControlRowSelection(int[] var1);

    protected abstract void setUIControlRowSelectionInterval(int var1, int var2);

    protected abstract boolean supportsMulti();

    protected final void fireSelectionEvent() {
        UITestHelper.fireSelectionEvent((Widget)this.getWidget());
    }

    private Collection<Person> createPersonList() {
        ArrayList<Person> newList = new ArrayList<Person>();
        Person person = new Person("Doe", "John");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Janet");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Jermaine");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "John");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("JJ Jr. Shabadoo", "Joey");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Johnson", "Jack");
        person.setEyeColor(2);
        newList.add(person);
        person = new Person("Johnson", "Jane");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Zappa", "Frank");
        person.setEyeColor(2);
        newList.add(person);
        return newList;
    }
}

