/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.BrowserRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.listener.ILocationListener;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BrowserRidgetTest
extends AbstractSWTRidgetTest {
    protected Browser createWidget(Composite parent) {
        return new Browser(parent, 0);
    }

    protected IBrowserRidget createRidget() {
        return new BrowserRidget();
    }

    protected Browser getWidget() {
        return (Browser)super.getWidget();
    }

    protected IBrowserRidget getRidget() {
        return (IBrowserRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        BrowserRidgetTest.assertSame(BrowserRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetFocusable() {
        this.ok();
    }

    public void testRequestFocus() {
        this.ok();
    }

    public void testBindToModel() {
        IBrowserRidget ridget = this.getRidget();
        StringBean bean = new StringBean("http://www.redview.org");
        ridget.bindToModel((Object)bean, "value");
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
        bean.setValue("http://www.eclipse.org");
        BrowserRidgetTest.assertEquals((String)"http://www.eclipse.org", (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)"http://www.eclipse.org", (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)"http://www.eclipse.org", (String)ridget.getUrl());
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
    }

    public void testSetText() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setText("<html><body><h1>Riena</h1></body></html>");
        BrowserRidgetTest.assertEquals((String)"<html><body><h1>Riena</h1></body></html>", (String)ridget.getText());
        ridget.setText("");
        BrowserRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText(null);
        BrowserRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testSetTextClearsUrl() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setUrl("http://eclipse.org");
        ridget.setText("<html><body><p>riena</p></body></html>");
        BrowserRidgetTest.assertEquals(null, (String)ridget.getUrl());
        BrowserRidgetTest.assertEquals((String)"<html><body><p>riena</p></body></html>", (String)ridget.getText());
    }

    public void testSetTextOnOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        BrowserRidgetTest.assertNull((Object)ridget.getText());
        ridget.setOutputOnly(true);
        ridget.setText("<hmtl><body><h2>Riena</h2></body></html>");
        UITestHelper.readAndDispatch((Widget)control);
        BrowserRidgetTest.assertEquals((String)"<hmtl><body><h2>Riena</h2></body></html>", (String)ridget.getText());
        BrowserRidgetTest.assertTrue((String)("control.text:" + control.getText()), (boolean)control.getText().contains("Riena"));
    }

    public void testSetUrl() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
        ridget.setUrl("b o g u s");
        BrowserRidgetTest.assertEquals((String)"b o g u s", (String)ridget.getUrl());
        ridget.setUrl("");
        BrowserRidgetTest.assertEquals((String)"", (String)ridget.getUrl());
        ridget.setUrl(null);
        BrowserRidgetTest.assertEquals(null, (String)ridget.getUrl());
        ridget.setUrl("about:blank");
        BrowserRidgetTest.assertEquals((String)"about:blank", (String)ridget.getUrl());
    }

    public void testSetUrlClearsText() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setText("riena");
        ridget.setUrl("http://eclipse.org");
        BrowserRidgetTest.assertEquals((String)"http://eclipse.org", (String)ridget.getUrl());
        BrowserRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testSetUrlOnOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.setOutputOnly(true);
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
    }

    public void testSettersFireUrlEvents() {
        IBrowserRidget ridget = this.getRidget();
        String oldValue = ridget.getUrl();
        BrowserRidgetTest.assertFalse((boolean)"http://www.redview.org".equals(ridget.getUrl()));
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "urlInternal", oldValue, "http://www.redview.org"), new PropertyChangeEvent(ridget, "url", oldValue, "http://www.redview.org"));
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "urlInternal", "http://www.redview.org", null), new PropertyChangeEvent(ridget, "url", "http://www.redview.org", null));
        ridget.setText("<html><body><h1>h1</h1></body></html>");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setText("<html><body><h1>h1</h1></body></html>");
        this.verifyPropertyChangeEvents();
    }

    public void testApplyTextOnRebind() throws Exception {
        IBrowserRidget ridget = this.getRidget();
        final Browser control1 = this.getWidget();
        ridget.setText("<html><body><h1>Riena</h1></body></html>");
        UITestHelper.readAndDispatch((Widget)control1);
        this.retry(new Runnable(){

            public void run() {
                BrowserRidgetTest.assertTrue((String)("control1.text:" + control1.getText()), (boolean)control1.getText().contains("Riena"));
            }
        }, (Control)control1, 3);
        final Browser control2 = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control2);
        UITestHelper.readAndDispatch((Widget)control2);
        this.retry(new Runnable(){

            public void run() {
                BrowserRidgetTest.assertTrue((String)("control2.text:" + control2.getText()), (boolean)control2.getText().contains("Riena"));
            }
        }, (Control)control2, 3);
    }

    public void testAddLocationListener() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        LocationListener intLocLi = (LocationListener)ReflectionUtils.getHidden((Object)ridget, (String)"internalLocationListener");
        intLocLi.changing(this.createLocationEvent(control, ""));
        FTLocationChangingListener changingListener = new FTLocationChangingListener();
        ridget.addLocationListener((ILocationListener)changingListener);
        ridget.addLocationListener((ILocationListener)changingListener);
        FTLocationChangedListener changedListener = new FTLocationChangedListener();
        ridget.addLocationListener((ILocationListener)changedListener);
        ridget.addLocationListener((ILocationListener)changedListener);
        intLocLi.changing(this.createLocationEvent(control, "http://www.eclipse.org"));
        BrowserRidgetTest.assertEquals((int)1, (int)changingListener.getCount());
        BrowserRidgetTest.assertEquals((String)"http://www.eclipse.org", (String)changingListener.getLocation());
        BrowserRidgetTest.assertEquals((int)0, (int)changedListener.getCount());
        intLocLi.changed(this.createLocationEvent(control, "http://www.eclipse.org"));
        BrowserRidgetTest.assertEquals((int)1, (int)changingListener.getCount());
        BrowserRidgetTest.assertEquals((int)1, (int)changedListener.getCount());
        BrowserRidgetTest.assertEquals((String)"http://www.eclipse.org", (String)changedListener.getLocation());
        ridget.removeLocationListener((ILocationListener)changingListener);
        intLocLi.changing(this.createLocationEvent(control, "http://www.eclipse.org/riena"));
        BrowserRidgetTest.assertEquals((int)1, (int)changingListener.getCount());
        BrowserRidgetTest.assertEquals((int)1, (int)changedListener.getCount());
        ridget.removeLocationListener((ILocationListener)changedListener);
        intLocLi.changed(this.createLocationEvent(control, "http://www.eclipse.org/riena"));
        BrowserRidgetTest.assertEquals((int)1, (int)changingListener.getCount());
        BrowserRidgetTest.assertEquals((int)1, (int)changedListener.getCount());
    }

    public void testSettersDoNotNotifyLocationListeners() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        LocationListener intLocLi = (LocationListener)ReflectionUtils.getHidden((Object)ridget, (String)"internalLocationListener");
        intLocLi.changing(this.createLocationEvent(control, ""));
        FTLocationChangingListener listener = new FTLocationChangingListener();
        ridget.addLocationListener((ILocationListener)listener);
        BrowserRidgetTest.assertEquals((int)0, (int)listener.getCount());
        ridget.setUrl("http://www.eclipse.org");
        BrowserRidgetTest.assertEquals((int)0, (int)listener.getCount());
        ridget.setText("<html><body><h1>Hello</h1></body></html>");
        BrowserRidgetTest.assertEquals((int)0, (int)listener.getCount());
    }

    public void testBlockFromLocationListener() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        LocationListener intLocLi = (LocationListener)ReflectionUtils.getHidden((Object)ridget, (String)"internalLocationListener");
        intLocLi.changing(this.createLocationEvent(control, ""));
        FTLocationChangingListener blockListener = new FTLocationChangingListener(){

            public boolean locationChanging(org.eclipse.riena.ui.ridgets.listener.LocationEvent event) {
                super.locationChanging(event);
                return false;
            }
        };
        ridget.addLocationListener((ILocationListener)blockListener);
        FTLocationChangingListener listener = new FTLocationChangingListener();
        ridget.addLocationListener((ILocationListener)listener);
        LocationEvent event = this.createLocationEvent(control, "http://www.eclipse.org");
        intLocLi.changing(event);
        BrowserRidgetTest.assertEquals((int)1, (int)blockListener.getCount());
        BrowserRidgetTest.assertEquals((int)1, (int)listener.getCount());
        BrowserRidgetTest.assertFalse((boolean)listener.isAllowed());
        BrowserRidgetTest.assertFalse((boolean)event.doit);
        ridget.removeLocationListener((ILocationListener)blockListener);
        event = this.createLocationEvent(control, "http://www.eclipse.org");
        intLocLi.changing(event);
        BrowserRidgetTest.assertEquals((int)1, (int)blockListener.getCount());
        BrowserRidgetTest.assertEquals((int)2, (int)listener.getCount());
        BrowserRidgetTest.assertTrue((boolean)listener.isAllowed());
        BrowserRidgetTest.assertTrue((boolean)event.doit);
    }

    public void testBlockWhenOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        LocationListener intLocLi = (LocationListener)ReflectionUtils.getHidden((Object)ridget, (String)"internalLocationListener");
        intLocLi.changing(this.createLocationEvent(control, ""));
        FTLocationChangingListener listener = new FTLocationChangingListener();
        ridget.addLocationListener((ILocationListener)listener);
        ridget.setOutputOnly(true);
        LocationEvent event = this.createLocationEvent(control, "http://www.eclipse.org");
        intLocLi.changing(event);
        BrowserRidgetTest.assertFalse((boolean)event.doit);
        BrowserRidgetTest.assertEquals((int)0, (int)listener.getCount());
        ridget.setOutputOnly(false);
        event = this.createLocationEvent(control, "http://www.eclipse.org");
        intLocLi.changing(event);
        BrowserRidgetTest.assertTrue((boolean)event.doit);
        BrowserRidgetTest.assertEquals((int)1, (int)listener.getCount());
    }

    private LocationEvent createLocationEvent(Browser control, String location) {
        LocationEvent event = new LocationEvent((Widget)control);
        event.location = location;
        event.top = true;
        event.doit = true;
        return event;
    }

    private void retry(Runnable op, Control withControl, int tries) throws Exception {
        while (tries > 0) {
            try {
                op.run();
                tries = 0;
            }
            catch (Exception exc) {
                if (--tries > 0) {
                    Thread.sleep(500L);
                    UITestHelper.readAndDispatch((Widget)withControl);
                    continue;
                }
                throw exc;
            }
            catch (Error error) {
                if (--tries > 0) {
                    Thread.sleep(500L);
                    UITestHelper.readAndDispatch((Widget)withControl);
                    continue;
                }
                throw error;
            }
        }
    }

    private static class FTLocationChangedListener
    implements ILocationListener {
        private int countChanged;
        private org.eclipse.riena.ui.ridgets.listener.LocationEvent event;

        private FTLocationChangedListener() {
        }

        public int getCount() {
            return this.countChanged;
        }

        public String getLocation() {
            return this.event.getLocation();
        }

        public boolean locationChanging(org.eclipse.riena.ui.ridgets.listener.LocationEvent event) {
            return true;
        }

        public void locationChanged(org.eclipse.riena.ui.ridgets.listener.LocationEvent event) {
            ++this.countChanged;
            this.event = event;
        }
    }

    private static class FTLocationChangingListener
    implements ILocationListener {
        private int countChanging;
        private org.eclipse.riena.ui.ridgets.listener.LocationEvent event;

        private FTLocationChangingListener() {
        }

        public boolean isAllowed() {
            return this.event.isAllowed();
        }

        public int getCount() {
            return this.countChanging;
        }

        public String getLocation() {
            return this.event.getLocation();
        }

        public boolean locationChanging(org.eclipse.riena.ui.ridgets.listener.LocationEvent event) {
            ++this.countChanging;
            this.event = event;
            return true;
        }

        public void locationChanged(org.eclipse.riena.ui.ridgets.listener.LocationEvent event) {
        }

        /* synthetic */ FTLocationChangingListener(FTLocationChangingListener fTLocationChangingListener, FTLocationChangingListener fTLocationChangingListener2) {
            this();
        }
    }
}

