/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.TypedBean;
import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTimeRidget;
import org.eclipse.riena.internal.ui.swt.test.TestUtils;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;

public class DateTimeRidgetTest
extends AbstractSWTRidgetTest {
    protected IRidget createRidget() {
        return new DateTimeRidget();
    }

    protected IDateTimeRidget getRidget() {
        return (IDateTimeRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        return new DateTime((Composite)this.getShell(), 65568);
    }

    protected DateTime getWidget() {
        return (DateTime)super.getWidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        DateTimeRidgetTest.assertSame(DateTimeRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetDate() {
        IDateTimeRidget ridget = this.getRidget();
        DateTime control = this.getWidget();
        TypedBean dateBean = new TypedBean(null);
        this.expectNoPropertyChangeEvent();
        ridget.bindToModel((Object)dateBean, "value");
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals(null, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals(null, (Object)dateBean.getValue());
        Date date2001 = this.createDate(2001, 12, 2);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "dateInternal", null, date2001), new PropertyChangeEvent(ridget, "date", null, date2001));
        ridget.setDate(date2001);
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((Object)date2001, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((Object)date2001, (Object)dateBean.getValue());
        DateTimeRidgetTest.assertEquals((String)"12/2/2001", (String)this.getDate(control));
        Date date1800 = this.createDate(1800, 1, 1);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "dateInternal", date2001, date1800), new PropertyChangeEvent(ridget, "date", date2001, date1800));
        ridget.setDate(date1800);
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((Object)date1800, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((Object)date1800, (Object)dateBean.getValue());
        DateTimeRidgetTest.assertEquals((String)"1/1/1800", (String)this.getDate(control));
    }

    public void testSetDateNull() {
        IDateTimeRidget ridget = this.getRidget();
        DateTime control = this.getWidget();
        TypedBean dateBean = new TypedBean((Object)new Date());
        ridget.bindToModel((Object)dateBean, "value");
        ridget.updateFromModel();
        ridget.setDate(null);
        DateTimeRidgetTest.assertEquals(null, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)this.asStringEmptyDate(), (String)this.getDate(control));
        DateTimeRidgetTest.assertEquals(null, (Object)dateBean.getValue());
    }

    public void testUpdateFromModel() {
        IDateTimeRidget ridget = this.getRidget();
        DateTime control = this.getWidget();
        Date date2000 = this.createDate(2000, 1, 1);
        Date date2001 = this.createDate(2001, 12, 2);
        TypedBean dateBean = new TypedBean((Object)date2000);
        ridget.bindToModel((Object)dateBean, "value");
        DateTimeRidgetTest.assertEquals(null, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)this.asStringEmptyDate(), (String)this.getDate(control));
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "dateInternal", null, date2000), new PropertyChangeEvent(ridget, "date", null, date2000));
        ridget.updateFromModel();
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((Object)date2000, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)"1/1/2000", (String)this.getDate(control));
        this.expectNoPropertyChangeEvent();
        dateBean.setValue((Object)date2001);
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((Object)date2000, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)"1/1/2000", (String)this.getDate(control));
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "dateInternal", date2000, date2001), new PropertyChangeEvent(ridget, "date", date2000, date2001));
        ridget.updateFromModel();
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((Object)date2001, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)"12/2/2001", (String)this.getDate(control));
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "dateInternal", date2001, null), new PropertyChangeEvent(ridget, "date", date2001, null));
        dateBean.setValue(null);
        ridget.updateFromModel();
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals(null, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((String)this.asStringEmptyDate(), (String)this.getDate(control));
    }

    public void testWidgetModification() {
        String input;
        PropertyChangeEvent[] events = new PropertyChangeEvent[6];
        String country = Locale.getDefault().getCountry();
        if ("DE".equals(country)) {
            events[0] = this.createPropertyChangeEvent("dateInternal", 2001, 12, 1, 2001, 12, 10);
            events[1] = this.createPropertyChangeEvent("date", 2001, 12, 1, 2001, 12, 10);
            events[2] = this.createPropertyChangeEvent("dateInternal", 2001, 12, 10, 2001, 4, 10);
            events[3] = this.createPropertyChangeEvent("date", 2001, 12, 10, 2001, 4, 10);
            events[4] = this.createPropertyChangeEvent("dateInternal", 2001, 4, 10, 2009, 4, 10);
            events[5] = this.createPropertyChangeEvent("date", 2001, 4, 10, 2009, 4, 10);
            input = "10.04.2009";
        } else if ("US".equals(country)) {
            events[0] = this.createPropertyChangeEvent("dateInternal", 2001, 12, 1, 2001, 4, 1);
            events[1] = this.createPropertyChangeEvent("date", 2001, 12, 1, 2001, 4, 1);
            events[2] = this.createPropertyChangeEvent("dateInternal", 2001, 4, 1, 2001, 4, 10);
            events[3] = this.createPropertyChangeEvent("date", 2001, 4, 1, 2001, 4, 10);
            events[4] = this.createPropertyChangeEvent("dateInternal", 2001, 4, 10, 2009, 4, 10);
            events[5] = this.createPropertyChangeEvent("date", 2001, 4, 10, 2009, 4, 10);
            input = "04/10/2009";
        } else {
            System.out.println("Skipping DateTimeRidgetTest#testWidgetModification()");
            return;
        }
        IDateTimeRidget ridget = this.getRidget();
        DateTime control = this.getWidget();
        Date date2001 = this.createDate(2001, 12, 1);
        TypedBean dateBean = new TypedBean((Object)date2001);
        ridget.bindToModel((Object)dateBean, "value");
        ridget.updateFromModel();
        DateTimeRidgetTest.assertEquals((Object)date2001, (Object)ridget.getDate());
        DateTimeRidgetTest.assertEquals((Object)date2001, (Object)dateBean.getValue());
        this.expectPropertyChangeEvents(events);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)input);
        this.verifyPropertyChangeEvents();
        DateTimeRidgetTest.assertEquals((String)"4/10/2009", (String)this.asString(ridget.getDate()));
        DateTimeRidgetTest.assertEquals((String)"4/10/2009", (String)this.asString((Date)dateBean.getValue()));
    }

    public void testMandatoryMarker() {
        IDateTimeRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        DateTimeRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)true);
    }

    public void testControlEnablement() {
        IDateTimeRidget ridget = this.getRidget();
        DateTime control = this.getWidget();
        DateTimeRidgetTest.assertTrue((boolean)control.isEnabled());
        ridget.setEnabled(false);
        DateTimeRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        DateTimeRidgetTest.assertTrue((boolean)control.isEnabled());
        ridget.setOutputOnly(true);
        ridget.setEnabled(false);
        ridget.setEnabled(true);
        DateTimeRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(false);
        ridget.setOutputOnly(false);
        DateTimeRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        DateTimeRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testValidationUpdateFromModelOnUpdateRules() {
        this.handleValidationUpdateFromModel(ValidationTime.ON_UPDATE_TO_MODEL);
    }

    public void testValidationUpdateFromModelOnEditRules() {
        this.handleValidationUpdateFromModel(ValidationTime.ON_UI_CONTROL_EDIT);
    }

    public void testValidationSetDateOnUpdateRules() {
        this.handleValidationSetDate(ValidationTime.ON_UPDATE_TO_MODEL);
    }

    public void testValidationSetDateOnEditRules() {
        this.handleValidationSetDate(ValidationTime.ON_UI_CONTROL_EDIT);
    }

    public void testValidationWidgetModificationOnUpdateRules() {
        String country = Locale.getDefault().getCountry();
        if ("DE".equals(country)) {
            this.handleValidationWidgetModification(ValidationTime.ON_UPDATE_TO_MODEL, "10.04.2009");
        } else if ("US".equals(country)) {
            this.handleValidationWidgetModification(ValidationTime.ON_UPDATE_TO_MODEL, "04/10/2009");
        } else {
            System.out.println("Skipping DateTimeRidgetTest#testValidation_WidgetModification_onUpdateRules");
        }
    }

    public void testValidationWidgetModificationOnEditRules() {
        String country = Locale.getDefault().getCountry();
        if ("DE".equals(country)) {
            this.handleValidationWidgetModification(ValidationTime.ON_UI_CONTROL_EDIT, "10.04.2009");
        } else if ("US".equals(country)) {
            this.handleValidationWidgetModification(ValidationTime.ON_UI_CONTROL_EDIT, "04/10/2009");
        } else {
            System.out.println("Skipping DateTimeRidgetTest#testValidation_WidgetModification_OnEditRules");
        }
    }

    public void testRevalidate() {
        IDateTimeRidget ridget = this.getRidget();
        FTValidator validator = new FTValidator(new Date(99L));
        ridget.addValidationRule((IValidator)validator, ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.setDate(new Date(99L));
        DateTimeRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)validator);
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.revalidate();
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    private String asString(Date date) {
        String result = "null";
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(date);
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            result = String.format("%s/%s/%s", month, day, year);
        }
        return result;
    }

    private String asStringEmptyDate() {
        return this.asString(new Date(0L));
    }

    private Date createDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month - 1, day, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, int oldYear, int oldMonth, int oldDay, int newYear, int newMonth, int newDay) {
        Date oldDate = this.createDate(oldYear, oldMonth, oldDay);
        Date newDate = this.createDate(newYear, newMonth, newDay);
        return new PropertyChangeEvent(this.getRidget(), propertyName, oldDate, newDate);
    }

    private String getDate(DateTime control) {
        int year = control.getYear();
        int month = control.getMonth() + 1;
        int day = control.getDay();
        return String.format("%s/%s/%s", month, day, year);
    }

    private void handleValidationUpdateFromModel(ValidationTime time) {
        IDateTimeRidget ridget = this.getRidget();
        FTValidator validator = new FTValidator(new Date(99L));
        ridget.addValidationRule((IValidator)validator, time);
        TypedBean dateBean = new TypedBean((Object)new Date(0L));
        ridget.bindToModel((Object)dateBean, "value");
        int count = validator.count;
        ridget.updateFromModel();
        DateTimeRidgetTest.assertTrue((count < validator.count ? 1 : 0) != 0);
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        count = validator.count;
        dateBean.setValue((Object)new Date(99L));
        ridget.updateFromModel();
        DateTimeRidgetTest.assertTrue((count < validator.count ? 1 : 0) != 0);
        DateTimeRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        DateTimeRidgetTest.assertEquals((Object)new Date(99L), (Object)ridget.getDate());
        count = validator.count;
        dateBean.setValue((Object)new Date(0L));
        ridget.updateFromModel();
        DateTimeRidgetTest.assertTrue((count < validator.count ? 1 : 0) != 0);
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    private void handleValidationSetDate(ValidationTime time) {
        IDateTimeRidget ridget = this.getRidget();
        FTValidator validator = new FTValidator(new Date(99L));
        ridget.addValidationRule((IValidator)validator, time);
        DateTimeRidgetTest.assertEquals((int)0, (int)validator.count);
        ridget.setDate(new Date(0L));
        DateTimeRidgetTest.assertEquals((int)1, (int)validator.count);
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setDate(new Date(99L));
        DateTimeRidgetTest.assertEquals((int)2, (int)validator.count);
        DateTimeRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        DateTimeRidgetTest.assertEquals((Object)new Date(99L), (Object)ridget.getDate());
        ridget.setDate(new Date(0L));
        DateTimeRidgetTest.assertEquals((int)3, (int)validator.count);
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    private void handleValidationWidgetModification(ValidationTime time, String input) {
        IDateTimeRidget ridget = this.getRidget();
        FTValidator validator = new FTValidator("4/10/2009");
        DateTime control = this.getWidget();
        ridget.addValidationRule((IValidator)validator, time);
        TypedBean dateBean = new TypedBean((Object)new Date(0L));
        ridget.bindToModel((Object)dateBean, "value");
        int count = validator.count;
        DateTimeRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)input);
        DateTimeRidgetTest.assertTrue((count < validator.count ? 1 : 0) != 0);
        DateTimeRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
    }

    public void testSetOutputOnly() {
        IDateTimeRidget ridget = (IDateTimeRidget)this.createRidget();
        DateTime control = (DateTime)this.createWidget((Composite)this.getShell());
        ridget.setOutputOnly(true);
        DateTimeRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        DateTimeRidgetTest.assertTrue((boolean)control.isEnabled());
        ridget.setUIControl((Object)control);
        ridget.addMarker((IMarker)new AbstractMarker(){});
        DateTimeRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        DateTimeRidgetTest.assertFalse((boolean)control.isEnabled());
    }

    private final class FTValidator
    implements IValidator {
        private int count = 0;
        private Date errorDate;
        private String errorString;

        FTValidator(Date errorValue) {
            this.errorDate = errorValue;
        }

        FTValidator(String errorValue) {
            this.errorString = errorValue;
        }

        public IStatus validate(Object value) {
            ++this.count;
            IStatus result = ValidationStatus.ok();
            if (this.errorDate != null && this.errorDate.equals(value)) {
                result = ValidationStatus.error((String)"error");
            }
            if (this.errorString != null && this.errorString.equals(DateTimeRidgetTest.this.asString((Date)value))) {
                result = ValidationStatus.error((String)"error");
            }
            return result;
        }
    }
}

