/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.DefaultActionManager;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class DefaultActionManagerTest
extends TestCase {
    private Display display;
    private Shell shell;
    private Text text1;
    private Text text2;
    private Button button1;
    private Button button2;
    private IWindowRidget rShell;
    private ITextRidget rText1;
    private ITextRidget rText2;
    private IActionRidget rButton1;
    private IActionRidget rButton2;
    private DefaultActionManager actionMan;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        this.shell = this.createUI(this.display);
        this.createRidgets();
        this.actionMan = new DefaultActionManager(this.rShell);
    }

    protected void tearDown() throws Exception {
        this.actionMan.dispose();
        this.shell.dispose();
    }

    public void testOneDefaultButton() {
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.actionMan.addAction((IRidget)this.rText2, this.rButton2);
        this.actionMan.activate();
        this.shell.open();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.rText2.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button2, (Object)this.shell.getDefaultButton());
        this.rText1.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals(null, (Object)this.shell.getDefaultButton());
    }

    public void testNestedDefaultButtons() {
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.actionMan.addAction((IRidget)this.rShell, this.rButton1);
        this.actionMan.addAction((IRidget)this.rText2, this.rButton2);
        this.actionMan.activate();
        this.shell.open();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button1, (Object)this.shell.getDefaultButton());
        this.rText2.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button2, (Object)this.shell.getDefaultButton());
        this.rText1.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button1, (Object)this.shell.getDefaultButton());
    }

    public void testDeactivateActivate() {
        this.actionMan.addAction((IRidget)this.rText1, this.rButton1);
        this.actionMan.activate();
        this.shell.open();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button1, (Object)this.shell.getDefaultButton());
        this.actionMan.deactivate();
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.actionMan.activate();
        DefaultActionManagerTest.assertEquals((Object)this.button1, (Object)this.shell.getDefaultButton());
    }

    public void testDispose() {
        this.actionMan.addAction((IRidget)this.rText1, this.rButton1);
        this.actionMan.activate();
        this.shell.open();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertEquals((Object)this.button1, (Object)this.shell.getDefaultButton());
        this.actionMan.dispose();
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.rText2.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
        this.rText1.requestFocus();
        UITestHelper.readAndDispatch((Widget)this.shell);
        DefaultActionManagerTest.assertNull((Object)this.shell.getDefaultButton());
    }

    private Shell createUI(Display display) {
        Shell result = new Shell(display, 16384);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)result);
        this.text1 = new Text((Composite)result, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text1);
        this.button1 = new Button((Composite)result, 8);
        this.button1.setText("button1");
        GridDataFactory.fillDefaults().applyTo((Control)this.button1);
        this.text2 = new Text((Composite)result, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text2);
        this.button2 = new Button((Composite)result, 8);
        this.button2.setText("button2");
        GridDataFactory.fillDefaults().applyTo((Control)this.button2);
        result.setBounds(0, 0, 200, 200);
        result.layout();
        return result;
    }

    private void createRidgets() {
        this.rShell = (IWindowRidget)SwtRidgetFactory.createRidget((Object)this.shell);
        this.rText1 = (ITextRidget)SwtRidgetFactory.createRidget((Object)this.text1);
        this.rText1.setText("text1");
        this.rText2 = (ITextRidget)SwtRidgetFactory.createRidget((Object)this.text2);
        this.rText2.setText("text2");
        this.rButton1 = (IActionRidget)SwtRidgetFactory.createRidget((Object)this.button1);
        this.rButton2 = (IActionRidget)SwtRidgetFactory.createRidget((Object)this.button2);
    }
}

