/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.SingleChoiceRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public final class SingleChoiceRidgetTest
extends MarkableRidgetTest {
    private OptionProvider optionProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.optionProvider = new OptionProvider();
        this.getRidget().bindToModel((Object)this.optionProvider, "options", (Object)this.optionProvider, "selectedOption");
        this.getRidget().updateFromModel();
    }

    protected Control createWidget(Composite parent) {
        return new ChoiceComposite(parent, 0, false);
    }

    protected IRidget createRidget() {
        return new SingleChoiceRidget();
    }

    protected ChoiceComposite getWidget() {
        return (ChoiceComposite)super.getWidget();
    }

    protected ISingleChoiceRidget getRidget() {
        return (ISingleChoiceRidget)super.getRidget();
    }

    public void testHasFocus() throws Exception {
        ISingleChoiceRidget choiceRidget = this.getRidget();
        SingleChoiceRidgetTest.assertNotNull((Object)choiceRidget);
        ChoiceComposite widget = this.getWidget();
        SingleChoiceRidgetTest.assertNotNull((Object)widget);
        SingleChoiceRidgetTest.assertFalse((boolean)choiceRidget.hasFocus());
        this.getRidget().setUIControl((Object)widget);
        widget.getChildren()[0].setFocus();
        SingleChoiceRidgetTest.assertTrue((boolean)this.getRidget().hasFocus());
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        SingleChoiceRidgetTest.assertSame(SingleChoiceRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testGetObservableList() {
        ISingleChoiceRidget ridget = this.getRidget();
        SingleChoiceRidgetTest.assertNotNull((Object)ridget.getObservableList());
    }

    public void testUpdateFromModel() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.updateFromModel();
        int oldSize = this.optionProvider.getOptions().size();
        SingleChoiceRidgetTest.assertEquals((int)oldSize, (int)ridget.getObservableList().size());
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.getObservableList().containsAll(this.optionProvider.getOptions()));
        SingleChoiceRidgetTest.assertEquals((Object)this.optionProvider.getSelectedOption(), (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals((String)this.optionProvider.getSelectedOption(), (String)this.getSelectedControlValue(control));
        this.optionProvider.remove(0);
        SingleChoiceRidgetTest.assertEquals((int)oldSize, (int)ridget.getObservableList().size());
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals((int)(oldSize - 1), (int)ridget.getObservableList().size());
    }

    public void testGetUIControl() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        SingleChoiceRidgetTest.assertEquals((Object)control, (Object)ridget.getUIControl());
    }

    public void testSetSelection() {
        ISingleChoiceRidget ridget = this.getRidget();
        SingleChoiceRidgetTest.assertEquals((Object)this.optionProvider.getSelectedOption(), (Object)ridget.getSelection());
        ridget.setSelection((Object)this.optionProvider.getOptions().get(1));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        this.optionProvider.setSelectedOption(this.optionProvider.getOptions().get(0));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getOptions().get(1));
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getOptions().get(0));
    }

    public void testUpdateSelectionFromRidget() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        SingleChoiceRidgetTest.assertNotNull((Object)ridget.getSelection());
        Button selected1 = this.getSelectedControl(control);
        SingleChoiceRidgetTest.assertEquals((String)this.optionProvider.getSelectedOption(), (String)selected1.getText());
        SingleChoiceRidgetTest.assertSame((Object)this.optionProvider.getSelectedOption(), (Object)selected1.getData());
        String option2 = this.optionProvider.getOptions().get(1);
        ridget.setSelection((Object)option2);
        Button selected2 = this.getSelectedControl(control);
        SingleChoiceRidgetTest.assertNotSame((Object)selected1, (Object)selected2);
        SingleChoiceRidgetTest.assertEquals((String)this.optionProvider.getSelectedOption(), (String)selected2.getText());
        SingleChoiceRidgetTest.assertSame((Object)this.optionProvider.getSelectedOption(), (Object)selected2.getData());
    }

    public void testClearSelectionWhenSelectionIsRemovedFromModel() {
        ISingleChoiceRidget ridget = this.getRidget();
        String optionA = this.optionProvider.getOptions().get(0);
        ridget.setSelection((Object)optionA);
        SingleChoiceRidgetTest.assertSame((Object)optionA, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertSame((Object)optionA, (Object)this.optionProvider.getSelectedOption());
        this.optionProvider.getOptions().remove(0);
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals(null, (String)this.optionProvider.getSelectedOption());
    }

    public void testUpdateSelectionFromControl() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        Button button0 = (Button)control.getChildren()[0];
        Button button1 = (Button)control.getChildren()[1];
        SingleChoiceRidgetTest.assertTrue((boolean)button0.getSelection());
        SingleChoiceRidgetTest.assertFalse((boolean)button1.getSelection());
        button1.setSelection(true);
        Event event = new Event();
        event.type = 13;
        event.widget = button1;
        button1.notifyListeners(13, event);
        SingleChoiceRidgetTest.assertFalse((boolean)button0.getSelection());
        SingleChoiceRidgetTest.assertTrue((boolean)button1.getSelection());
        SingleChoiceRidgetTest.assertEquals((Object)this.optionProvider.getOptions().get(1), (Object)ridget.getSelection());
    }

    public void testColorsAreAppliedToChildren() {
        Shell shell = this.getShell();
        ChoiceComposite control = new ChoiceComposite((Composite)shell, 0, false);
        Color colorRed = shell.getDisplay().getSystemColor(3);
        Color colorGreen = shell.getDisplay().getSystemColor(5);
        control.setForeground(colorGreen);
        control.setBackground(colorRed);
        this.getRidget().setUIControl((Object)control);
        Button selected = this.getSelectedControl(control);
        SingleChoiceRidgetTest.assertEquals((Object)colorGreen, (Object)selected.getForeground());
        SingleChoiceRidgetTest.assertEquals((Object)colorRed, (Object)selected.getBackground());
    }

    public void testEnablementIsAppliedToChildren() {
        Shell shell = this.getShell();
        ChoiceComposite control = new ChoiceComposite((Composite)shell, 0, false);
        SingleChoiceRidgetTest.assertTrue((boolean)control.isEnabled());
        this.getRidget().setEnabled(false);
        this.getRidget().setUIControl((Object)control);
        SingleChoiceRidgetTest.assertFalse((boolean)control.isEnabled());
        SingleChoiceRidgetTest.assertTrue((control.getChildren().length > 0 ? 1 : 0) != 0);
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            SingleChoiceRidgetTest.assertFalse((boolean)((Button)child).isEnabled());
            ++n2;
        }
    }

    public void testAddRemovePropertyChangeListener() {
        ISingleChoiceRidget ridget = this.getRidget();
        TestPropertyChangeListener listener = new TestPropertyChangeListener();
        ridget.updateFromModel();
        ridget.addPropertyChangeListener((PropertyChangeListener)listener);
        SingleChoiceRidgetTest.assertEquals((Object)this.optionProvider.getSelectedOption(), (Object)ridget.getSelection());
        ridget.setSelection((Object)this.optionProvider.getOptions().get(1));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((int)1, (int)listener.eventCounter);
        ridget.removePropertyChangeListener((PropertyChangeListener)listener);
        ridget.setSelection((Object)this.optionProvider.getOptions().get(0));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((int)1, (int)listener.eventCounter);
    }

    public void testBindToModelUsingLabels() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        this.optionProvider = new OptionProvider();
        ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), (Object)this.optionProvider, "selectedOption");
        ridget.updateFromModel();
        Object[] labels = this.optionProvider.getOptionLabels().toArray();
        Control[] children = control.getChildren();
        SingleChoiceRidgetTest.assertEquals((int)labels.length, (int)children.length);
        int i = 0;
        while (i < labels.length) {
            String label = (String)labels[i];
            String caption = ((Button)children[i]).getText();
            SingleChoiceRidgetTest.assertEquals((String)label, (String)caption);
            ++i;
        }
    }

    public void testDisableMandatoryMarkers() {
        ISingleChoiceRidget ridget = this.getRidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        this.optionProvider.setSelectedOption(null);
        ridget.updateFromModel();
        ridget.addMarker((IMarker)mandatoryMarker);
        SingleChoiceRidgetTest.assertFalse((boolean)mandatoryMarker.isDisabled());
        ridget.setSelection((Object)this.optionProvider.getOptions().get(1));
        SingleChoiceRidgetTest.assertTrue((boolean)mandatoryMarker.isDisabled());
        ridget.setSelection(null);
        SingleChoiceRidgetTest.assertFalse((boolean)mandatoryMarker.isDisabled());
    }

    public void testIsDisableMandatoryMarker() {
        ISingleChoiceRidget ridget = this.getRidget();
        this.optionProvider.setSelectedOption(null);
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection((Object)this.optionProvider.getOptions().get(1));
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection(null);
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testBindToModelWithObservables() {
        ISingleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, PojoObservables.observeValue((Object)this.optionProvider, (String)"selectedOption"));
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.optionProvider, (String)"options"), null);
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithBeans() {
        ISingleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, "options", (Object)this.optionProvider, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, null, (Object)this.optionProvider, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, "options", null, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, "options", (Object)this.optionProvider, null);
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithOptionLabelList() {
        ISingleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, this.optionProvider.getOptionLabels(), (Object)this.optionProvider, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), null, (Object)this.optionProvider, "selectedOption");
        }
        catch (RuntimeException runtimeException) {
            SingleChoiceRidgetTest.fail();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), new ArrayList(), (Object)this.optionProvider, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), null, "selectedOption");
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), (Object)this.optionProvider, null);
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testOutputCannotBeChangedFromUI() {
        ISingleChoiceRidget ridget = this.getRidget();
        Button button1 = (Button)this.getWidget().getChildren()[0];
        Button button2 = (Button)this.getWidget().getChildren()[1];
        SingleChoiceRidgetTest.assertTrue((boolean)button1.getSelection());
        SingleChoiceRidgetTest.assertFalse((boolean)button2.getSelection());
        SingleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)ridget.getSelection());
        ridget.setOutputOnly(true);
        button2.setFocus();
        UITestHelper.sendString((Display)button2.getDisplay(), (String)" ");
        SingleChoiceRidgetTest.assertTrue((boolean)button1.getSelection());
        SingleChoiceRidgetTest.assertFalse((boolean)button2.getSelection());
        SingleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)ridget.getSelection());
        ridget.setOutputOnly(false);
        button2.setFocus();
        UITestHelper.sendString((Display)button2.getDisplay(), (String)" ");
        SingleChoiceRidgetTest.assertFalse((boolean)button1.getSelection());
        SingleChoiceRidgetTest.assertTrue((boolean)button2.getSelection());
        SingleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)ridget.getSelection());
    }

    public void testDisabledRidgetDoesNotCheckControlOnRidgetSelection() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setSelection((Object)"Option A");
        SingleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.getSelectedControlValue(control));
        ridget.setEnabled(false);
        SingleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)ridget.getSelection());
        String expectedA = MarkerSupport.isHideDisabledRidgetContent() ? null : "Option A";
        SingleChoiceRidgetTest.assertEquals((String)expectedA, (String)this.getSelectedControlValue(control));
        ridget.setSelection((Object)"Option B");
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)ridget.getSelection());
        String expectedB = MarkerSupport.isHideDisabledRidgetContent() ? null : "Option B";
        SingleChoiceRidgetTest.assertEquals((String)expectedB, (String)this.getSelectedControlValue(control));
        ridget.setEnabled(true);
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.getSelectedControlValue(control));
    }

    public void testDisabledRidgetDoesNotCheckControlOnModelSelection() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setEnabled(false);
        this.optionProvider.setSelectedOption("Option A");
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)ridget.getSelection());
        String expectedA = MarkerSupport.isHideDisabledRidgetContent() ? null : "Option A";
        SingleChoiceRidgetTest.assertEquals((String)expectedA, (String)this.getSelectedControlValue(control));
        this.optionProvider.setSelectedOption("Option B");
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)ridget.getSelection());
        String expectedB = MarkerSupport.isHideDisabledRidgetContent() ? null : "Option B";
        SingleChoiceRidgetTest.assertEquals((String)expectedB, (String)this.getSelectedControlValue(control));
        ridget.setEnabled(true);
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.getSelectedControlValue(control));
    }

    public void testDisabledDoesNotFireSelected() {
        ISingleChoiceRidget ridget = this.getRidget();
        ridget.setEnabled(true);
        ridget.setSelection((Object)"Option A");
        ridget.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SingleChoiceRidgetTest.fail((String)("Unexpected property change event: " + evt));
            }
        });
        ridget.setEnabled(false);
        ridget.setEnabled(true);
    }

    public void testDisableAndClearOnBind() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        ridget.setSelection((Object)"Option B");
        ridget.setUIControl((Object)control);
        SingleChoiceRidgetTest.assertFalse((boolean)control.isEnabled());
        String expectedB = MarkerSupport.isHideDisabledRidgetContent() ? null : "Option B";
        SingleChoiceRidgetTest.assertEquals((String)expectedB, (String)this.getSelectedControlValue(control));
        ridget.setEnabled(true);
        SingleChoiceRidgetTest.assertTrue((boolean)control.isEnabled());
        SingleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.getSelectedControlValue(control));
    }

    public void testBug255465() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        List<String> values = Arrays.asList("male", "female");
        List<String> labels = Arrays.asList("Man", "Woman");
        Person personEntity = new Person("Max", "Mustermann");
        personEntity.setGender("male");
        ridget.bindToModel(values, labels, (Object)personEntity, "gender");
        ridget.updateFromModel();
        SingleChoiceRidgetTest.assertEquals((String)"male", (String)this.getSelectedControlValue(control));
    }

    public void testAddSelectionListener() {
        ISingleChoiceRidget ridget = this.getRidget();
        try {
            ridget.addSelectionListener(null);
            SingleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        SingleChoiceRidgetTest.assertEquals((Object)this.optionProvider.getSelectedOption(), (Object)ridget.getSelection());
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.optionProvider.getOptions().get(1));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.setSelection((Object)this.optionProvider.getOptions().get(2));
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection(null);
        SingleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
    }

    public void testToggleDisabledWhenOutputOnly() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        Button btnFirst = (Button)control.getChildren()[0];
        String first = this.optionProvider.getOptions().get(0);
        ridget.setSelection((Object)first);
        SingleChoiceRidgetTest.assertTrue((boolean)btnFirst.getSelection());
        ridget.setOutputOnly(true);
        ridget.setEnabled(false);
        ridget.setEnabled(true);
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Button button = (Button)child;
            if (button == btnFirst) {
                SingleChoiceRidgetTest.assertTrue((boolean)btnFirst.isEnabled());
                SingleChoiceRidgetTest.assertTrue((boolean)btnFirst.getSelection());
            } else {
                SingleChoiceRidgetTest.assertFalse((boolean)button.isEnabled());
                SingleChoiceRidgetTest.assertFalse((boolean)button.getSelection());
            }
            ++n2;
        }
    }

    public void testSelectionWithOutputOnly() {
        ISingleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        String first = this.optionProvider.getOptions().get(0);
        String second = this.optionProvider.getOptions().get(1);
        ridget.setSelection((Object)first);
        SingleChoiceRidgetTest.assertEquals((Object)first, (Object)ridget.getSelection());
        ridget.setOutputOnly(true);
        ridget.setSelection((Object)second);
        SingleChoiceRidgetTest.assertEquals((Object)second, (Object)ridget.getSelection());
        Button btnSecond = (Button)control.getChildren()[1];
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Button button = (Button)child;
            if (button == btnSecond) {
                SingleChoiceRidgetTest.assertTrue((boolean)btnSecond.isEnabled());
                SingleChoiceRidgetTest.assertTrue((boolean)btnSecond.getSelection());
            } else {
                SingleChoiceRidgetTest.assertFalse((boolean)button.isEnabled());
                SingleChoiceRidgetTest.assertFalse((boolean)button.getSelection());
            }
            ++n2;
        }
    }

    public void testGetSetEmptySelectionItem() {
        ISingleChoiceRidget ridget = this.getRidget();
        String first = this.optionProvider.getOptions().get(0);
        String second = this.optionProvider.getOptions().get(1);
        ridget.setEmptySelectionItem((Object)first);
        ridget.addMarker((IMarker)new MandatoryMarker());
        SingleChoiceRidgetTest.assertEquals((Object)first, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertEquals((Object)first, (Object)ridget.getEmptySelectionItem());
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection((Object)second);
        SingleChoiceRidgetTest.assertEquals((Object)second, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection((Object)first);
        SingleChoiceRidgetTest.assertEquals((Object)first, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ridget.setEmptySelectionItem(null);
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setEmptySelectionItem((Object)second);
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection((Object)second);
        SingleChoiceRidgetTest.assertEquals((Object)second, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testEmptySelectionItemEqualsNull() {
        ISingleChoiceRidget ridget = this.getRidget();
        String optionNull = null;
        this.getRidget().bindToModel(new ArrayList<String>(Arrays.asList("Option A", "Option B", "Option C", "Option D", "Option E", "Option F", optionNull)), new ArrayList<String>(Arrays.asList("Option label A", "Option label B", "Option label C", "Option label D", "Option label E", "Option label F", "Option label Null")), (Object)this.optionProvider, "selectedOption");
        ridget.setEmptySelectionItem(optionNull);
        this.optionProvider.setSelectedOption(optionNull);
        ridget.addMarker((IMarker)new MandatoryMarker());
        this.getRidget().updateFromModel();
        SingleChoiceRidgetTest.assertEquals(optionNull, (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals(optionNull, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertTrue((boolean)"Option label Null".equals(this.getSelectedControl(this.getWidget()).getText()));
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        this.optionProvider.setSelectedOption("Option A");
        this.getRidget().updateFromModel();
        SingleChoiceRidgetTest.assertTrue((boolean)"Option A".equals(this.optionProvider.getSelectedOption()));
        SingleChoiceRidgetTest.assertTrue((boolean)"Option A".equals(ridget.getSelection()));
        SingleChoiceRidgetTest.assertTrue((boolean)"Option label A".equals(this.getSelectedControl(this.getWidget()).getText()));
        SingleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        this.optionProvider.setSelectedOption(optionNull);
        this.getRidget().updateFromModel();
        SingleChoiceRidgetTest.assertEquals(optionNull, (String)this.optionProvider.getSelectedOption());
        SingleChoiceRidgetTest.assertEquals(optionNull, (Object)ridget.getSelection());
        SingleChoiceRidgetTest.assertTrue((boolean)"Option label Null".equals(this.getSelectedControl(this.getWidget()).getText()));
        SingleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    private Button getSelectedControl(ChoiceComposite control) {
        Button selected = null;
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (((Button)child).getSelection()) {
                SingleChoiceRidgetTest.assertNull(selected);
                selected = (Button)child;
            }
            ++n2;
        }
        return selected;
    }

    private String getSelectedControlValue(ChoiceComposite control) {
        Button button = this.getSelectedControl(control);
        return button != null ? String.valueOf(button.getData()) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionProvider {
        private final List<String> options;
        private final List<String> optionLabels;
        private String selectedOption;

        private OptionProvider() {
            this(new ArrayList<String>(Arrays.asList("Option A", "Option B", "Option C", "Option D", "Option E", "Option F")), new ArrayList<String>(Arrays.asList("Option label A", "Option label B", "Option label C", "Option label D", "Option label E", "Option label F")));
        }

        private OptionProvider(List<String> options, List<String> optionLabels) {
            this.options = options;
            this.optionLabels = optionLabels;
            this.selectedOption = options.get(0);
        }

        public List<String> getOptions() {
            return this.options;
        }

        public String getSelectedOption() {
            return this.selectedOption;
        }

        public void setSelectedOption(String selectedOption) {
            this.selectedOption = selectedOption;
        }

        public List<String> getOptionLabels() {
            return this.optionLabels;
        }

        public void remove(int index) {
            this.options.remove(index);
            this.optionLabels.remove(index);
        }
    }

    private static final class TestPropertyChangeListener
    implements PropertyChangeListener {
        private int eventCounter = 0;

        private TestPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.eventCounter;
        }
    }
}

