/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeUtils;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.riena.ui.tests.base.TestMultiSelectionBean;
import org.eclipse.riena.ui.tests.base.TestSingleSelectionBean;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeRidgetTest2
extends AbstractSWTRidgetTest {
    protected ITreeNode root;
    protected ITreeNode rootChild1;
    protected ITreeNode rootChild1Child1;
    protected ITreeNode rootChild2;
    private TestSingleSelectionBean singleSelectionBean;
    private TestMultiSelectionBean multiSelectionBean;

    protected Control createWidget(Composite parent) {
        return new Tree(parent, 2);
    }

    @Override
    protected IRidget createRidget() {
        return new TreeRidget();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ITreeNode[] nodes = this.bindRidgetToModel();
        this.root = nodes[0];
        this.rootChild1 = nodes[1];
        this.rootChild1Child1 = nodes[2];
        this.rootChild2 = nodes[3];
        this.singleSelectionBean = new TestSingleSelectionBean();
        this.getRidget().bindSingleSelectionToModel((Object)this.singleSelectionBean, "selection");
        this.multiSelectionBean = new TestMultiSelectionBean();
        this.getRidget().bindMultiSelectionToModel((Object)this.multiSelectionBean, "selectionList");
        this.getRidget().updateFromModel();
        UITestHelper.readAndDispatch((Widget)this.getWidget());
    }

    protected ITreeRidget getRidget() {
        return (ITreeRidget)super.getRidget();
    }

    protected final Tree getWidget() {
        return (Tree)super.getWidget();
    }

    public void testClearSelection() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.root);
        TreeRidgetTest2.assertTrue((ridget.getSelection().size() > 0 ? 1 : 0) != 0);
        TreeRidgetTest2.assertTrue((this.getUIControlSelectedRowCount() > 0 ? 1 : 0) != 0);
        ridget.clearSelection();
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.root, this.rootChild1));
        TreeRidgetTest2.assertTrue((ridget.getSelection().size() > 0 ? 1 : 0) != 0);
        TreeRidgetTest2.assertTrue((this.getUIControlSelectedRowCount() > 0 ? 1 : 0) != 0);
        ridget.clearSelection();
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
    }

    public void testGetSelection() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest2.assertNotNull((Object)ridget.getSelection());
        TreeRidgetTest2.assertTrue((boolean)ridget.getSelection().isEmpty());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.rootChild1, this.rootChild1Child1));
        TreeRidgetTest2.assertEquals((int)2, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), ridget.getSelection().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), ridget.getSelection().get(1));
    }

    public void testSetSelectionList() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ArrayList<ITreeNode> selBeans1 = new ArrayList<ITreeNode>(2);
        selBeans1.add(this.getRowValue(0));
        selBeans1.add(this.getRowValue(1));
        ridget.setSelection(selBeans1);
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(0);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ArrayList<ITreeNode> selBeans2 = new ArrayList<ITreeNode>(2);
        selBeans2.add(this.getRowValue(0));
        selBeans2.add(this.getRowValue(1));
        ridget.setSelection(selBeans2);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(0);
        this.assertUIControlSelectionContains(1);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ArrayList<Object> selBeans3 = new ArrayList<Object>(1);
        selBeans3.add(new Object());
        ridget.setSelection(selBeans3);
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        try {
            ridget.setSelection(null);
            TreeRidgetTest2.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionObject() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        ridget.setSelection((Object)this.getRowValue(0));
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(0);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setSelection(new Object());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)0, (int)this.multiSelectionBean.getSelectionList().size());
        ridget.setSelection(null);
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)0, (int)this.multiSelectionBean.getSelectionList().size());
    }

    public void testSetSelectionWithNoModel() {
        ISelectableRidget ridget = (ISelectableRidget)this.createRidget();
        try {
            ridget.setSelection(null);
            TreeRidgetTest2.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
        try {
            ridget.setSelection(Collections.EMPTY_LIST);
            TreeRidgetTest2.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testUpdateMultiSelectionCustomBinding() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        WritableList customMultiSelectionObservable = new WritableList();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindList(ridget.getMultiSelectionObservable(), (IObservableList)customMultiSelectionObservable, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
        this.setUIControlRowSelectionInterval(0, 2);
        TreeRidgetTest2.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        TreeRidgetTest2.assertEquals((int)3, (int)customMultiSelectionObservable.size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)customMultiSelectionObservable.get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)customMultiSelectionObservable.get(1));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)customMultiSelectionObservable.get(2));
        customMultiSelectionObservable.add((Object)this.getRowValue(0));
        customMultiSelectionObservable.clear();
        customMultiSelectionObservable.add((Object)this.getRowValue(0));
        customMultiSelectionObservable.add((Object)this.getRowValue(2));
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((int)2, (int)customMultiSelectionObservable.size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)customMultiSelectionObservable.get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)customMultiSelectionObservable.get(1));
    }

    public void testUpdateMultiSelectionFromControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        this.setUIControlRowSelectionInterval(1, 2);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        TreeItem[] items = new TreeItem[]{this.getUIControlItem(0), this.getUIControlItem(2)};
        this.getWidget().setSelection(items);
        UITestHelper.fireSelectionEvent((Widget)this.getWidget());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromModel() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(0, 2);
        this.multiSelectionBean.setSelectionList(new ArrayList<Object>());
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(1));
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(2));
        TreeRidgetTest2.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.updateMultiSelectionFromModel();
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromModelWhenUnbound() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(0, 2);
        this.multiSelectionBean.setSelectionList(new ArrayList<Object>());
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(1));
        this.multiSelectionBean.getSelectionList().add(this.getRowValue(2));
        TreeRidgetTest2.assertEquals((int)3, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[2]);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.setUIControl(null);
        ridget.updateMultiSelectionFromModel();
        ridget.setUIControl((Object)this.getWidget());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateMultiSelectionFromRidgetOnRebind() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.setUIControlRowSelectionInterval(1, 2);
        ridget.setUIControl(null);
        this.clearUIControlRowSelection();
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
        ridget.setUIControl((Object)this.getWidget());
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRowCount());
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRows()[0]);
        TreeRidgetTest2.assertEquals((int)2, (int)this.getUIControlSelectedRows()[1]);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)2, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(1));
    }

    public void testUpdateSingleSelectionCustomBinding() {
        ITreeRidget ridget = this.getRidget();
        WritableValue customSingleSelectionObservable = new WritableValue();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(ridget.getSingleSelectionObservable(), (IObservableValue)customSingleSelectionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.setUIControlRowSelectionInterval(1, 1);
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(1);
        TreeRidgetTest2.assertNull((Object)customSingleSelectionObservable.getValue());
        customSingleSelectionObservable.setValue((Object)this.getRowValue(0));
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(0);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)customSingleSelectionObservable.getValue());
    }

    public void testUpdateSingleSelectionFromControl() {
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        this.setUIControlRowSelectionInterval(1, 1);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromModel() {
        ITreeRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(1, 1);
        this.singleSelectionBean.setSelection(this.getRowValue(0));
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(1);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.updateSingleSelectionFromModel();
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(0);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromModelWhenUnbound() {
        ITreeRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(1, 1);
        this.singleSelectionBean.setSelection(this.getRowValue(0));
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(1);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(1), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setUIControl(null);
        ridget.updateSingleSelectionFromModel();
        ridget.setUIControl((Object)this.getWidget());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(0), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateSingleSelectionFromRidgetOnRebind() {
        ITreeRidget ridget = this.getRidget();
        this.setUIControlRowSelectionInterval(2, 2);
        ridget.setUIControl(null);
        this.clearUIControlRowSelection();
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setUIControl((Object)this.getWidget());
        TreeRidgetTest2.assertEquals((int)1, (int)this.getUIControlSelectedRowCount());
        this.assertUIControlSelectionContains(2);
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        TreeRidgetTest2.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testSelectionEventsSelectionTypeSingle() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        List<Object> oldSelection = Collections.EMPTY_LIST;
        List<Object> newSelection = Arrays.asList(this.root);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection((Object)this.root);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection((Object)this.root);
        this.verifyPropertyChangeEvents();
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Collections.EMPTY_LIST);
        this.verifyPropertyChangeEvents();
        oldSelection = Collections.EMPTY_LIST;
        newSelection = Arrays.asList(this.rootChild1);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Arrays.asList(this.rootChild1, this.rootChild1Child1));
        this.verifyPropertyChangeEvents();
    }

    public void testSelectionEventsSelectionTypeMulti() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TreeRidgetTest2.assertNull((Object)this.singleSelectionBean.getSelection());
        TreeRidgetTest2.assertTrue((boolean)this.multiSelectionBean.getSelectionList().isEmpty());
        TreeRidgetTest2.assertEquals((int)0, (int)this.getUIControlSelectedRowCount());
        List<Object> oldSelection = Collections.EMPTY_LIST;
        List<Object> newSelection = Arrays.asList(this.root);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection((Object)this.root);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection((Object)this.root);
        this.verifyPropertyChangeEvents();
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Collections.EMPTY_LIST);
        this.verifyPropertyChangeEvents();
        oldSelection = Collections.EMPTY_LIST;
        newSelection = Arrays.asList(this.rootChild1, this.rootChild1Child1);
        this.expectPropertyChangeEvent("selection", oldSelection, newSelection);
        ridget.setSelection(Arrays.asList(this.rootChild1, this.rootChild1Child1));
        this.verifyPropertyChangeEvents();
    }

    public void testSetSelectionTypeNull() {
        ITreeRidget ridget = this.getRidget();
        try {
            ridget.setSelectionType(null);
            TreeRidgetTest2.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionTypeNONE() {
        ITreeRidget ridget = this.getRidget();
        try {
            ridget.setSelectionType(ISelectableRidget.SelectionType.NONE);
            TreeRidgetTest2.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testGetUIControl() throws Exception {
        Tree control = this.getWidget();
        TreeRidgetTest2.assertEquals((Object)control, (Object)this.getRidget().getUIControl());
    }

    public void testUpdateFromModelPreservesSelection() throws Exception {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.rootChild2);
        TreeRidgetTest2.assertSame((Object)this.rootChild2, ridget.getSelection().get(0));
        List children = this.root.getChildren();
        children.remove(this.rootChild1);
        this.root.setChildren(children);
        ridget.updateFromModel();
        TreeRidgetTest2.assertSame((Object)this.rootChild2, ridget.getSelection().get(0));
    }

    public void testUpdateFromModelRemovesSelection() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.rootChild1Child1);
        TreeRidgetTest2.assertSame((Object)this.rootChild1Child1, ridget.getSelection().get(0));
        List children = this.root.getChildren();
        children.remove(this.rootChild1);
        this.root.setChildren(children);
        ridget.updateFromModel();
        TreeRidgetTest2.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testUpdateRootFromModelPreservesSelection() {
        ITreeRidget ridget = this.getRidget();
        TreeNode node1 = new TreeNode((Object)new Person("Doe", "John"));
        TreeNode node2 = new TreeNode((Object)new Person("Doe", "Jane"));
        Object[] roots = new ITreeNode[]{node1, node2};
        this.getRidget().bindToModel(roots, ITreeNode.class, "children", "parent", "value");
        ridget.setSelection((Object)node1);
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        Object swap = roots[0];
        roots[0] = roots[1];
        roots[1] = swap;
        ridget.updateFromModel();
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
    }

    public void testUpdateRootFromModelRemovesSelection() {
        ITreeRidget ridget = this.getRidget();
        TreeNode node1 = new TreeNode((Object)new Person("Doe", "John"));
        TreeNode node2 = new TreeNode((Object)new Person("Doe", "Jane"));
        Object[] roots = new ITreeNode[]{node1, node2};
        this.getRidget().bindToModel(roots, ITreeNode.class, "children", "parent", "value");
        ridget.setSelection((Object)node1);
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        roots[0] = new TreeNode((Object)new Person("New", "Person 1"));
        roots[1] = new TreeNode((Object)new Person("New", "Person 2"));
        ridget.updateFromModel();
        TreeRidgetTest2.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testContainsOption() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest2.assertTrue((boolean)ridget.containsOption((Object)this.root));
        TreeRidgetTest2.assertTrue((boolean)ridget.containsOption((Object)this.rootChild1));
        TreeRidgetTest2.assertTrue((boolean)ridget.containsOption((Object)this.rootChild1Child1));
        TreeRidgetTest2.assertTrue((boolean)ridget.containsOption((Object)this.rootChild2));
        Object[] newRoots = new TreeNode[]{new TreeNode((Object)"newRoot")};
        TreeRidgetTest2.assertFalse((boolean)ridget.containsOption(null));
        TreeRidgetTest2.assertFalse((boolean)ridget.containsOption((Object)newRoots[0]));
        this.getRidget().bindToModel(newRoots, ITreeNode.class, "children", "parent", "value");
        TreeRidgetTest2.assertFalse((boolean)ridget.containsOption((Object)this.root));
        TreeRidgetTest2.assertTrue((boolean)ridget.containsOption(newRoots[0]));
    }

    public void testSelectionType() throws Exception {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.MULTI, (Object)ridget.getSelectionType());
        try {
            ridget.setSelectionType(ISelectableRidget.SelectionType.NONE);
            TreeRidgetTest2.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok("IllegalArgumentException expected");
        }
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.MULTI, (Object)ridget.getSelectionType());
        ridget.setUIControl(null);
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        ridget.setUIControl((Object)control);
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
    }

    public void testSetSelectionTypeIsEnforced() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeRidgetTest2.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        TreeRidgetTest2.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        ridget.setSelection(Arrays.asList(this.root, this.rootChild1));
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.root, this.rootChild1));
        TreeRidgetTest2.assertEquals((int)2, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)2, (int)control.getSelectionCount());
    }

    public void testDisabledItemNotSelectableByAPI() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode node1 = new TreeNode((Object)"node1");
        TreeNode node2 = new TreeNode((Object)"node2");
        node2.setEnabled(false);
        Object[] roots = new TreeNode[]{node1, node2};
        this.getRidget().bindToModel(roots, TreeNode.class, "children", "parent", "value", "enabled", null);
        ridget.setSelection((Object)node1);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        ridget.setSelection((Object)node2);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        ridget.setSelection(Arrays.asList(node1, node2));
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
    }

    public void testDisabledItemNotSelectableByUser() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode node1 = new TreeNode((Object)"node1");
        TreeNode node2 = new TreeNode((Object)"node2");
        node2.setEnabled(false);
        Object[] roots = new TreeNode[]{node1, node2};
        ridget.bindToModel(roots, TreeNode.class, "children", "parent", "value", "enabled", null);
        ridget.setSelection((Object)node1);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertSame((Object)node1, ridget.getSelection().get(0));
    }

    public void testInvisibleItemsAreNotShown() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode node1 = new TreeNode((Object)"node1");
        TreeNode node2 = new TreeNode((Object)"node2");
        node2.setEnabled(false);
        Object[] roots = new TreeNode[]{node1, node2};
        ridget.bindToModel(roots, TreeNode.class, "children", "parent", "value", null, "visible");
        TreeRidgetTest2.assertEquals((int)2, (int)control.getItemCount());
        node2.setVisible(false);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getItemCount());
        node2.setVisible(true);
        TreeRidgetTest2.assertEquals((int)2, (int)control.getItemCount());
    }

    public void testInvisibleItemsAreNotShownWithHiddenRoot() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        TreeNode node1 = new TreeNode((Object)"node1");
        TreeNode node1child1 = new TreeNode((ITreeNode)node1, (Object)"child 1");
        Object[] roots = new TreeNode[]{node1};
        ridget.setRootsVisible(false);
        ridget.bindToModel(roots, TreeNode.class, "children", "parent", "value", null, "visible");
        TreeRidgetTest2.assertEquals((int)1, (int)control.getItemCount());
        node1child1.setVisible(false);
        TreeRidgetTest2.assertEquals((int)0, (int)control.getItemCount());
        node1child1.setVisible(true);
        TreeRidgetTest2.assertEquals((int)1, (int)control.getItemCount());
    }

    public void testSetRootsVisible() {
        ITreeRidget ridget = this.getRidget();
        TreeRidgetTest2.assertTrue((boolean)ridget.getRootsVisible());
        ridget.setRootsVisible(false);
        TreeRidgetTest2.assertFalse((boolean)ridget.getRootsVisible());
        ridget.setRootsVisible(true);
        TreeRidgetTest2.assertTrue((boolean)ridget.getRootsVisible());
    }

    public void testSetRootsVisibleWithModel() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setRootsVisible(false);
        Object[] roots = new Object[]{this.root};
        this.getRidget().bindToModel(roots, ITreeNode.class, "children", "parent", "value");
        ridget.expandAll();
        TreeRidgetTest2.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.updateFromModel();
        TreeRidgetTest2.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        ridget.setRootsVisible(true);
        ridget.updateFromModel();
        ridget.expandAll();
        TreeRidgetTest2.assertEquals((int)4, (int)TreeUtils.getItemCount(control));
    }

    public void testSetRootsFalseDoesRefresh() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setRootsVisible(false);
        ridget.updateFromModel();
        ridget.expandAll();
        TreeRidgetTest2.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        TreeNode sibling = new TreeNode(this.root, (Object)"sibling");
        TreeRidgetTest2.assertEquals((int)4, (int)TreeUtils.getItemCount(control));
        List children = this.root.getChildren();
        children.remove(sibling);
        this.root.setChildren(children);
        TreeRidgetTest2.assertEquals((int)3, (int)TreeUtils.getItemCount(control));
        new TreeNode(this.rootChild1, (Object)"child");
        TreeRidgetTest2.assertEquals((int)4, (int)TreeUtils.getItemCount(control));
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testBug245632() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.expandAll();
        ridget.setSelection((Object)this.root);
        ridget.setOutputOnly(true);
        TreeItem topItem = control.getTopItem();
        TreeRidgetTest2.assertSame((Object)this.root, ridget.getSelection().get(0));
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000008);
        TreeRidgetTest2.assertSame((Object)this.root, ridget.getSelection().get(0));
        TreeRidgetTest2.assertNotSame((Object)topItem, (Object)control.getTopItem());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        ITreeRidget ridget = this.getRidget();
        Tree control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.root);
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        ridget.setOutputOnly(true);
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        ridget.setSelection(null);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
        ridget.setOutputOnly(false);
        TreeRidgetTest2.assertEquals((int)0, (int)ridget.getSelection().size());
    }

    public void testSetSelectionWithNoBoundControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.rootChild1);
        TreeRidgetTest2.assertNotNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertEquals((Object)this.rootChild1, ridget.getSelection().get(0));
        ridget.setUIControl(null);
        ridget.setSelection((Object)this.rootChild2);
        TreeRidgetTest2.assertNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertEquals((Object)this.rootChild2, ridget.getSelection().get(0));
    }

    public void testUpdateSingleSelectionFromModelWithNoBoundControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.rootChild1);
        TreeRidgetTest2.assertEquals((Object)this.rootChild1, ridget.getSelection().get(0));
        ridget.setUIControl(null);
        this.removeNode(this.root, this.rootChild1);
        ridget.updateFromModel();
        TreeRidgetTest2.assertNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testUpdateMultiSelectionFromModelWithNoBoundControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.rootChild1, this.rootChild2));
        TreeRidgetTest2.assertEquals((int)2, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((Object)this.rootChild1, ridget.getSelection().get(0));
        TreeRidgetTest2.assertEquals((Object)this.rootChild2, ridget.getSelection().get(1));
        ridget.setUIControl(null);
        this.removeNode(this.root, this.rootChild1);
        ridget.updateFromModel();
        TreeRidgetTest2.assertNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((Object)this.rootChild2, ridget.getSelection().get(0));
    }

    public void testUpdateSingleSelectionFromModelWithBoundControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ridget.setSelection((Object)this.rootChild1);
        TreeRidgetTest2.assertEquals((Object)this.rootChild1, ridget.getSelection().get(0));
        this.removeNode(this.root, this.rootChild1);
        ridget.updateFromModel();
        TreeRidgetTest2.assertNotNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testUpdateMultiSelectionFromModelWithBoundControl() {
        ITreeRidget ridget = this.getRidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ridget.setSelection(Arrays.asList(this.rootChild1, this.rootChild2));
        TreeRidgetTest2.assertEquals((int)2, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((Object)this.rootChild1, ridget.getSelection().get(0));
        TreeRidgetTest2.assertEquals((Object)this.rootChild2, ridget.getSelection().get(1));
        this.removeNode(this.root, this.rootChild1);
        ridget.updateFromModel();
        TreeRidgetTest2.assertNotNull((Object)ridget.getUIControl());
        TreeRidgetTest2.assertEquals((int)1, (int)ridget.getSelection().size());
        TreeRidgetTest2.assertEquals((Object)this.rootChild2, ridget.getSelection().get(0));
    }

    private void assertUIControlSelectionContains(int itemIndex) {
        boolean result = false;
        TreeItem item = this.getUIControlItem(itemIndex);
        TreeItem[] selections = this.getWidget().getSelection();
        int i = 0;
        while (!result && i < selections.length) {
            result = item == selections[i];
            ++i;
        }
        TreeRidgetTest2.assertTrue((String)("not selected in ui control: " + item), (boolean)result);
    }

    private ITreeNode[] bindRidgetToModel() {
        Collection<Person> persons = this.createPersonList();
        Iterator<Person> iter = persons.iterator();
        Person person1 = iter.next();
        Person person2 = iter.next();
        Person person3 = iter.next();
        Person person4 = iter.next();
        TreeNode node1 = new TreeNode((Object)person1);
        TreeNode node2 = new TreeNode((ITreeNode)node1, (Object)person2);
        TreeNode node4 = new TreeNode((ITreeNode)node1, (Object)person4);
        TreeNode node3 = new TreeNode((ITreeNode)node2, (Object)person3);
        Object[] roots = new ITreeNode[]{node1};
        this.getRidget().bindToModel(roots, ITreeNode.class, "children", "parent", "value");
        return new ITreeNode[]{node1, node2, node3, node4};
    }

    private void clearUIControlRowSelection() {
        Tree tree = this.getWidget();
        tree.deselectAll();
        UITestHelper.fireSelectionEvent((Widget)tree);
    }

    private Collection<Person> createPersonList() {
        ArrayList<Person> newList = new ArrayList<Person>();
        Person person = new Person("Doe", "One");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Two");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Three");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "John");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("JJ Jr. Shabadoo", "Joey");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Johnson", "Jack");
        person.setEyeColor(2);
        newList.add(person);
        person = new Person("Johnson", "Jane");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Zappa", "Frank");
        person.setEyeColor(2);
        newList.add(person);
        return newList;
    }

    private int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    private int[] getUIControlSelectedRows() {
        TreeItem[] selection = this.getWidget().getSelection();
        int[] result = new int[selection.length];
        int i = 0;
        while (i < result.length) {
            if (selection[i] == this.getUIControlItem(0)) {
                result[i] = 0;
            } else if (selection[i] == this.getUIControlItem(1)) {
                result[i] = 1;
            } else if (selection[i] == this.getUIControlItem(2)) {
                result[i] = 2;
            }
            ++i;
        }
        return result;
    }

    private TreeItem getUIControlItem(int index) {
        this.getRidget().expandAll();
        Tree control = this.getWidget();
        switch (index) {
            case 0: {
                return control.getItem(0);
            }
            case 1: {
                return control.getItem(0).getItem(0);
            }
            case 2: {
                return control.getItem(0).getItem(0).getItem(0);
            }
            case 3: {
                return control.getItem(0).getItem(1);
            }
        }
        throw new IndexOutOfBoundsException("index= " + index);
    }

    private ITreeNode getRowValue(int index) {
        switch (index) {
            case 0: {
                return this.root;
            }
            case 1: {
                return this.rootChild1;
            }
            case 2: {
                return this.rootChild1Child1;
            }
        }
        throw new IndexOutOfBoundsException("index= " + index);
    }

    private void removeNode(ITreeNode parent, ITreeNode toRemove) {
        List children = parent.getChildren();
        boolean removed = children.remove(toRemove);
        TreeRidgetTest2.assertTrue((String)("failed to remove " + toRemove), (boolean)removed);
        parent.setChildren(children);
    }

    private void setUIControlRowSelectionInterval(int start, int end) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        Assert.isLegal((start <= end ? 1 : 0) != 0);
        Tree control = this.getWidget();
        int length = end - start + 1;
        TreeItem[] items = new TreeItem[length];
        int i = 0;
        while (i < items.length) {
            items[i] = this.getUIControlItem(i + start);
            ++i;
        }
        control.setSelection(items);
        UITestHelper.fireSelectionEvent((Widget)control);
    }
}

