/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.workarea.registry;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.workarea.registry.WorkareaDefinitionRegistryFacade;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaDefinition;

@NonUITestCase
public class WorkareaDefinitionRegistryFacadeTest
extends TestCase {
    public void testGetInstance() {
        WorkareaDefinitionRegistryFacade facade1 = WorkareaDefinitionRegistryFacade.getInstance();
        WorkareaDefinitionRegistryFacadeTest.assertNotNull((Object)facade1);
        WorkareaDefinitionRegistryFacade facade2 = WorkareaDefinitionRegistryFacade.getInstance();
        WorkareaDefinitionRegistryFacadeTest.assertNotNull((Object)facade2);
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)facade1, (Object)facade2);
    }

    public void testRegisterDefinition() {
        WorkareaDefinitionRegistryFacade facade = WorkareaDefinitionRegistryFacade.getInstance();
        IWorkareaDefinition def = facade.registerDefinition((Object)"id0101", SubModuleController.class, (Object)"secondId", true);
        WorkareaDefinitionRegistryFacadeTest.assertEquals(SubModuleController.class, (Object)def.getControllerClass());
        WorkareaDefinitionRegistryFacadeTest.assertEquals((Object)"secondId", (Object)def.getViewId());
        WorkareaDefinitionRegistryFacadeTest.assertTrue((boolean)def.isViewShared());
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def, (Object)facade.getDefinition((Object)"id0101"));
    }

    public void testRegister() {
        WorkareaDefinitionRegistryFacade facade = WorkareaDefinitionRegistryFacade.getInstance();
        WorkareaDefinition def1 = new WorkareaDefinition((Object)"IdOfView");
        IWorkareaDefinition def2 = facade.register((Object)"id0201", (IWorkareaDefinition)def1);
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def1, (Object)def2);
        IWorkareaDefinition def3 = facade.getDefinition((Object)"id0201");
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def1, (Object)def3);
    }

    public void testGetDefinition() {
        WorkareaDefinitionRegistryFacade facade = WorkareaDefinitionRegistryFacade.getInstance();
        WorkareaDefinition def1 = new WorkareaDefinition((Object)"IdOfView01");
        facade.register((Object)"id0301", (IWorkareaDefinition)def1);
        IWorkareaDefinition retdef = facade.getDefinition((Object)"id0301");
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def1, (Object)retdef);
        Object id = new Object();
        WorkareaDefinition def2 = new WorkareaDefinition((Object)"view2");
        facade.register(id, (IWorkareaDefinition)def2);
        retdef = facade.getDefinition(id);
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def2, (Object)retdef);
        SubModuleNode node1 = new SubModuleNode(new NavigationNodeId("id0302"));
        WorkareaDefinition def3 = new WorkareaDefinition((Object)"IdOfView02");
        facade.register((Object)node1, (IWorkareaDefinition)def3);
        retdef = facade.getDefinition((Object)node1);
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def3, (Object)retdef);
        SubModuleNode node2 = new SubModuleNode(new NavigationNodeId("id0303"));
        WorkareaDefinition def4 = new WorkareaDefinition((Object)"IdOfView03");
        facade.register((Object)"id0303", (IWorkareaDefinition)def4);
        retdef = facade.getDefinition((Object)node2);
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def4, (Object)retdef);
        SubModuleNode node3 = new SubModuleNode(new NavigationNodeId("id0304"));
        WorkareaDefinition def5 = new WorkareaDefinition((Object)"IdOfView04");
        facade.register((Object)node3, (IWorkareaDefinition)def5);
        retdef = facade.getDefinition((Object)"id0304");
        WorkareaDefinitionRegistryFacadeTest.assertSame((Object)def5, (Object)retdef);
    }
}

