/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.monitor.client.SimpleStore;
import org.eclipse.riena.monitor.common.Collectible;

@NonUITestCase
public class SimpleStoreTest
extends RienaTestCase {
    private static final String PAYLOAD = "What goes up, must come down!";
    private static final String CATEGORY = "test";
    private static final String CLIENT_INFO = "unit-test";

    public void testPutCollectibleAndGetCollectible() throws CoreException, IOException {
        SimpleStore store = new SimpleStore();
        store.setInitializationData(null, null, null);
        File file = File.createTempFile("SimpleStore", ".test");
        try {
            Collectible collectible = new Collectible(CLIENT_INFO, CATEGORY, (Serializable)((Object)PAYLOAD));
            ReflectionUtils.invokeHidden((Object)store, (String)"putCollectible", (Object[])new Object[]{collectible, file});
            Collectible outCollectible = (Collectible)ReflectionUtils.invokeHidden((Object)store, (String)"getCollectible", (Object[])new Object[]{file});
            SimpleStoreTest.assertEquals((String)CLIENT_INFO, (String)outCollectible.getClientInfo());
            SimpleStoreTest.assertEquals((String)CATEGORY, (String)outCollectible.getCategory());
            SimpleStoreTest.assertEquals((String)PAYLOAD, (String)((String)((Object)outCollectible.getPayload())));
        }
        finally {
            file.delete();
        }
    }

    public void testGetCollectibleFromExistingStoreFileForRegression() throws CoreException {
        SimpleStore store = new SimpleStore();
        store.setInitializationData(null, null, null);
        File file = this.getFile("regression.store");
        Collectible outCollectible = (Collectible)ReflectionUtils.invokeHidden((Object)store, (String)"getCollectible", (Object[])new Object[]{file});
        SimpleStoreTest.assertEquals((String)CLIENT_INFO, (String)outCollectible.getClientInfo());
        SimpleStoreTest.assertEquals((String)CATEGORY, (String)outCollectible.getCategory());
        SimpleStoreTest.assertEquals((String)PAYLOAD, (String)((String)((Object)outCollectible.getPayload())));
    }

    public void testGetBadOldCollectibleFromExistingStoreFile() throws CoreException {
        SimpleStore store = new SimpleStore();
        store.setInitializationData(null, null, null);
        File file = this.getFile("regression.store.old");
        Collectible outCollectible = (Collectible)ReflectionUtils.invokeHidden((Object)store, (String)"getCollectible", (Object[])new Object[]{file});
        SimpleStoreTest.assertNull((Object)outCollectible);
        SimpleStoreTest.assertFalse((boolean)file.exists());
    }

    public void testSetInitializationData() throws CoreException {
        SimpleStore store = new SimpleStore();
        store.setInitializationData(null, null, (Object)"cleanupDelay=1 m; storePath=c:\\temp\\store");
        SimpleStoreTest.assertEquals((long)60000L, (long)((Long)ReflectionUtils.getHidden((Object)store, (String)"cleanupDelay")));
        SimpleStoreTest.assertEquals((String)"c:\\temp\\store", (String)((String)ReflectionUtils.getHidden((Object)store, (String)"storePathName")));
    }
}

