/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;

@NonUITestCase
public class NavigationNodeUtilityTest
extends TestCase {
    public void testGetLongNodeId() {
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("sm"));
        NavigationNodeUtilityTest.assertEquals((String)"/sm", (String)NavigationNodeUtility.getNodeLongId((INavigationNode)sm));
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        sm.setParent((INavigationNode)sm2);
        NavigationNodeUtilityTest.assertEquals((String)"/sm2/sm", (String)NavigationNodeUtility.getNodeLongId((INavigationNode)sm));
        ModuleNode m = new ModuleNode();
        sm2.setParent((INavigationNode)m);
        NavigationNodeUtilityTest.assertEquals((String)"//sm2/sm", (String)NavigationNodeUtility.getNodeLongId((INavigationNode)sm));
        ModuleGroupNode mg = new ModuleGroupNode(new NavigationNodeId("group"));
        m.setParent((INavigationNode)mg);
        NavigationNodeUtilityTest.assertEquals((String)"/group//sm2/sm", (String)NavigationNodeUtility.getNodeLongId((INavigationNode)sm));
    }

    public void testFindNode() throws Exception {
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("sm"));
        NavigationNodeUtilityTest.assertEquals((int)0, (int)NavigationNodeUtility.findNode((String)"sm2", (INavigationNode)sm).size());
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        sm.addChild((INavigationNode)sm2);
        NavigationNodeUtilityTest.assertSame((Object)sm2, NavigationNodeUtility.findNode((String)"sm2", (INavigationNode)sm).get(0));
        SubModuleNode sm22 = new SubModuleNode(new NavigationNodeId("sm22"));
        sm.addChild((INavigationNode)sm22);
        NavigationNodeUtilityTest.assertSame((Object)sm, NavigationNodeUtility.findNode((String)"sm*", (INavigationNode)sm).get(0));
        NavigationNodeUtilityTest.assertSame((Object)sm2, NavigationNodeUtility.findNode((String)"sm2", (INavigationNode)sm).get(0));
        NavigationNodeUtilityTest.assertSame((Object)sm22, NavigationNodeUtility.findNode((String)"sm22", (INavigationNode)sm22).get(0));
        SubModuleNode sm222 = new SubModuleNode(new NavigationNodeId("sm222"));
        sm2.addChild((INavigationNode)sm222);
        SubModuleNode sm21 = new SubModuleNode(new NavigationNodeId("sm21"));
        sm2.addChild((INavigationNode)sm21);
        NavigationNodeUtilityTest.assertSame((Object)sm21, NavigationNodeUtility.findNode((String)"sm21", (INavigationNode)sm).get(0));
    }

    public void testFindNodeLongId() throws Exception {
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("sm"));
        NavigationNodeUtilityTest.assertEquals((int)0, (int)NavigationNodeUtility.findNodesByLongId((String)"sm2", (INavigationNode)sm).size());
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        sm.addChild((INavigationNode)sm2);
        NavigationNodeUtilityTest.assertEquals((int)0, (int)NavigationNodeUtility.findNodesByLongId((String)"sm2", (INavigationNode)sm).size());
        NavigationNodeUtilityTest.assertSame((Object)sm2, NavigationNodeUtility.findNodesByLongId((String)"/sm/sm2", (INavigationNode)sm).get(0));
        SubModuleNode sm22 = new SubModuleNode(new NavigationNodeId("sm22"));
        sm.addChild((INavigationNode)sm22);
        NavigationNodeUtilityTest.assertSame((Object)sm2, NavigationNodeUtility.findNodesByLongId((String)"/sm/sm2", (INavigationNode)sm).get(0));
        NavigationNodeUtilityTest.assertSame((Object)sm22, NavigationNodeUtility.findNodesByLongId((String)"/sm/sm22", (INavigationNode)sm22).get(0));
    }
}

