/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;

@NonUITestCase
public class ShellBorderRendererTest
extends TestCase {
    public void testGetCompelteBorderWidth() {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            MyLnf lnf = new MyLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.initialize();
            ShellBorderRenderer renderer = new ShellBorderRenderer();
            lnf.setPadding(20);
            int expected = 20 + renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            lnf.removePadding();
            expected = renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            lnf.setPadding(1.2);
            expected = renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            renderer.dispose();
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public void removePadding() {
            Map settingTable = (Map)ReflectionUtils.getHidden((Object)LnfManager.getLnf(), (String)"settingTable");
            settingTable.remove("TitlelessShell.padding");
        }

        public void setPadding(Object padding) {
            this.putLnfSetting("TitlelessShell.padding", padding);
        }
    }
}

