/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.AbstractScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class AbstractScrollingSupportTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        super.tearDown();
    }

    public void testGetActiveNode() {
        ModuleGroupNode mg1 = new ModuleGroupNode();
        MockModuleNavigationComponentProvider provider = new MockModuleNavigationComponentProvider();
        provider.setActiveModuleGroupNode((IModuleGroupNode)mg1);
        MockScrollingSupport support = new MockScrollingSupport(provider);
        INavigationNode activeNode = (INavigationNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveNode", (Object[])new Object[0]);
        AbstractScrollingSupportTest.assertSame((Object)mg1, (Object)activeNode);
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        mg1.addChild((INavigationNode)m1);
        ModuleNode m2 = new ModuleNode(new NavigationNodeId("m2"));
        mg1.addChild((INavigationNode)m2);
        ModuleNode m3 = new ModuleNode(new NavigationNodeId("m3"));
        mg1.addChild((INavigationNode)m3);
        activeNode = (INavigationNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveNode", (Object[])new Object[0]);
        AbstractScrollingSupportTest.assertSame((Object)mg1, (Object)activeNode);
        m2.activate(null);
        activeNode = (INavigationNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveNode", (Object[])new Object[0]);
        AbstractScrollingSupportTest.assertSame((Object)m2, (Object)activeNode);
        SubModuleNode sm1 = new SubModuleNode();
        m2.addChild((INavigationNode)sm1);
        activeNode = (INavigationNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveNode", (Object[])new Object[0]);
        AbstractScrollingSupportTest.assertSame((Object)m2, (Object)activeNode);
        sm1.activate(null);
        activeNode = (INavigationNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveNode", (Object[])new Object[0]);
        AbstractScrollingSupportTest.assertSame((Object)sm1, (Object)activeNode);
    }

    public void testGetActiveSubModuleNode() {
        MockScrollingSupport support = new MockScrollingSupport(new MockModuleNavigationComponentProvider());
        ArrayList<SubModuleNode> nodes = new ArrayList<SubModuleNode>();
        ISubModuleNode activeNode = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveSubModuleNode", (Object[])new Object[]{nodes});
        AbstractScrollingSupportTest.assertNull((Object)activeNode);
        SubModuleNode sm1 = new SubModuleNode();
        nodes.add(sm1);
        activeNode = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveSubModuleNode", (Object[])new Object[]{nodes});
        AbstractScrollingSupportTest.assertNull((Object)activeNode);
        sm1.activate(null);
        activeNode = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveSubModuleNode", (Object[])new Object[]{nodes});
        AbstractScrollingSupportTest.assertSame((Object)sm1, (Object)activeNode);
        SubModuleNode sm2 = new SubModuleNode();
        sm1.addChild((INavigationNode)sm2);
        activeNode = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveSubModuleNode", (Object[])new Object[]{nodes});
        AbstractScrollingSupportTest.assertSame((Object)sm1, (Object)activeNode);
        sm2.activate(null);
        activeNode = (ISubModuleNode)ReflectionUtils.invokeHidden((Object)((Object)support), (String)"getActiveSubModuleNode", (Object[])new Object[]{nodes});
        AbstractScrollingSupportTest.assertSame((Object)sm2, (Object)activeNode);
    }

    private class MockModuleNavigationComponentProvider
    implements IModuleNavigationComponentProvider {
        private IModuleGroupNode moduleGroup;

        private MockModuleNavigationComponentProvider() {
        }

        public Composite getNavigationComponent() {
            return AbstractScrollingSupportTest.this.shell;
        }

        public Composite getScrolledComponent() {
            return null;
        }

        public int calculateBounds() {
            return 0;
        }

        public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode moduleGroupNode) {
            return null;
        }

        public ModuleView getModuleViewForNode(IModuleNode moduleGroupNode) {
            return null;
        }

        public IModuleGroupNode getActiveModuleGroupNode() {
            return this.moduleGroup;
        }

        public ISubApplicationNode getSubApplicationNode() {
            return null;
        }

        public void setActiveModuleGroupNode(IModuleGroupNode moduleGroup) {
            this.moduleGroup = moduleGroup;
        }
    }

    private class MockScrollingSupport
    extends AbstractScrollingSupport {
        public MockScrollingSupport(IModuleNavigationComponentProvider navigationComponentProvider) {
            super(navigationComponentProvider);
        }

        public void scroll() {
        }

        protected boolean scrollTo(Composite topComp, Composite bottomComp) {
            return false;
        }

        protected boolean scrollTo(Tree tree) {
            return false;
        }

        protected void scrollUp(int pixels) {
        }

        protected void scrollDown(int pixels) {
        }
    }
}

