/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.ScrollBarSupport;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ScrollBarSupportTest
extends TestCase {
    private Display display;
    private Shell shell;
    private ScrolledComposite scrolledComposite;
    private Composite content;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell(147456);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this.shell);
        this.scrolledComposite = new ScrolledComposite((Composite)this.shell, 2560);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setShowFocusedControl(false);
        this.content = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.content);
        GridDataFactory.fillDefaults().hint(30, 60).applyTo((Control)this.scrolledComposite);
        this.display = this.shell.getDisplay();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        super.tearDown();
    }

    public void testScrollUp() {
        ScrollBarSupport support = new ScrollBarSupport(this.scrolledComposite, (IModuleNavigationComponentProvider)new MockModuleNavigationComponentProvider());
        Point origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollDown", (Object[])new Object[]{30});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)30, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollUp", (Object[])new Object[]{20});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)10, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollUp", (Object[])new Object[]{20});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.y);
    }

    public void testScrollDonw() {
        ScrollBarSupport support = new ScrollBarSupport(this.scrolledComposite, (IModuleNavigationComponentProvider)new MockModuleNavigationComponentProvider());
        Point origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollDown", (Object[])new Object[]{30});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)30, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollDown", (Object[])new Object[]{20});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)50, (int)origin.y);
        ReflectionUtils.invokeHidden((Object)support, (String)"scrollDown", (Object[])new Object[]{20});
        origin = this.scrolledComposite.getOrigin();
        ScrollBarSupportTest.assertEquals((int)0, (int)origin.x);
        ScrollBarSupportTest.assertEquals((int)70, (int)origin.y);
    }

    public void testGetScrollPixels() {
        ScrollBarSupport support = new ScrollBarSupport(this.scrolledComposite, (IModuleNavigationComponentProvider)new MockModuleNavigationComponentProvider());
        this.scrolledComposite.setMinSize(30, 80);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.content);
        Composite one = new Composite(this.content, 0);
        Color bgColor = this.display.getSystemColor(9);
        one.setBackground(bgColor);
        GridDataFactory.fillDefaults().hint(20, 20).applyTo((Control)one);
        Composite two = new Composite(this.content, 0);
        bgColor = this.display.getSystemColor(5);
        two.setBackground(bgColor);
        GridDataFactory.fillDefaults().hint(20, 20).applyTo((Control)two);
        Composite three = new Composite(this.content, 0);
        bgColor = this.display.getSystemColor(7);
        three.setBackground(bgColor);
        GridDataFactory.fillDefaults().hint(20, 20).applyTo((Control)three);
        Composite four = new Composite(this.content, 0);
        bgColor = this.display.getSystemColor(3);
        four.setBackground(bgColor);
        GridDataFactory.fillDefaults().hint(20, 20).applyTo((Control)four);
        this.shell.setLocation(0, 0);
        this.shell.pack();
        this.shell.open();
        this.scrolledComposite.setOrigin(0, 0);
        int pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{one, two});
        ScrollBarSupportTest.assertEquals((int)0, (int)pixels);
        pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{three, four});
        ScrollBarSupportTest.assertEquals((int)20, (int)pixels);
        this.scrolledComposite.setOrigin(0, 10);
        pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{one, two});
        ScrollBarSupportTest.assertEquals((int)-10, (int)pixels);
    }

    public void testGetScrollPixelsTree() {
        ScrollBarSupport support = new ScrollBarSupport(this.scrolledComposite, (IModuleNavigationComponentProvider)new MockModuleNavigationComponentProvider());
        GridDataFactory.fillDefaults().hint(75, 60).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setMinSize(30, 80);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.content);
        Tree tree = new Tree(this.content, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).applyTo((Composite)tree);
        TreeItem item00 = new TreeItem(tree, 0);
        item00.setText("one");
        TreeItem item01 = new TreeItem(tree, 0);
        item01.setText("two");
        TreeItem item02 = new TreeItem(tree, 0);
        item02.setText("three");
        TreeItem item03 = new TreeItem(tree, 0);
        item03.setText("four");
        TreeItem item04 = new TreeItem(tree, 0);
        item04.setText("five");
        TreeItem item05 = new TreeItem(tree, 0);
        item05.setText("six");
        this.shell.setLocation(0, 0);
        this.shell.pack();
        this.shell.open();
        int itemHeight = item00.getBounds().height;
        int clientHeight = this.scrolledComposite.getClientArea().height;
        this.scrolledComposite.setOrigin(0, 0);
        tree.setSelection(item00);
        int pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{tree});
        ScrollBarSupportTest.assertEquals((int)0, (int)pixels);
        tree.setSelection(item01);
        pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{tree});
        ScrollBarSupportTest.assertEquals((int)0, (int)pixels);
        tree.setSelection(item02);
        pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{tree});
        ScrollBarSupportTest.assertEquals((int)0, (int)pixels);
        tree.setSelection(item03);
        pixels = (Integer)ReflectionUtils.invokeHidden((Object)support, (String)"getScrollPixels", (Object[])new Object[]{tree});
        int expectedPixels = itemHeight * 4 - clientHeight;
        ScrollBarSupportTest.assertEquals((int)expectedPixels, (int)pixels);
    }

    private class MockModuleNavigationComponentProvider
    implements IModuleNavigationComponentProvider {
        private MockModuleNavigationComponentProvider() {
        }

        public Composite getNavigationComponent() {
            return ScrollBarSupportTest.this.shell;
        }

        public Composite getScrolledComponent() {
            return null;
        }

        public int calculateBounds() {
            return 0;
        }

        public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode moduleGroupNode) {
            return null;
        }

        public ModuleView getModuleViewForNode(IModuleNode moduleGroupNode) {
            return null;
        }

        public IModuleGroupNode getActiveModuleGroupNode() {
            return null;
        }

        public ISubApplicationNode getSubApplicationNode() {
            return null;
        }
    }
}

