/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.list;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.objecttransaction.impl.ObjectTransactionImpl;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.IObjectTransactionExtract;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.ObjectTransactionFactory;
import org.eclipse.riena.objecttransaction.list.value.Addresse;
import org.eclipse.riena.objecttransaction.list.value.Kunde;
import org.eclipse.riena.objecttransaction.list.value.Vertrag;
import org.eclipse.riena.objecttransaction.state.State;

@NonUITestCase
public class ObjectTransactionListTest
extends RienaTestCase {
    public void testSimpleAllNew() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleAllNew", objectTransaction);
    }

    public void testSimpleExistingKundeAllNew() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        objectTransaction.setCleanModus(false);
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleExistingKundeAllNew", objectTransaction);
    }

    public void testSimpleAllClean() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        objectTransaction.setCleanModus(false);
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleAllClean", objectTransaction);
    }

    public void testSimpleExistingKundeAllNewChangingAddresse() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        objectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse = new Addresse(true);
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        this.showStatus("testSimpleExistingKundeAllNewChangingAddresse", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSetAndGet() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=miller", (boolean)kunde.getNachname().equals("Miller"));
        this.showStatus("testSimpleWithNewKundeAndSetAndGet", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        this.showStatus("testSimpleWithNewKundeAndSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionAndCommit subObjectTransaction", subObjectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithNewAddress() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithNewAddress objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithNewAddress subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithChangedAddress() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        addresse = new Addresse(true);
        subObjectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddress objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddress subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithChangedAddressAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        addresse = new Addresse(true);
        subObjectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddressAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraege() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraege objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege1() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        kunde.removeVertrag(v1);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege1 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege2() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        kunde.removeVertrag("0815");
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege2 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege3() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        objectTransaction.setCleanModus(false);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        kunde.removeVertrag("0815");
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag 0815 gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege2 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraegeInSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraegeInSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.removeVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.removeVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.commit();
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.removeVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitRoot() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"anzahl vertr\u00e4ge ist nicht 2", (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"reihenfolge: erste Vertrag ist nicht 0815", (kunde.listVertrag()[0] == v1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"reihenfolge: zweiter Vertrag ist nicht 0816", (kunde.listVertrag()[1] == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.removeVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.commitToObjects();
        ObjectTransactionListTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitRootWithList() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        kunde.removeVertrag(v1);
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        ObjectTransactionListTest.assertTrue((String)"reihenfolge: erste Vertrag ist nicht 0816", (kunde.listVertrag()[0] == v2 ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        subObjectTransaction.commit();
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        objectTransaction.commitToObjects();
        ObjectTransactionListTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList objectTransaction", objectTransaction);
    }

    public void testImport() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        objectTransaction.setCleanModus(false);
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.setCleanModus(true);
        Kunde kunde2 = new Kunde("4711");
        kunde2.setVorname("john");
        kunde2.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde2.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde2.getNachname().equals("Miller"));
        objectTransaction2.setCleanModus(false);
        objectTransaction2.importExtract(extract);
        ObjectTransactionListTest.assertTrue((String)"vorname=john", (boolean)kunde2.getVorname().equals("jane"));
        ObjectTransactionListTest.assertTrue((String)"nachname=Miller", (boolean)kunde2.getNachname().equals("Stewart"));
    }

    public void testImport2() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertEquals((String)"vorname=john", (String)"john", (String)kunde.getVorname());
        ObjectTransactionListTest.assertEquals((String)"nachname=Miller", (String)"Miller", (String)kunde.getNachname());
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionListTest.assertEquals((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (int)2, (int)kunde.listVertrag().length);
        objectTransaction.setCleanModus(false);
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionListTest.assertSame((String)"reihenfolge: erste Vertrag ist nicht 0815", (Object)((Object)kunde.listVertrag()[0]), (Object)((Object)v1));
        ObjectTransactionListTest.assertSame((String)"reihenfolge: zweiter Vertrag ist nicht 0816", (Object)((Object)kunde.listVertrag()[1]), (Object)((Object)v2));
        kunde.removeVertrag("0815");
        ObjectTransactionListTest.assertEquals((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (int)1, (int)kunde.listVertrag().length);
        ObjectTransactionListTest.assertSame((String)"reihenfolge: erste Vertrag ist nicht 0816", (Object)((Object)kunde.listVertrag()[0]), (Object)((Object)v2));
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        IObjectTransaction objectTransaction2 = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.setCleanModus(true);
        Kunde kunde2 = new Kunde("4711");
        kunde2.setVorname("john");
        kunde2.setNachname("Miller");
        ObjectTransactionListTest.assertEquals((String)"vorname=john", (String)"john", (String)kunde2.getVorname());
        ObjectTransactionListTest.assertEquals((String)"nachname=Miller", (String)"Miller", (String)kunde2.getNachname());
        v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde2.addVertrag(v1);
        v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde2.addVertrag(v2);
        ObjectTransactionListTest.assertEquals((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (int)2, (int)kunde2.listVertrag().length);
        ObjectTransactionListTest.assertSame((String)"reihenfolge: erste Vertrag ist nicht 0815", (Object)((Object)kunde2.listVertrag()[0]), (Object)((Object)v1));
        ObjectTransactionListTest.assertSame((String)"reihenfolge: zweiter Vertrag ist nicht 0816", (Object)((Object)kunde2.listVertrag()[1]), (Object)((Object)v2));
        objectTransaction2.setCleanModus(false);
        objectTransaction2.importExtract(extract);
        ObjectTransactionListTest.assertEquals((String)"vorname=john", (String)"jane", (String)kunde2.getVorname());
        ObjectTransactionListTest.assertEquals((String)"nachname=Miller", (String)"Stewart", (String)kunde2.getNachname());
        ObjectTransactionListTest.assertNull((String)"vertrag 0815 must return null", (Object)((Object)kunde2.getVertrag("0815")));
        ObjectTransactionListTest.assertEquals((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (int)1, (int)kunde2.listVertrag().length);
        ObjectTransactionListTest.assertSame((String)"reihenfolge: erste Vertrag ist nicht 0816", (Object)((Object)kunde2.listVertrag()[0]), (Object)((Object)v2));
        kunde.removeVertrag("0816");
        ObjectTransactionListTest.assertEquals((String)"anzahl vertr\u00e4ge bei kunde ist falsch", (int)0, (int)kunde2.listVertrag().length);
    }

    public void testSimpleCheckVersion() {
        ObjectTransactionImpl objectTransaction = (ObjectTransactionImpl)ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionListTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionListTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionListTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionListTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionListTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionListTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        ObjectTransactionListTest.assertTrue((String)"kunde ist nicht CLEAN", (boolean)objectTransaction.isState((ITransactedObject)kunde, State.CLEAN));
        ObjectTransactionListTest.assertTrue((String)"addresse ist nicht CLEAN", (boolean)objectTransaction.isState((ITransactedObject)addresse, State.CLEAN));
        objectTransaction.setCleanModus(false);
        ObjectTransactionListTest.assertTrue((String)"kunde hat nicht version 1", (boolean)kunde.getVersion().equals("1"));
        ObjectTransactionListTest.assertTrue((String)"addresse hat nicht version 1", (boolean)addresse.getVersion().equals("1"));
        addresse.setPlz("70000");
        objectTransaction.setVersionUpdate((ITransactedObject)addresse, "1.1");
        ObjectTransactionListTest.assertTrue((String)"addresse hat nicht version 1.1", (boolean)addresse.getVersion().equals("1.1"));
        ObjectTransactionListTest.assertTrue((String)"addresse ist nicht MODIFIED", (boolean)objectTransaction.isState((ITransactedObject)addresse, State.MODIFIED));
        this.showStatus("testSimpleCheckVersion", (IObjectTransaction)objectTransaction);
    }

    public void testUpdateVersion() {
        ObjectTransactionImpl objectTransaction = (ObjectTransactionImpl)ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        objectTransaction.setCleanModus(false);
        ObjectTransactionListTest.assertTrue((String)"kunde ist nicht CLEAN", (boolean)objectTransaction.isState((ITransactedObject)kunde, State.CLEAN));
        kunde.setVorname("jim");
        ObjectTransactionListTest.assertTrue((String)"kunde ist nicht MODIFIED", (boolean)objectTransaction.isState((ITransactedObject)kunde, State.MODIFIED));
        IObjectTransactionExtract extract = objectTransaction.exportExtract();
        ObjectTransactionImpl objectTransaction2 = (ObjectTransactionImpl)ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction2.setCleanModus(true);
        Kunde kunde2 = new Kunde("4711");
        kunde2.setVorname("john");
        kunde2.setNachname("Miller");
        ObjectTransactionListTest.assertTrue((String)"kunde2 ist nicht CLEAN", (boolean)objectTransaction2.isState((ITransactedObject)kunde2, State.CLEAN));
        objectTransaction2.setCleanModus(false);
        objectTransaction2.importExtract(extract);
        ObjectTransactionListTest.assertTrue((String)"kunde2 ist nicht MODIFIED", (boolean)objectTransaction2.isState((ITransactedObject)kunde2, State.MODIFIED));
        objectTransaction2.commitToObjects();
        ObjectTransactionListTest.assertTrue((String)"kunde2 ist nicht CLEAN", (boolean)objectTransaction2.isState((ITransactedObject)kunde2, State.CLEAN));
        objectTransaction2.setVersionUpdate((ITransactedObject)kunde2, "2");
        ObjectTransactionListTest.assertTrue((String)"kunde2 ist nicht MODIFIED", (boolean)objectTransaction2.isState((ITransactedObject)kunde2, State.MODIFIED));
        extract = objectTransaction2.exportExtract();
        objectTransaction.commitToObjects();
        ObjectTransactionListTest.assertTrue((String)"kunde ist nicht CLEAN", (boolean)objectTransaction.isState((ITransactedObject)kunde, State.CLEAN));
        objectTransaction.importExtract(extract);
        ObjectTransactionListTest.assertTrue((String)"kunde ist nicht MODIFIED", (boolean)objectTransaction.isState((ITransactedObject)kunde, State.MODIFIED));
        this.showStatus("testUpdateVersion", (IObjectTransaction)objectTransaction);
    }

    private void showStatus(String testName, IObjectTransaction objectTransaction) {
        System.out.println("testname >>>>>" + testName + "<<<<<");
        System.out.println(objectTransaction);
    }
}

