/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.noreg;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.ObjectTransactionFactory;
import org.eclipse.riena.objecttransaction.noreg.value.Addresse;
import org.eclipse.riena.objecttransaction.noreg.value.Kunde;
import org.eclipse.riena.objecttransaction.noreg.value.Vertrag;

@NonUITestCase
public class ObjectTransactionWithoutTransactionTest
extends RienaTestCase {
    public void testSimpleAllNew() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleAllNew", objectTransaction);
    }

    public void testSimpleExistingKundeAllNew() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleExistingKundeAllNew", objectTransaction);
    }

    public void testSimpleAllClean() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname ist nicht Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname ist nicht john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr ist nicht 4711", (boolean)kunde.getKundennr().equals("4711"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleAllClean", objectTransaction);
    }

    public void testSimpleExistingKundeAllNewChangingAddresse() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        objectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse = new Addresse(true);
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"address ist nicht gesetzt", (kunde.getAddresse() != null ? 1 : 0) != 0);
        this.showStatus("testSimpleExistingKundeAllNewChangingAddresse", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSetAndGet() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=miller", (boolean)kunde.getNachname().equals("Miller"));
        this.showStatus("testSimpleWithNewKundeAndSetAndGet", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        this.showStatus("testSimpleWithNewKundeAndSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionAndCommit subObjectTransaction", subObjectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithNewAddress() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithNewAddress objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithNewAddress subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithChangedAddress() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        addresse = new Addresse(true);
        subObjectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddress objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddress subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithNewKundeAndSubTransactionWithChangedAddressAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Addresse addresse = new Addresse(true);
        kunde.setAddresse(addresse);
        addresse.setOrt("Frankfurt");
        addresse.setPlz("60000");
        addresse.setStrasse("M\u00fcnchnerstr.");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"kundenr=4711", (boolean)kunde.getKundennr().equals("4711"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=john", (boolean)kunde.getVorname().equals("john"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Miller", (boolean)kunde.getNachname().equals("Miller"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht Frankfurt", (boolean)addresse.getOrt().equals("Frankfurt"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 60000", (boolean)addresse.getPlz().equals("60000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht M\u00fcnchnerstr.", (boolean)addresse.getStrasse().equals("M\u00fcnchnerstr."));
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        subObjectTransaction.toString();
        kunde.setVorname("jane");
        kunde.setNachname("Stewart");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        addresse = new Addresse(true);
        subObjectTransaction.registerAsDeleted((ITransactedObject)kunde.getAddresse());
        addresse.setOrt("M\u00fcnchen");
        addresse.setPlz("80000");
        addresse.setStrasse("Leopoldstrasse");
        kunde.setAddresse(addresse);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"vorname=jane", (boolean)kunde.getVorname().equals("jane"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nachname=Stewart", (boolean)kunde.getNachname().equals("Stewart"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"ort in addresse ist nicht M\u00fcnchen", (boolean)addresse.getOrt().equals("M\u00fcnchen"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"plz in addresse ist nicht 80000", (boolean)addresse.getPlz().equals("80000"));
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"strasse ist nicht Leopoldstrasse", (boolean)addresse.getStrasse().equals("Leopoldstrasse"));
        this.showStatus("testSimpleWithNewKundeAndSubTransactionWithChangedAddressAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraege() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraege objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege1() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        kunde.removeVertrag(v1);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege1 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege2() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        kunde.removeVertrag("0815");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege2 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewAndRemoveVertraege3() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        kunde.removeVertrag("0815");
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag 0815 gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewAndRemoveVertraege2 objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraegeInSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithExistingKundeUndNewVertraegeInSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0816") == null ? 1 : 0) != 0);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndNewVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.removeVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction objectTransaction", objectTransaction);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransaction subObjectTransaction", subObjectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.removeVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.commit();
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.removeVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitRoot() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0815") == v1 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.removeVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        objectTransaction.commitToObjects();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"falscher oder keine Vertrag beim Kunden gefunden", (kunde.getVertrag("0816") == v2 ? 1 : 0) != 0);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)"nicht existierender Vertrag gefunden", (kunde.getVertrag("0815") == null ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommit objectTransaction", objectTransaction);
    }

    public void testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitRootWithList() {
        IObjectTransaction objectTransaction = ObjectTransactionFactory.getInstance().createObjectTransaction();
        objectTransaction.setCleanModus(true);
        Kunde kunde = new Kunde("4711");
        kunde.setVorname("john");
        kunde.setNachname("Miller");
        Vertrag v1 = new Vertrag("0815");
        v1.setVertragsBeschreibung("mein erster Vertrag");
        kunde.addVertrag(v1);
        Vertrag v2 = new Vertrag("0816");
        v2.setVertragsBeschreibung("noch ein Vertrag");
        kunde.addVertrag(v2);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 2 Vertr\u00e4ge sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 2 ? 1 : 0) != 0);
        IObjectTransaction subObjectTransaction = ObjectTransactionFactory.getInstance().createSubObjectTransaction(objectTransaction);
        subObjectTransaction.setCleanModus(true);
        kunde.removeVertrag(v1);
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        subObjectTransaction.registerAsDeleted((ITransactedObject)v1);
        subObjectTransaction.commit();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        objectTransaction.commitToObjects();
        ObjectTransactionWithoutTransactionTest.assertTrue((String)("Es gibt nicht 1 Vertrag sondern :" + kunde.listVertrag().length), (kunde.listVertrag().length == 1 ? 1 : 0) != 0);
        this.showStatus("testSimpleWithExistingKundeUndRemoveVertraegeInSubTransactionAndCommitWithList objectTransaction", objectTransaction);
    }

    private void showStatus(String testName, IObjectTransaction objectTransaction) {
        System.out.println("testname >>>>>" + testName + "<<<<<");
        System.out.println(objectTransaction);
    }
}

