/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common;

import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.security.common.authentication.Callback2CredentialConverter;
import org.eclipse.riena.security.common.authentication.credentials.AbstractCredential;
import org.eclipse.riena.security.common.authentication.credentials.ChoiceCredential;
import org.eclipse.riena.security.common.authentication.credentials.CustomCredential;
import org.eclipse.riena.security.common.authentication.credentials.NameCredential;
import org.eclipse.riena.security.common.authentication.credentials.PasswordCredential;
import org.eclipse.riena.security.common.authentication.credentials.TextInputCredential;

@NonUITestCase
public class Callback2CredentialConverterTest
extends TestCase {
    public void testSimpleName1() {
        Callback[] callbacks = new Callback[]{new NameCallback("userid", "cca")};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof NameCredential));
        NameCredential nCred = (NameCredential)credentials[0];
        Callback2CredentialConverterTest.assertTrue((boolean)nCred.getPrompt().equals("userid"));
        Callback2CredentialConverterTest.assertTrue((boolean)nCred.getDefaultName().equals("cca"));
        Callback2CredentialConverterTest.assertTrue((nCred.getName() == null ? 1 : 0) != 0);
        Callback[] callbacksReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbacksReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbacksReturned[0] instanceof NameCallback));
        NameCallback ncb = (NameCallback)callbacksReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)ncb.getPrompt().equals("userid"));
        Callback2CredentialConverterTest.assertTrue((boolean)ncb.getDefaultName().equals("cca"));
        Callback2CredentialConverterTest.assertTrue((ncb.getName() == null ? 1 : 0) != 0);
    }

    public void testSimpleName2() {
        NameCallback temp = new NameCallback("userid", "cca");
        temp.setName("christian");
        Callback[] callbacks = new Callback[]{temp};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof NameCredential));
        NameCredential nCred = (NameCredential)credentials[0];
        Callback2CredentialConverterTest.assertTrue((boolean)nCred.getPrompt().equals("userid"));
        Callback2CredentialConverterTest.assertTrue((boolean)nCred.getDefaultName().equals("cca"));
        Callback2CredentialConverterTest.assertTrue((boolean)nCred.getName().equals("christian"));
        Callback[] callbacksReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbacksReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbacksReturned[0] instanceof NameCallback));
        NameCallback ncb = (NameCallback)callbacksReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)ncb.getPrompt().equals("userid"));
        Callback2CredentialConverterTest.assertTrue((boolean)ncb.getDefaultName().equals("cca"));
        Callback2CredentialConverterTest.assertTrue((boolean)ncb.getName().equals("christian"));
    }

    public void testMultipleCredentials() {
        Callback[] callbacks = new Callback[]{new PasswordCallback("password", false), new TextInputCallback("textinp", "default-text")};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 2 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof PasswordCredential));
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[1] instanceof TextInputCredential));
        PasswordCredential pc = (PasswordCredential)credentials[0];
        TextInputCredential tic = (TextInputCredential)credentials[1];
        Callback2CredentialConverterTest.assertTrue((boolean)pc.getPrompt().equals("password"));
        Callback2CredentialConverterTest.assertFalse((boolean)pc.isEchoOn());
        Callback2CredentialConverterTest.assertTrue((boolean)tic.getPrompt().equals("textinp"));
        Callback2CredentialConverterTest.assertTrue((boolean)tic.getDefaultText().equals("default-text"));
        Callback2CredentialConverterTest.assertTrue((tic.getText() == null ? 1 : 0) != 0);
        Callback[] callbacksReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbacksReturned.length == 2 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbacksReturned[0] instanceof PasswordCallback));
        Callback2CredentialConverterTest.assertTrue((boolean)(callbacksReturned[1] instanceof TextInputCallback));
        PasswordCallback pcb = (PasswordCallback)callbacksReturned[0];
        TextInputCallback ticb = (TextInputCallback)callbacksReturned[1];
        Callback2CredentialConverterTest.assertTrue((boolean)pcb.getPrompt().equals("password"));
        Callback2CredentialConverterTest.assertFalse((boolean)pcb.isEchoOn());
        Callback2CredentialConverterTest.assertTrue((boolean)ticb.getPrompt().equals("textinp"));
        Callback2CredentialConverterTest.assertTrue((boolean)ticb.getDefaultText().equals("default-text"));
        Callback2CredentialConverterTest.assertTrue((ticb.getText() == null ? 1 : 0) != 0);
    }

    public void testChoiceCredential1() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, true);
        choiceCallback.setSelectedIndex(1);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)credentials[0].getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof ChoiceCredential));
        ChoiceCredential cc = (ChoiceCredential)credentials[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.isMultipleSelectionsAllowed());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelections(), new int[]{1}));
    }

    public void testChoiceCredential2() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, false);
        choiceCallback.setSelectedIndex(1);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)credentials[0].getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof ChoiceCredential));
        ChoiceCredential cc = (ChoiceCredential)credentials[0];
        Callback2CredentialConverterTest.assertFalse((boolean)cc.isMultipleSelectionsAllowed());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelections(), new int[]{1}));
    }

    public void testChoiceCredential3() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, true);
        int[] nArray = new int[2];
        nArray[1] = 2;
        choiceCallback.setSelectedIndexes(nArray);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)credentials[0].getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof ChoiceCredential));
        ChoiceCredential cc = (ChoiceCredential)credentials[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.isMultipleSelectionsAllowed());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelections(), nArray2));
    }

    public void testChoiceCredential4() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, true);
        choiceCallback.setSelectedIndex(1);
        choiceCallback.setSelectedIndex(2);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)credentials[0].getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof ChoiceCredential));
        ChoiceCredential cc = (ChoiceCredential)credentials[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.isMultipleSelectionsAllowed());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelections(), new int[]{2}));
    }

    public void testChoiceCredential5() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, true);
        choiceCallback.setSelectedIndex(1);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback[] callbackReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbackReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbackReturned[0] instanceof ChoiceCallback));
        ChoiceCallback cc = (ChoiceCallback)callbackReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)cc.allowMultipleSelections());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelectedIndexes(), new int[]{1}));
    }

    public void testChoiceCredential6() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, false);
        choiceCallback.setSelectedIndex(1);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback[] callbackReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbackReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbackReturned[0] instanceof ChoiceCallback));
        ChoiceCallback cc = (ChoiceCallback)callbackReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertFalse((boolean)cc.allowMultipleSelections());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelectedIndexes(), new int[]{1}));
    }

    public void testChoiceCredential7() {
        ChoiceCallback choiceCallback = new ChoiceCallback("choicePrompt", new String[]{"a", "b", "c"}, 0, true);
        int[] nArray = new int[2];
        nArray[1] = 2;
        choiceCallback.setSelectedIndexes(nArray);
        Callback[] callbacks = new Callback[]{choiceCallback};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback[] callbackReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbackReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbackReturned[0] instanceof ChoiceCallback));
        ChoiceCallback cc = (ChoiceCallback)callbackReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)cc.getPrompt().equals("choicePrompt"));
        Callback2CredentialConverterTest.assertTrue((boolean)cc.allowMultipleSelections());
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getChoices(), new String[]{"a", "b", "c"}));
        Callback2CredentialConverterTest.assertTrue((cc.getDefaultChoice() == 0 ? 1 : 0) != 0);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        Callback2CredentialConverterTest.assertTrue((boolean)Arrays.equals(cc.getSelectedIndexes(), nArray2));
    }

    public void testCustomCredentials() {
        Callback[] callbacks = new Callback[]{new MyCallback("valueOne", "valueTwo")};
        AbstractCredential[] credentials = Callback2CredentialConverter.callbacks2Credentials((Callback[])callbacks);
        Callback2CredentialConverterTest.assertTrue((credentials.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(credentials[0] instanceof CustomCredential));
        Callback[] callbacksReturned = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
        Callback2CredentialConverterTest.assertTrue((callbacksReturned.length == 1 ? 1 : 0) != 0);
        Callback2CredentialConverterTest.assertTrue((boolean)(callbacksReturned[0] instanceof MyCallback));
        MyCallback mycb = (MyCallback)callbacksReturned[0];
        Callback2CredentialConverterTest.assertTrue((boolean)mycb.getValue1().equals("valueOne"));
        Callback2CredentialConverterTest.assertTrue((boolean)mycb.getValue2().equals("valueTwo"));
    }

    public static class MyCallback
    implements Callback {
        private final String value1;
        private final String value2;

        public MyCallback(String value1, String value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public String getValue1() {
            return this.value1;
        }

        public String getValue2() {
            return this.value2;
        }
    }
}

