/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.ui.filter;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.security.ui.filter.NodeStructureObserver;

@NonUITestCase
public class NodeStructureObserverTest
extends TestCase {
    public void testDelegation() {
        ApplicationNode app = new ApplicationNode();
        SubApplicationNode subApp1 = new SubApplicationNode(new NavigationNodeId("subapp1"));
        app.addChild((INavigationNode)subApp1);
        SubApplicationNode subApp2 = new SubApplicationNode(new NavigationNodeId("subapp2"));
        app.addChild((INavigationNode)subApp2);
        ModuleGroupNode mg1 = new ModuleGroupNode(new NavigationNodeId("mg1"));
        subApp1.addChild((INavigationNode)mg1);
        ModuleGroupNode mg2 = new ModuleGroupNode(new NavigationNodeId("mg2"));
        subApp2.addChild((INavigationNode)mg2);
        ModuleNode m1 = new ModuleNode(new NavigationNodeId("m1"));
        mg1.addChild((INavigationNode)m1);
        ModuleNode m2 = new ModuleNode(new NavigationNodeId("m2"));
        mg2.addChild((INavigationNode)m2);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        m1.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        m2.addChild((INavigationNode)sm2);
        app.activate();
        SubModuleNode toAdd1 = new SubModuleNode(new NavigationNodeId("fresh1"));
        ISimpleNavigationNodeListener listener = (ISimpleNavigationNodeListener)EasyMock.createNiceMock(ISimpleNavigationNodeListener.class);
        listener.childAdded((INavigationNode)m1, (INavigationNode)toAdd1);
        EasyMock.replay((Object[])new Object[]{listener});
        NodeStructureObserver observer = new NodeStructureObserver((IApplicationNode)app, listener);
        observer.start();
        m1.addChild((INavigationNode)toAdd1);
        EasyMock.verify((Object[])new Object[]{listener});
        observer.stop();
        EasyMock.reset((Object[])new Object[]{listener});
        EasyMock.replay((Object[])new Object[]{listener});
        SubModuleNode toAdd2 = new SubModuleNode(new NavigationNodeId("fresh2"));
        m1.addChild((INavigationNode)toAdd2);
        EasyMock.verify((Object[])new Object[]{listener});
    }
}

