/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.easymock.EasyMock;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.IValidationCallback;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;

@NonUITestCase
public class ValidatorCollectionTest
extends RienaTestCase {
    private static final IValidator ALWAYS_SUCCEED_1 = new IValidator(){

        public IStatus validate(Object value) {
            return Status.OK_STATUS;
        }
    };
    private static final IValidator ALWAYS_SUCCEED_2 = new IValidator(){

        public IStatus validate(Object value) {
            return Status.OK_STATUS;
        }
    };
    private static final IValidator ALWAYS_FAIL_1 = new IValidator(){

        public IStatus validate(Object value) {
            return Status.CANCEL_STATUS;
        }
    };
    private static final IValidator ALWAYS_FAIL_2 = new IValidator(){

        public IStatus validate(Object value) {
            return Status.CANCEL_STATUS;
        }
    };
    private static final IValidator ALWAYS_THROW_EXCEPTION = new IValidator(){

        public IStatus validate(Object value) {
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + "will always throw this excepion!");
        }
    };

    public void testJointStatus() {
        ValidatorCollection rule = new ValidatorCollection();
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_SUCCEED_2);
        ValidatorCollectionTest.assertTrue((boolean)rule.validate(null).isOK());
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_SUCCEED_1);
        ValidatorCollectionTest.assertFalse((boolean)rule.validate(null).isOK());
        rule = new ValidatorCollection();
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_FAIL_2);
        ValidatorCollectionTest.assertFalse((boolean)rule.validate(null).isOK());
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_FAIL_2);
        ValidatorCollectionTest.assertFalse((boolean)rule.validate(null).isOK());
    }

    public void testConcurrentModification() {
        ValidatorCollection rule = new ValidatorCollection();
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_SUCCEED_2);
        rule.add(ALWAYS_SUCCEED_2);
        rule.add(ALWAYS_SUCCEED_2);
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_FAIL_2);
        rule.add(ALWAYS_THROW_EXCEPTION);
        for (IValidator validator : rule) {
            if (validator != ALWAYS_SUCCEED_1) continue;
            rule.remove(validator);
        }
        ValidatorCollectionTest.assertEquals((int)4, (int)rule.getValidators().size());
        for (IValidator validator : rule.getValidators()) {
            if (validator != ALWAYS_SUCCEED_2) continue;
            rule.remove(validator);
        }
        ValidatorCollectionTest.assertEquals((int)3, (int)rule.getValidators().size());
        try {
            rule.iterator().remove();
            ValidatorCollectionTest.fail((String)"the returned iterator may not support the remove() method, modification through rule#remove(IValidator) only.");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            rule.getValidators().clear();
            ValidatorCollectionTest.fail((String)"the returned collection may not support the remove() method, modification through rule#remove(IValidator) only.");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
    }

    public void testExceptions() {
        ValidatorCollection rule = new ValidatorCollection();
        rule.add(ALWAYS_THROW_EXCEPTION);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule.add(ALWAYS_THROW_EXCEPTION);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_THROW_EXCEPTION);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_THROW_EXCEPTION);
        rule.add(ALWAYS_SUCCEED_1);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_THROW_EXCEPTION);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_THROW_EXCEPTION);
        rule.add(ALWAYS_FAIL_1);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_THROW_EXCEPTION);
        rule.add(ALWAYS_SUCCEED_1);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
        rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_SUCCEED_1);
        rule.add(ALWAYS_THROW_EXCEPTION);
        try {
            rule.validate(new Object());
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidatorCollectionTest.fail((String)"expected a thrown ValidationFailure instead");
        }
    }

    public void testValidationCallback() {
        ValidatorCollection rule = new ValidatorCollection();
        rule.add(ALWAYS_FAIL_1);
        rule.add(ALWAYS_SUCCEED_1);
        IValidationCallback callback = (IValidationCallback)EasyMock.createMock(IValidationCallback.class);
        callback.validationRuleChecked(ALWAYS_FAIL_1, Status.CANCEL_STATUS);
        callback.validationRuleChecked(ALWAYS_SUCCEED_1, Status.OK_STATUS);
        callback.validationResult((IStatus)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{callback});
        rule.validate(new Object(), callback);
        EasyMock.verify((Object[])new Object[]{callback});
    }
}

