/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.BorderControlDecoration;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.nebula.widgets.compositetable.AbsoluteLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BorderControlDecorationTest
extends TestCase {
    private Display display;
    private Shell shell;
    private Text text;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.shell.setBounds(10, 10, 200, 100);
        this.shell.setLayout((Layout)new AbsoluteLayout());
        this.text = new Text((Composite)this.shell, 2048);
        this.text.setLayoutData((Object)new Rectangle(4, 6, 40, 20));
    }

    protected void tearDown() {
        SwtUtilities.dispose((Widget)this.text);
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testShouldShowDecoration() {
        BorderControlDecoration deco = new BorderControlDecoration((Control)this.text, 2);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)deco, (String)"shouldShowDecoration", (Object[])new Object[0]);
        BorderControlDecorationTest.assertFalse((boolean)ret);
        this.shell.setVisible(true);
        deco.show();
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)deco, (String)"shouldShowDecoration", (Object[])new Object[0]);
        BorderControlDecorationTest.assertTrue((boolean)ret);
        deco.hide();
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)deco, (String)"shouldShowDecoration", (Object[])new Object[0]);
        BorderControlDecorationTest.assertFalse((boolean)ret);
        deco.dispose();
        deco = new BorderControlDecoration((Control)this.text, 0);
        deco.show();
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)deco, (String)"shouldShowDecoration", (Object[])new Object[0]);
        BorderControlDecorationTest.assertFalse((boolean)ret);
        deco.dispose();
        this.shell.setVisible(false);
    }

    public void testGetDecorationRectangle() {
        this.shell.setVisible(true);
        BorderControlDecoration deco = new BorderControlDecoration((Control)this.text, 2);
        Rectangle decoRect = (Rectangle)ReflectionUtils.invokeHidden((Object)deco, (String)"getDecorationRectangle", (Object[])new Object[]{this.shell});
        BorderControlDecorationTest.assertEquals((Object)new Rectangle(2, 4, 43, 23), (Object)decoRect);
        this.shell.setVisible(false);
    }
}

