/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public class SWTBindingPropertyLocatorTest
extends TestCase {
    private Shell shell;

    protected void setUp() {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
    }

    public void testLocateBindingProperty() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        String prop = locator.locateBindingProperty((Object)this.shell);
        SWTBindingPropertyLocatorTest.assertEquals(null, (String)prop);
        Label label = new Label((Composite)this.shell, 0);
        locator.setBindingProperty((Object)label, "label1");
        prop = locator.locateBindingProperty((Object)label);
        SWTBindingPropertyLocatorTest.assertEquals((String)"label1", (String)prop);
        label.dispose();
        prop = locator.locateBindingProperty((Object)label);
        SWTBindingPropertyLocatorTest.assertEquals(null, (String)prop);
        prop = locator.locateBindingProperty(null);
        SWTBindingPropertyLocatorTest.assertEquals(null, (String)prop);
        prop = locator.locateBindingProperty(new Object());
        SWTBindingPropertyLocatorTest.assertEquals(null, (String)prop);
    }

    public void testLocateBindingPropertyInComplexComponent() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        TestComplexComponent complexComponent = new TestComplexComponent((Composite)this.shell, 0);
        Text text = new Text((Composite)complexComponent, 0);
        locator.setBindingProperty((Object)complexComponent, "complex1");
        SWTBindingPropertyLocatorTest.assertEquals(null, (String)locator.locateBindingProperty((Object)text));
        locator.setBindingProperty((Object)text, "text1");
        SWTBindingPropertyLocatorTest.assertEquals((String)"text1", (String)locator.locateBindingProperty((Object)text));
        try {
            locator.setBindingProperty((Object)complexComponent, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SWTBindingPropertyLocatorTest.assertEquals((String)"text1", (String)locator.locateBindingProperty((Object)text));
    }

    public void testLocateBindingPropertyInComplexComponentWithNesting() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        TestComplexComponent complexComponent = new TestComplexComponent((Composite)this.shell, 0);
        Composite composite = new Composite((Composite)complexComponent, 0);
        Text text = new Text(composite, 0);
        locator.setBindingProperty((Object)complexComponent, "complex1");
        locator.setBindingProperty((Object)text, "text");
        SWTBindingPropertyLocatorTest.assertEquals((String)"text", (String)locator.locateBindingProperty((Object)text));
    }

    public void testGetControlsWithBindingProperty() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        Label label1 = new Label(composite1, 0);
        Label label2 = new Label(composite1, 0);
        locator.setBindingProperty((Object)label1, "label1");
        locator.setBindingProperty((Object)label2, "label2");
        List result1 = SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)composite1);
        SWTBindingPropertyLocatorTest.assertEquals((int)2, (int)result1.size());
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result1.contains(label1));
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result1.contains(label2));
    }

    public void testGetControlsWithBindingPropertyExcludeFirstComposite() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        Label label1 = new Label(composite1, 0);
        locator.setBindingProperty((Object)composite1, "complex1");
        locator.setBindingProperty((Object)label1, "label1");
        List result1 = SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)composite1);
        SWTBindingPropertyLocatorTest.assertEquals((int)1, (int)result1.size());
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result1.contains(label1));
    }

    public void testGetControlsWithBindingPropertyRecursive() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        locator.setBindingProperty((Object)composite1, "composite1");
        Composite composite2 = new Composite(composite1, 0);
        locator.setBindingProperty((Object)composite2, "composite2");
        Label c2Label1 = new Label(composite2, 0);
        locator.setBindingProperty((Object)c2Label1, "label1");
        Label c2Label2 = new Label(composite2, 0);
        locator.setBindingProperty((Object)c2Label2, "label2");
        List result = SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)composite1);
        SWTBindingPropertyLocatorTest.assertEquals((int)3, (int)result.size());
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result.contains(composite2));
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result.contains(c2Label1));
        SWTBindingPropertyLocatorTest.assertTrue((boolean)result.contains(c2Label2));
    }

    public void testGetControlsWithBindingPropertyConflict() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        Label label1 = new Label(composite1, 0);
        Label label2 = new Label(composite1, 0);
        locator.setBindingProperty((Object)composite1, "composite1");
        locator.setBindingProperty((Object)label1, "label");
        locator.setBindingProperty((Object)label2, "label");
        try {
            SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)composite1);
            SWTBindingPropertyLocatorTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testGetControlsWithBindingPropertyRecursiveConflict() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        Label label1 = new Label(composite1, 0);
        Composite composite2 = new Composite(composite1, 0);
        Label label2 = new Label(composite2, 0);
        locator.setBindingProperty((Object)composite1, "composite1");
        locator.setBindingProperty((Object)label1, "label");
        locator.setBindingProperty((Object)label2, "label");
        try {
            SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)composite1);
            SWTBindingPropertyLocatorTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testGetControlsWithBindingPropertyRecursiveConflict2() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Composite composite1 = new Composite((Composite)this.shell, 0);
        Composite composite2 = new Composite((Composite)this.shell, 0);
        Label c1Label1 = new Label(composite1, 0);
        Label c2Label1 = new Label(composite2, 0);
        locator.setBindingProperty((Object)composite1, "composite1");
        locator.setBindingProperty((Object)composite2, "composite2");
        locator.setBindingProperty((Object)c1Label1, "label");
        locator.setBindingProperty((Object)c2Label1, "label");
        try {
            SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)this.shell);
            SWTBindingPropertyLocatorTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestComplexComponent
    extends Composite
    implements IComplexComponent {
        public TestComplexComponent(Composite parent, int style) {
            super(parent, style);
        }

        public List<Object> getUIControls() {
            return null;
        }
    }
}

