/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IInfoFlyoutRidget;
import org.eclipse.riena.ui.swt.InfoFlyout;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;

public class InfoFlyoutRidget
extends AbstractRidget
implements IInfoFlyoutRidget {
    private InfoFlyout infoFlyout;
    private BlockingQueue<IInfoFlyoutRidget.InfoFlyoutData> infos;
    private SwtUISynchronizer syncher;
    private Worker worker = null;

    public InfoFlyoutRidget() {
        this.infos = new LinkedBlockingQueue<IInfoFlyoutRidget.InfoFlyoutData>();
        this.syncher = new SwtUISynchronizer();
    }

    public InfoFlyoutRidget(InfoFlyout infoFlyout) {
        this.setUIControl(infoFlyout);
    }

    public InfoFlyout getUIControl() {
        return this.infoFlyout;
    }

    public void setUIControl(Object uiControl) {
        this.infoFlyout = (InfoFlyout)uiControl;
    }

    public String getID() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        return locator.locateBindingProperty((Object)this.getUIControl());
    }

    public void addInfo(IInfoFlyoutRidget.InfoFlyoutData info) {
        if (this.worker == null) {
            this.worker = new Worker();
            this.worker.start();
        }
        SWTFacade.getDefault().beforeInfoFlyoutShow(this.infoFlyout);
        try {
            this.infos.put(info);
        }
        catch (InterruptedException e) {
            new ConsoleLogger(InfoFlyoutRidget.class.getName()).log(1, "Queueing info failed: " + info, (Throwable)e);
        }
    }

    public void requestFocus() {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean hasFocus() {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean isFocusable() {
        throw new UnsupportedOperationException("not supported");
    }

    public void setFocusable(boolean focusable) {
        throw new UnsupportedOperationException("not supported");
    }

    public String getToolTipText() {
        throw new UnsupportedOperationException("not supported");
    }

    public void setToolTipText(String toolTipText) {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean isEnabled() {
        throw new UnsupportedOperationException("not supported");
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean isVisible() {
        throw new UnsupportedOperationException("not supported");
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("not supported");
    }

    private class Worker
    extends Thread {
        private final int sleepTime = LnfManager.getLnf().getIntegerSetting("InfoFlyout.showhidetime") * 2 + LnfManager.getLnf().getIntegerSetting("InfoFlyout.waittime") + LnfManager.getLnf().getIntegerSetting("InfoFlyout.pausetime");

        private Worker() {
        }

        public void run() {
            try {
                while (true) {
                    IInfoFlyoutRidget.InfoFlyoutData info = (IInfoFlyoutRidget.InfoFlyoutData)InfoFlyoutRidget.this.infos.take();
                    this.processInfo(info);
                    Thread.sleep(this.sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        private void processInfo(final IInfoFlyoutRidget.InfoFlyoutData info) {
            InfoFlyoutRidget.this.infoFlyout.waitForClosing();
            InfoFlyoutRidget.this.syncher.syncExec(new Runnable(){

                public void run() {
                    try {
                        InfoFlyoutRidget.this.infoFlyout.setMessage(info.getMessage());
                        InfoFlyoutRidget.this.infoFlyout.setIcon(info.getIcon());
                        InfoFlyoutRidget.this.infoFlyout.openFlyout();
                    }
                    finally {
                        if (InfoFlyoutRidget.this.infos.isEmpty()) {
                            SWTFacade.getDefault().afterInfoFlyoutShow(InfoFlyoutRidget.this.infoFlyout);
                        }
                    }
                }
            });
        }
    }
}

