/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineNumberRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineUIProcessRidget;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;

public class StatuslineRidget
extends AbstractCompositeRidget
implements IStatuslineRidget {
    private static final String LONG_EMPTY_STRING = "            ";
    private String message = "            ";
    private Image image;
    private IStatuslineNumberRidget statuslineNumberRidget;
    private IStatuslineUIProcessRidget statuslineUIProcessRidget;

    public Statusline getUIControl() {
        return (Statusline)super.getUIControl();
    }

    protected void bindUIControl() {
        this.updateImage();
        this.updateMessage();
    }

    public void clear() {
        this.setImage(null);
        this.setMessage(LONG_EMPTY_STRING);
    }

    public void error(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.errorIcon"));
        this.setMessage(message);
    }

    public String getMessage() {
        return this.message;
    }

    public IStatuslineNumberRidget getStatuslineNumberRidget() {
        return this.statuslineNumberRidget;
    }

    public void setStatuslineNumberRidget(IStatuslineNumberRidget statuslineNumberRidget) {
        this.statuslineNumberRidget = statuslineNumberRidget;
        this.addRidget("statuslineNumberRidget", (IRidget)statuslineNumberRidget);
    }

    public void setStatuslineUIProcessRidget(IStatuslineUIProcessRidget statuslineUIProcessRidget) {
        this.addRidget("statuslineUIProcessRidget", (IRidget)statuslineUIProcessRidget);
        this.statuslineUIProcessRidget = statuslineUIProcessRidget;
    }

    public IStatuslineUIProcessRidget getStatuslineUIProcessRidget() {
        return this.statuslineUIProcessRidget;
    }

    public void info(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.infoIcon"));
        this.setMessage(message);
    }

    public void setMessage(String message) {
        if (message != null && !message.equals(this.message)) {
            this.message = message;
            this.updateMessage();
        }
    }

    public void warning(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.warningIcon"));
        this.setMessage(message);
    }

    public String getID() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        return locator.locateBindingProperty((Object)this.getUIControl());
    }

    private void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            this.updateImage();
        }
    }

    private void updateImage() {
        Statusline control = this.getUIControl();
        if (control != null) {
            control.getMessageComposite().setImage(this.image);
        }
    }

    private void updateMessage() {
        Statusline control = this.getUIControl();
        if (control != null) {
            control.getMessageComposite().setMessage(this.message);
        }
    }
}

