/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class EmbeddedTitleBarToolTip
extends DefaultToolTip {
    private final EmbeddedTitleBar embeddedTitleBar;

    public EmbeddedTitleBarToolTip(EmbeddedTitleBar parent) {
        super((Control)parent);
        this.embeddedTitleBar = parent;
        this.setShift(new Point(0, 0));
    }

    public Point getLocation(Point tipSize, Event event) {
        GC gc = new GC((Drawable)this.embeddedTitleBar);
        try {
            Point location;
            Rectangle bounds = this.getLnfTitlebarRenderer().computeTextBounds(gc);
            Point point = location = this.embeddedTitleBar.toDisplay(bounds.x, 0);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        CLabel label = new CLabel(parent, this.getStyle(event));
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (font != null) {
            label.setFont(font);
        }
        label.setText(this.embeddedTitleBar.getTitle());
        return label;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            this.initLookAndFeel();
            should = this.embeddedTitleBar.isTextClipped();
        }
        return should;
    }

    private void initLookAndFeel() {
        Color color;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Integer delay = lnf.getIntegerSetting("ModuleItemToolTip.popupDelay");
        if (delay != null) {
            this.setPopupDelay(delay);
        }
        if ((color = lnf.getColor("ModuleItemToolTip.foreground")) != null) {
            this.setForegroundColor(color);
        }
        if ((color = lnf.getColor("ModuleItemToolTip.background")) != null) {
            this.setBackgroundColor(color);
        }
        Font font = lnf.getFont("ModuleItemToolTip.font");
        if (color != null) {
            this.setFont(font);
        }
    }

    private EmbeddedTitlebarRenderer getLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)LnfManager.getLnf().getRenderer("SubModuleView.titlebarRenderer");
        if (renderer == null) {
            renderer = new EmbeddedTitlebarRenderer();
        }
        return renderer;
    }
}

