/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.beans.Beans;
import java.util.EventListener;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.AbstractTitleBarMouseListener;
import org.eclipse.riena.ui.swt.IRienaDialog;
import org.eclipse.riena.ui.swt.LnfRendererExtension;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRendererExtension;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogTitleBarRenderer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

@Deprecated
public class RienaDialogDelegate {
    private boolean hideOsBorder;
    private AbstractTitleBarMouseListener mouseListener;
    private boolean closeable;
    private boolean maximizeable;
    private boolean minimizeable;
    private boolean resizeable;
    private boolean applicationModal;
    private final IRienaDialog dialog;
    private Composite topComposite;
    private Composite centerComposite;

    public RienaDialogDelegate(IRienaDialog dialog) {
        this.dialog = dialog;
        if (Beans.isDesignTime() || Activator.getDefault() == null) {
            ILnfRendererExtension[] extensions = new ILnfRendererExtension[]{new LnfRendererExtension(new DialogBorderRenderer(), "Dialog.borderRenderer"), new LnfRendererExtension(new DialogTitleBarRenderer(), "Dialog.renderer")};
            LnfManager.getLnf().update(extensions);
        }
    }

    public void evaluateStyle() {
        int style = this.dialog.getShellStyle();
        this.setCloseable((style & 0x40) == 64);
        this.setMinimizeable((style & 0x80) == 128);
        this.setMaximizeable((style & 0x400) == 1024);
        this.setResizeable((style & 0x10) == 16);
        this.setApplicationModal((style & 0x10000) == 65536);
    }

    public void initDialog() {
        this.updateDialogStyle();
    }

    public Control createContents(Composite parent) {
        int padding = 0;
        Composite contentsComposite = new Composite(parent, 0);
        contentsComposite.setLayout((Layout)new FormLayout());
        if (this.isHideOsBorder()) {
            SWTFacade.getDefault().addPaintListener((Control)contentsComposite, (EventListener)((Object)new DialogBorderPaintListener()));
            padding = this.getBorderWidth();
        }
        contentsComposite.setLayoutData((Object)new GridData(1808));
        int titleBarHeight = 0;
        this.topComposite = new Composite(contentsComposite, 0);
        if (this.isHideOsBorder()) {
            titleBarHeight = this.getTitleBarHeight();
            SWTFacade.getDefault().addPaintListener((Control)this.topComposite, (EventListener)((Object)new DialogPaintListener()));
            this.mouseListener = new DialogTitleBarMouseListener();
            this.topComposite.addMouseListener((MouseListener)this.mouseListener);
            SWTFacade.getDefault().addMouseMoveListener((Control)this.topComposite, this.mouseListener);
            SWTFacade.getDefault().addMouseTrackListener((Control)this.topComposite, this.mouseListener);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, padding);
        formData.top = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        formData.bottom = new FormAttachment(0, titleBarHeight);
        this.topComposite.setLayoutData((Object)formData);
        this.centerComposite = new Composite(contentsComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.centerComposite.setLayout((Layout)layout);
        formData = new FormData();
        formData.left = new FormAttachment(0, padding);
        formData.top = new FormAttachment((Control)this.topComposite);
        formData.right = new FormAttachment(100, -padding);
        formData.bottom = new FormAttachment(100, -padding);
        this.centerComposite.setLayoutData((Object)formData);
        return contentsComposite;
    }

    public void setHideOsBorder(boolean hideOsBorder) {
        this.hideOsBorder = hideOsBorder;
    }

    public boolean isHideOsBorder() {
        return this.hideOsBorder;
    }

    public void removeDialogTitleBarMouseListener() {
        if (this.topComposite != null && this.mouseListener != null) {
            this.topComposite.removeMouseListener((MouseListener)this.mouseListener);
            SWTFacade.getDefault().removeMouseMoveListener((Control)this.topComposite, this.mouseListener);
            SWTFacade.getDefault().removeMouseTrackListener((Control)this.topComposite, this.mouseListener);
            this.mouseListener.dispose();
            this.mouseListener = null;
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isMaximizeable() {
        return this.maximizeable;
    }

    public boolean isMinimizeable() {
        return this.minimizeable;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public boolean isApplicationModal() {
        return this.applicationModal;
    }

    public Composite getCenterComposite() {
        return this.centerComposite;
    }

    private int getBorderWidth() {
        DialogBorderRenderer borderRenderer = (DialogBorderRenderer)LnfManager.getLnf().getRenderer("Dialog.borderRenderer");
        return borderRenderer != null ? borderRenderer.getBorderWidth() : 0;
    }

    private int getTitleBarHeight() {
        DialogTitleBarRenderer titleBarRenderer = (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
        return titleBarRenderer != null ? titleBarRenderer.getHeight() : 0;
    }

    private void setApplicationModal(boolean applicationModal) {
        this.applicationModal = applicationModal;
    }

    private void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    private void setMaximizeable(boolean maximizeable) {
        this.maximizeable = maximizeable;
    }

    private void setMinimizeable(boolean minimizeable) {
        this.minimizeable = minimizeable;
    }

    private void setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
    }

    private void updateDialogStyle() {
        boolean hide = LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder");
        this.setHideOsBorder(hide);
        int style = this.dialog.getShellStyle();
        if (this.isHideOsBorder()) {
            if ((style & 0x860) == 2144) {
                style ^= 0x860;
            }
            style |= 8;
        } else {
            if ((style & 8) == 8) {
                style ^= 8;
            }
            style |= 0x860;
        }
        if (this.isApplicationModal()) {
            style |= 0x10000;
        } else if ((style & 0x10000) == 65536) {
            style ^= 0x10000;
        }
        this.dialog.setShellStyle(style);
    }

    private static final class DialogBorderPaintListener
    implements PaintListener {
        private DialogBorderPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control dialog = (Control)e.getSource();
                Rectangle dialogBounds = dialog.getBounds();
                Rectangle bounds = new Rectangle(0, 0, dialogBounds.width, dialogBounds.height);
                ILnfRenderer borderRenderer = LnfManager.getLnf().getRenderer("Dialog.borderRenderer");
                borderRenderer.setBounds(bounds);
                borderRenderer.paint(e.gc, null);
            }
        }
    }

    private final class DialogPaintListener
    implements PaintListener {
        private DialogPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control control = (Control)e.getSource();
                Rectangle dialogBounds = control.getBounds();
                DialogTitleBarRenderer renderer = (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
                renderer.setShell(control.getShell());
                Rectangle bounds = new Rectangle(0, 0, dialogBounds.width, renderer.getHeight());
                renderer.setBounds(bounds);
                renderer.setCloseable(RienaDialogDelegate.this.dialog.isCloseable());
                renderer.setMaximizable(RienaDialogDelegate.this.dialog.isMaximizeable());
                renderer.setMinimizable(RienaDialogDelegate.this.dialog.isMinimizeable());
                renderer.paint(e.gc, control);
            }
        }
    }

    private static final class DialogTitleBarMouseListener
    extends AbstractTitleBarMouseListener {
        private DialogTitleBarMouseListener() {
        }

        protected AbstractTitleBarRenderer getTitleBarRenderer() {
            return (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
        }
    }
}

