/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.net.URL;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;
import org.eclipse.riena.ui.swt.utils.IImagePathExtension;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.swt.graphics.Image;

public final class ImageStore {
    private Image missingImage;
    private IImagePathExtension[] iconPaths;
    private static final SingletonProvider<ImageStore> IS = new SingletonProvider(ImageStore.class);
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ImageStore.class);

    private ImageStore() {
    }

    public static ImageStore getInstance() {
        return (ImageStore)IS.getInstance();
    }

    public Image getImage(String imageName, ImageFileExtension fileExtension) {
        String defaultIconName;
        String fullName = this.getFullName(imageName, fileExtension);
        Image image = this.loadImage(fullName);
        if (image == null && !StringUtils.equals((CharSequence)(defaultIconName = this.getDefaultIconMangerImageName(imageName)), (CharSequence)imageName)) {
            fullName = this.getFullName(defaultIconName, fileExtension);
            image = this.loadImage(fullName);
        }
        return image;
    }

    private String getDefaultIconMangerImageName(String imageName) {
        IconState state;
        IIconManager iconManager = IconManagerProvider.getInstance().getIconManager();
        String name = iconManager.getName(imageName);
        IconSize size = iconManager.getSize(imageName);
        if (size == null || size.getClass() != IconSize.class) {
            size = IconSize.NONE;
        }
        if ((state = iconManager.getState(imageName)) == null || state.getClass() != IconState.class) {
            state = IconState.NORMAL;
        }
        IIconManager defaultIconManager = IconManagerProvider.getInstance().getDefaultIconManager();
        String defaultIconName = defaultIconManager.getIconID(name, size, state);
        return defaultIconName;
    }

    public Image getImage(String imageName) {
        return this.getImage(imageName, ImageFileExtension.PNG);
    }

    private String getFullName(String imageName, ImageFileExtension fileExtension) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return null;
        }
        String fullName = imageName;
        if (imageName.indexOf(46) < 0 && fileExtension != null) {
            fullName = String.valueOf(fullName) + "." + fileExtension.getFileNameExtension();
        }
        return fullName;
    }

    private synchronized Image loadImage(String fullName) {
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return null;
        }
        if (Activator.getDefault() == null) {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(fullName);
        if (image == null || image.isDisposed()) {
            ImageDescriptor descriptor = this.getImageDescriptor(fullName);
            if (descriptor == null) {
                return null;
            }
            imageRegistry.remove(fullName);
            imageRegistry.put(fullName, descriptor);
            image = imageRegistry.get(fullName);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(String fullName) {
        IImagePathExtension[] iImagePathExtensionArray = this.iconPaths;
        int n = this.iconPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IImagePathExtension iconPath = iImagePathExtensionArray[n2];
            String fullPath = String.valueOf(iconPath.getPath()) + '/' + fullName;
            URL url = iconPath.getContributingBundle().getEntry(fullPath);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Image resource \"");
        sb.append(fullName);
        sb.append("\" not found in:");
        IImagePathExtension[] iImagePathExtensionArray2 = this.iconPaths;
        int n3 = this.iconPaths.length;
        n = 0;
        while (n < n3) {
            IImagePathExtension iconPath = iImagePathExtensionArray2[n];
            sb.append("\n  ");
            sb.append(iconPath.getContributingBundle().getLocation());
            sb.append(iconPath.getPath());
            ++n;
        }
        LOGGER.log(4, sb.toString());
        return null;
    }

    public synchronized Image getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    @InjectExtension
    public void update(IImagePathExtension[] iconPaths) {
        this.iconPaths = iconPaths;
    }
}

