/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.ObjectCounter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIControlsCounter {
    private static final String STAR = "*";
    private static final String HEADER = " Control Usage Statistics ";
    private static final int NOS = 10;
    private static final SingletonProvider<UIControlsCounter> UICC = new SessionSingletonProvider(UIControlsCounter.class);
    private final ObjectCounter<Class<?>> live = new ObjectCounter();
    private final ObjectCounter<Class<?>> total = new ObjectCounter();
    private final DisposeListener disposeListener = new LiveDisposeListener();
    public static final String CONTROL_STATS_PROPERTY_NAME = "riena.control.stats";
    private static final boolean CONTROL_STATS_REQUESTED = Boolean.getBoolean("riena.control.stats");
    private static final String DELIMITER = "\t";
    private static final String LINE_FORMAT = "% 5d\t% 5d\t%s";

    public static boolean isRequested() {
        return CONTROL_STATS_REQUESTED;
    }

    public static UIControlsCounter getInstance() {
        return (UIControlsCounter)UICC.getInstance();
    }

    public void registerConstruction(Object control) {
        if (UIControlsCounter.isRequested()) {
            this.total.incrementAndGetCount(control.getClass());
            this.live.incrementAndGetCount(control.getClass());
            if (control instanceof Widget) {
                ((Widget)control).addDisposeListener(this.disposeListener);
            }
        }
    }

    public String getControlUsageStatistics() {
        StringBuilder strb = new StringBuilder();
        UIControlsCounter.appendNTimes(STAR, 10, strb);
        strb.append(HEADER);
        UIControlsCounter.appendNTimes(STAR, 10, strb);
        UIControlsCounter.newLine(strb);
        strb.append(" Live\t");
        strb.append("Total\t");
        strb.append("Type");
        UIControlsCounter.newLine(strb);
        for (String line : UIControlsCounter.getSortedLines(this.live, this.total)) {
            strb.append(line);
            UIControlsCounter.newLine(strb);
        }
        UIControlsCounter.appendNTimes(STAR, 20 + HEADER.length(), strb);
        return strb.toString();
    }

    private static List<String> getSortedLines(ObjectCounter<Class<?>> live, ObjectCounter<Class<?>> total) {
        ArrayList<String> result = new ArrayList<String>();
        for (Class clazz : live) {
            result.add(String.format(LINE_FORMAT, live.getCount((Object)clazz), total.getCount((Object)clazz), clazz.getName()));
        }
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = Integer.valueOf(o1.split(UIControlsCounter.DELIMITER)[0].trim());
                Integer i2 = Integer.valueOf(o2.split(UIControlsCounter.DELIMITER)[0].trim());
                return i2.compareTo(i1);
            }
        });
        return result;
    }

    private static void newLine(StringBuilder strb) {
        strb.append("\n");
    }

    private static void appendNTimes(String str, int n, StringBuilder strb) {
        int i = 0;
        while (i < n) {
            strb.append(str);
            ++i;
        }
    }

    private final class LiveDisposeListener
    implements DisposeListener {
        private LiveDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            UIControlsCounter.this.live.decrementAndGetCount(e.widget.getClass());
        }
    }
}

