/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets.upload.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.URLHelper;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.widgets.IUploadConfiguration;
import org.eclipse.rwt.widgets.internal.UploadConfiguration;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadStorage;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadStorageItem;

public class FileUploadServiceHandler
implements IServiceHandler {
    private static final String REQUEST_WIDGET_ID = "widgetId";
    private static final String REQUEST_PROCESS_ID = "processId";
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"utf-8\"?><response>";
    private static final IUploadConfiguration uploadConfiguration = new UploadConfiguration();
    static /* synthetic */ Class class$0;

    public void service() throws IOException, ServletException {
        HttpServletRequest request = RWT.getRequest();
        String widgetId = request.getParameter(REQUEST_WIDGET_ID);
        String uploadProcessId = request.getParameter(REQUEST_PROCESS_ID);
        HttpSession session = request.getSession(false);
        if (session != null && widgetId != null && !"".equals(widgetId) && uploadProcessId != null && !"".equals(uploadProcessId)) {
            FileUploadStorage fileUploadStorage = FileUploadStorage.getInstance();
            FileUploadStorageItem fileUploadStorageItem = fileUploadStorage.getUploadStorageItem(widgetId);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                this.handleFileUpload(request, fileUploadStorageItem, uploadProcessId);
            } else {
                this.handleUpdateProgress(fileUploadStorageItem, uploadProcessId);
            }
        }
    }

    private void handleFileUpload(HttpServletRequest request, final FileUploadStorageItem fileUploadStorageitem, String uploadProcessId) {
        if (fileUploadStorageitem != null && uploadProcessId != null && !"".equals(uploadProcessId)) {
            fileUploadStorageitem.reset();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            this.applyConfiguration(upload);
            ProgressListener listener = new ProgressListener(){

                public void update(long aBytesRead, long aContentLength, int anItem) {
                    fileUploadStorageitem.updateProgress(aBytesRead, aContentLength);
                }
            };
            upload.setProgressListener(listener);
            fileUploadStorageitem.setUploadProcessId(uploadProcessId);
            FileItem fileItem = null;
            try {
                List uploadedItems = upload.parseRequest(request);
                if (uploadedItems.size() > 0 && !(fileItem = (FileItem)uploadedItems.get(0)).isFormField()) {
                    fileUploadStorageitem.setFileInputStream(fileItem.getInputStream());
                    fileUploadStorageitem.setContentType(fileItem.getContentType());
                }
            }
            catch (FileUploadException e) {
                fileUploadStorageitem.setException((Exception)((Object)e));
            }
            catch (Exception e) {
                fileUploadStorageitem.setException(e);
            }
        }
    }

    private void applyConfiguration(ServletFileUpload upload) {
        upload.setFileSizeMax(FileUploadServiceHandler.getConfiguration().getFileSizeMax());
        upload.setSizeMax(FileUploadServiceHandler.getConfiguration().getSizeMax());
    }

    private void handleUpdateProgress(FileUploadStorageItem fileUploadStorageitem, String uploadProcessId) throws IOException {
        HttpServletResponse response = RWT.getResponse();
        PrintWriter out = response.getWriter();
        StringBuffer buffy = new StringBuffer(XML_HEAD);
        long bytesRead = 0L;
        long contentLength = 0L;
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        if (fileUploadStorageitem != null) {
            if (uploadProcessId != null && uploadProcessId.equals(fileUploadStorageitem.getUploadProcessId())) {
                bytesRead = fileUploadStorageitem.getBytesRead();
                contentLength = fileUploadStorageitem.getContentLength();
                buffy.append("<bytes_read>");
                buffy.append(bytesRead);
                buffy.append("</bytes_read><content_length>");
                buffy.append(contentLength);
                buffy.append("</content_length>");
                if (contentLength != 0L) {
                    if (bytesRead == contentLength) {
                        buffy.append("<finished />");
                    } else {
                        buffy.append("<percent_complete>");
                        buffy.append(100L * bytesRead / contentLength);
                        buffy.append("</percent_complete>");
                    }
                } else {
                    buffy.append("<finished />");
                }
            }
        } else {
            buffy.append("<finished />");
        }
        buffy.append("</response>");
        out.println(buffy.toString());
        out.flush();
        out.close();
    }

    public static void register() {
        FileUploadServiceHandler instance = new FileUploadServiceHandler();
        String serviceHandlerId = FileUploadServiceHandler.getServiceHandlerId();
        RWT.getServiceManager().registerServiceHandler(serviceHandlerId, (IServiceHandler)instance);
    }

    private static String getServiceHandlerId() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.widgets.upload.servlet.FileUploadServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceHandlerId = clazz.getName();
        return serviceHandlerId;
    }

    public static String getUrl(String widgetId) {
        StringBuffer url = new StringBuffer();
        url.append(URLHelper.getURLString());
        URLHelper.appendFirstParam((StringBuffer)url, (String)"custom_service_handler", (String)FileUploadServiceHandler.getServiceHandlerId());
        URLHelper.appendParam((StringBuffer)url, (String)REQUEST_WIDGET_ID, (String)widgetId);
        int firstSlash = url.indexOf("/", url.indexOf("//") + 2);
        url.delete(0, firstSlash);
        return RWT.getResponse().encodeURL(url.toString());
    }

    public static IUploadConfiguration getConfiguration() {
        return uploadConfiguration;
    }
}

