/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets.upload.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rwt.widgets.upload.servlet.FileUploadListener;

public class FileUploadServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 2740693677625051632L;
    private static final String CONTEXT_TEMP_DIR = "javax.servlet.context.tempdir";
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"utf-8\"?><response>";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession();
        FileUploadListener listener = null;
        StringBuffer buffy = new StringBuffer(XML_HEAD);
        long bytesRead = 0L;
        long contentLength = 0L;
        if (session != null) {
            listener = (FileUploadListener)session.getAttribute("LISTENER");
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            if (listener != null) {
                bytesRead = listener.getBytesRead();
                contentLength = listener.getContentLength();
                buffy.append("<bytes_read>");
                buffy.append(bytesRead);
                buffy.append("</bytes_read><content_length>");
                buffy.append(contentLength);
                buffy.append("</content_length>");
                if (contentLength != 0L) {
                    if (bytesRead == contentLength) {
                        buffy.append("<finished />");
                        session.setAttribute("LISTENER", null);
                    } else {
                        buffy.append("<percent_complete>");
                        buffy.append(100L * bytesRead / contentLength);
                        buffy.append("</percent_complete>");
                    }
                }
            }
            buffy.append("</response>");
            out.println(buffy.toString());
            out.flush();
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        FileUploadListener listener = new FileUploadListener();
        HttpSession session = request.getSession();
        session.setAttribute("LISTENER", (Object)listener);
        upload.setProgressListener((ProgressListener)listener);
        FileItem fileItem = null;
        File filePath = FileUploadServlet.getUploadTempDir(session);
        try {
            List uploadedItems = upload.parseRequest(request);
            Iterator iterator = uploadedItems.iterator();
            while (iterator.hasNext()) {
                fileItem = (FileItem)iterator.next();
                if (fileItem.isFormField() || fileItem.getSize() <= 0L) continue;
                String myFullFileName = fileItem.getName();
                String slashType = myFullFileName.lastIndexOf("\\") > 0 ? "\\" : "/";
                int startIndex = myFullFileName.lastIndexOf(slashType);
                String myFileName = myFullFileName.substring(startIndex + 1, myFullFileName.length());
                File file = new File(filePath, myFileName);
                fileItem.write(file);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getUploadTempDir(HttpSession session) {
        ServletContext context = session.getServletContext();
        StringBuffer path = new StringBuffer();
        File tempDir = (File)context.getAttribute(CONTEXT_TEMP_DIR);
        path.append(tempDir.getAbsolutePath());
        path.append(File.separatorChar);
        path.append(session.getId());
        File result = new File(path.toString());
        if (!result.exists()) {
            result.mkdir();
        }
        return result;
    }
}

