/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.util.Comparator;
import java.util.Locale;
import org.eclipse.scout.commons.StringUtility;

public class ArrayComparator
implements Comparator<Object[]> {
    private Locale m_locale;
    private int[] m_sortColumns;

    public ArrayComparator(Locale locale, int ... sortCols) {
        this.m_locale = locale;
        this.m_sortColumns = sortCols;
    }

    @Override
    public int compare(Object[] a, Object[] b) {
        if (this.m_sortColumns == null || this.m_sortColumns.length == 0) {
            return 0;
        }
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int i = 0;
        while (i < this.m_sortColumns.length && this.m_sortColumns[i] < a.length && this.m_sortColumns[i] < b.length) {
            Object o1 = a[this.m_sortColumns[i]];
            Object o2 = b[this.m_sortColumns[i]];
            int c = 0;
            c = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null && o2 == null ? 1 : (o1 instanceof String && o2 instanceof String ? StringUtility.compareIgnoreCase(this.m_locale, (String)o1, (String)o2) : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : StringUtility.compareIgnoreCase(this.m_locale, o1.toString(), o2.toString())))));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (a.length > b.length) {
            return 1;
        }
        return 0;
    }
}

