/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.nls;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.scout.commons.nls.NlsResourceBundle;

public class NlsResourceBundleCache {
    private String m_resourceBundleName;
    private Class m_wrapperClass;
    private HashMap<Locale, ResourceBundle> m_resourceBundles;
    private Object m_resourceBundlesLock;

    public NlsResourceBundleCache(String resourceBundleName, Class wrapperClass) {
        this.m_resourceBundleName = resourceBundleName;
        this.m_wrapperClass = wrapperClass;
        this.m_resourceBundlesLock = new Object();
        this.m_resourceBundles = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        Object object = this.m_resourceBundlesLock;
        synchronized (object) {
            ResourceBundle r = this.m_resourceBundles.get(locale);
            if (r == null && (r = NlsResourceBundle.getBundle(this.m_resourceBundleName, locale, this.m_wrapperClass.getClassLoader())) != null) {
                this.m_resourceBundles.put(locale, r);
            }
            return r;
        }
    }

    public Class getWrapperClass() {
        return this.m_wrapperClass;
    }
}

