/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.translationfile.directorychooser.TranslationFolderChooserDialog;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FolderChooserField
extends Composite {
    private Text m_text;
    private Label m_label;
    private Button m_button;
    private String[] m_extendsionFilter;
    private IProject m_project;
    private List<IInputChangedListener<IFolder>> m_inputChangedListeners = new LinkedList<IInputChangedListener<IFolder>>();
    private IFolder m_path;

    public FolderChooserField(Composite parent, String labelText, IProject project) {
        super(parent, 0);
        this.m_project = project;
        this.createComponent(this);
        this.setLabelText(labelText);
    }

    protected void createComponent(Composite parent) {
        this.m_label = new Label(parent, 0);
        this.m_text = new Text(parent, 2048);
        this.m_button = new Button(parent, 8);
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderChooserField.this.showFileChooserDialog();
            }
        });
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(40, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.right = new FormAttachment((Control)this.m_button, -5);
        data.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_button.setLayoutData((Object)data);
    }

    public void setButtonImage(Image img) {
        this.m_button.setImage(img);
    }

    public Image getButtonImage() {
        return this.m_button.getImage();
    }

    public void setButtonText(String string) {
        this.m_button.setText(string);
    }

    public String getButtonText() {
        return this.m_button.getText();
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setPath(IFolder path) {
        this.m_path = path;
        if (this.m_path == null) {
            this.m_text.setText("");
        } else {
            this.m_text.setText(String.valueOf(this.m_path.getProject().getName()) + "/" + this.m_path.getProjectRelativePath());
        }
    }

    public IFolder getPath() {
        return this.m_path;
    }

    public void setPathFire(IFolder path) {
        this.setPath(path);
        for (IInputChangedListener<IFolder> listener : this.m_inputChangedListeners) {
            listener.inputChanged(path);
        }
    }

    public String[] getExtendsionFilter() {
        return this.m_extendsionFilter;
    }

    public void setExtendsionFilter(String[] extendsionFilter) {
        this.m_extendsionFilter = extendsionFilter;
    }

    private void showFileChooserDialog() {
        TranslationFolderChooserDialog dialog = new TranslationFolderChooserDialog(this.getShell(), "Translation Folder Chooser", this.m_project);
        IFolder path = dialog.openDialog();
        if (path != null) {
            this.setPathFire(path);
        }
    }

    public void addInputChangedListneer(IInputChangedListener<IFolder> listener) {
        this.m_inputChangedListeners.add(listener);
    }

    public void removeInputChangedListneer(IInputChangedListener<IFolder> listener) {
        this.m_inputChangedListeners.remove(listener);
    }
}

