/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ResourceDialog
extends TitleAreaDialog {
    private IContainer m_root;
    private String m_dialogTitle;
    private TreeViewer m_viewer;
    private List<ViewerFilter> m_filters = new LinkedList<ViewerFilter>();
    private IResource[] m_result;
    private IResource[] m_initialSelection;
    private IResource[] m_initialExpansion;

    public ResourceDialog(Shell parentShell, String title, IContainer root) {
        super(parentShell);
        this.setShellStyle(0x10870 | ResourceDialog.getDefaultOrientation());
        this.m_dialogTitle = title;
        this.m_root = root;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        Tree m_tree = new Tree(rootArea, 4);
        this.m_viewer = new TreeViewer(m_tree);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Button ok = ResourceDialog.this.getButton(0);
                    if (ok != null && !ok.isDisposed()) {
                        ok.setEnabled(true);
                    }
                    ResourceDialog.this.m_result = new IResource[selection.size()];
                    int i = 0;
                    for (Object o : selection) {
                        if (o instanceof IResource) {
                            ((ResourceDialog)ResourceDialog.this).m_result[i] = (IResource)o;
                        }
                        ++i;
                    }
                }
            }
        });
        P_TreeContentProvider model = new P_TreeContentProvider();
        this.m_viewer.setLabelProvider((IBaseLabelProvider)model);
        this.m_viewer.setContentProvider((IContentProvider)model);
        this.m_viewer.setInput((Object)model);
        for (ViewerFilter filter : this.m_filters) {
            this.m_viewer.addFilter(filter);
        }
        if (this.m_initialSelection != null) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection((Object[])this.m_initialSelection));
        }
        if (this.m_initialExpansion != null) {
            this.m_viewer.setExpandedElements((Object[])this.m_initialExpansion);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        rootArea.setLayoutData((Object)data);
        rootArea.setLayout((Layout)new FormLayout());
        FormData fdata = new FormData(-1, 200);
        fdata.top = new FormAttachment(0, 5);
        fdata.left = new FormAttachment(0, 5);
        fdata.right = new FormAttachment(100, -5);
        fdata.bottom = new FormAttachment(100, -5);
        m_tree.setLayoutData((Object)fdata);
        return rootArea;
    }

    public void setInitialSelection(IResource[] resource) {
        this.m_initialSelection = resource;
    }

    public void setInitialExpansion(IResource[] resources) {
        this.m_initialExpansion = resources;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.m_filters.add(filter);
    }

    public void removeViewerFilter(ViewerFilter filter) {
        this.m_filters.remove(filter);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(true);
    }

    public IResource getFirstResult() {
        if (this.m_result != null && this.m_result.length > 0) {
            return this.m_result[0];
        }
        return null;
    }

    private class P_TreeContentProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private P_TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{ResourceDialog.this.m_root};
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof IContainer) {
                    return ((IContainer)parentElement).members();
                }
                return new Object[0];
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            try {
                return element instanceof IContainer && ((IContainer)element).members().length > 0;
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
                return false;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

