/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.language;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldModel;
import org.eclipse.swt.graphics.Image;

public class LanguageSmartFieldModel
implements ISmartFieldModel {
    Locale[] m_locales;

    public LanguageSmartFieldModel() {
        ArrayList<Locale> locs = new ArrayList<Locale>();
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String isoLang = stringArray[n2];
            locs.add(new Locale(isoLang));
            ++n2;
        }
        this.m_locales = locs.toArray(new Locale[locs.size()]);
    }

    @Override
    public Image getImage(Object item) {
        return NlsCore.getImage("comment");
    }

    @Override
    public List<Object> getProposals(String pattern) {
        LinkedList<Object> props = new LinkedList<Object>();
        Locale[] localeArray = this.m_locales;
        int n = this.m_locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            if (l.getDisplayLanguage().toLowerCase().startsWith(pattern.toLowerCase())) {
                props.add(l);
            }
            ++n2;
        }
        return props;
    }

    @Override
    public String getText(Object item) {
        if (item == null) {
            return "";
        }
        Locale l = (Locale)item;
        return String.valueOf(l.getDisplayLanguage()) + " (" + l.getLanguage() + ")";
    }

    public void itemSelected(Object item) {
    }
}

