/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui.action;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.language.TranslationFileNewDialog;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.language.TranslationFileNewModel;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.AbstractWorkspaceAction;
import org.eclipse.swt.widgets.Shell;

public class TranslationFileNewAction
extends AbstractWorkspaceAction {
    private final Shell m_parentShell;
    private final INlsProject m_nlsProject;
    private TranslationFileNewModel m_model;

    public TranslationFileNewAction(Shell parentShell, boolean interactWithUi, INlsProject project) {
        super("New Language...", interactWithUi);
        this.m_parentShell = parentShell;
        this.m_nlsProject = project;
    }

    public ImageDescriptor getImageDescriptor() {
        return NlsCore.getImageDescriptor("fileadd_pending");
    }

    @Override
    protected boolean interactWithUi() {
        this.m_model = new TranslationFileNewModel(this.m_nlsProject);
        TranslationFileNewDialog dialog = new TranslationFileNewDialog(this.m_parentShell, this.m_model);
        return dialog.open() == 0;
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        try {
            this.m_nlsProject.createTranslationFile(this.m_model.getLanguage(), this.m_model.getFolder(), monitor);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
    }
}

