/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;

public class ActivityMapEvent
extends EventObject {
    public static final int TYPE_ACTIVITIES_INSERTED = 100;
    public static final int TYPE_ACTIVITIES_UPDATED = 101;
    public static final int TYPE_ACTIVITIES_DELETED = 102;
    public static final int TYPE_CELL_ACTION = 104;
    public static final int TYPE_ALL_ACTIVITIES_DELETED = 105;
    public static final int TYPE_EDIT_ACTIVITY_POPUP = 700;
    public static final int TYPE_NEW_ACTIVITY_POPUP = 701;
    private int m_type;
    private ActivityCell[] m_activities = new ActivityCell[0];
    private List<IMenu> m_popupMenus;
    private long m_resourceId;
    private MinorTimeColumn m_column;

    public ActivityMapEvent(IActivityMap source, int type) {
        super(source);
        this.m_type = type;
    }

    public ActivityMapEvent(IActivityMap source, int type, ActivityCell activity) {
        super(source);
        this.m_type = type;
        if (activity != null) {
            this.m_activities = new ActivityCell[]{activity};
        }
    }

    public ActivityMapEvent(IActivityMap source, int type, ActivityCell[] activities) {
        super(source);
        this.m_type = type;
        if (activities != null && activities.length > 0) {
            this.m_activities = activities;
        }
    }

    public ActivityMapEvent(IActivityMap source, int type, long resourceId, MinorTimeColumn column, ActivityCell activity) {
        super(source);
        this.m_type = type;
        if (activity != null) {
            this.m_activities = new ActivityCell[]{activity};
        }
        this.m_resourceId = resourceId;
        this.m_column = column;
    }

    public IActivityMap getActivityMap() {
        return (IActivityMap)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public long getResourceId() {
        return this.m_resourceId;
    }

    public MinorTimeColumn getColumn() {
        return this.m_column;
    }

    public ActivityCell[] getActivities() {
        return this.m_activities;
    }

    protected void setActivities(ActivityCell[] activities) {
        this.m_activities = activities;
    }

    public int getActivityCount() {
        return this.m_activities != null ? this.m_activities.length : 0;
    }

    public ActivityCell getFirstActivity() {
        return this.m_activities.length > 0 ? this.m_activities[0] : null;
    }

    public ActivityCell getLastActivity() {
        return this.m_activities.length > 0 ? this.m_activities[this.m_activities.length - 1] : null;
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(IMenu[] menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(Arrays.asList(menus));
        }
    }

    public IMenu[] getPopupMenus() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.toArray(new IMenu[0]);
        }
        return new IMenu[0];
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            buf.append("#" + this.m_type);
        }
        buf.append(" ");
        if (this.m_activities != null && this.m_activities.length > 0 && this.getActivityMap() != null) {
            if (this.m_activities.length == 1) {
                buf.append("row " + (Object)((Object)this.m_activities[0]));
            } else {
                buf.append("activities {");
                int i = 0;
                while (i < this.m_activities.length) {
                    if (i >= 0) {
                        buf.append(",");
                    }
                    buf.append("" + (Object)((Object)this.m_activities[i]));
                    ++i;
                }
                buf.append("}");
            }
        } else {
            buf.append("{}");
        }
        buf.append("]");
        return buf.toString();
    }
}

