/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;

public class MinorTimeColumn {
    private Date m_beginTime;
    private Date m_endTime;
    private String m_smallText = "";
    private String m_mediumText = "";
    private String m_largeText = "";
    private String m_tooltipText;
    private MajorTimeColumn m_majorTimeColumn;

    public MinorTimeColumn(MajorTimeColumn parent, Date beginTime, Date endTime) {
        this.m_beginTime = beginTime;
        this.m_endTime = endTime;
        this.m_majorTimeColumn = parent;
        this.m_majorTimeColumn.addMinorColumnNotify(this);
    }

    public MajorTimeColumn getMajorTimeColumn() {
        return this.m_majorTimeColumn;
    }

    public Date getBeginTime() {
        return this.m_beginTime;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Calendar getBeginCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_beginTime);
        return cal;
    }

    public String getSmallText() {
        return this.m_smallText;
    }

    public void setSmallText(String s) {
        this.m_smallText = s;
    }

    public String getMediumText() {
        return this.m_mediumText;
    }

    public void setMediumText(String s) {
        this.m_mediumText = s;
    }

    public String getLargeText() {
        return this.m_largeText;
    }

    public void setLargeText(String s) {
        this.m_largeText = s;
    }

    public String getTooltipText() {
        return this.m_tooltipText;
    }

    public void setTooltipText(String s) {
        this.m_tooltipText = s;
    }

    public String getText(int size) {
        switch (size) {
            case 0: {
                return this.getSmallText();
            }
            case 1: {
                return this.getMediumText();
            }
            case 2: {
                return this.getLargeText();
            }
        }
        return "<UNKNOWN SIZE " + size + ">";
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int size) {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        b.append(this.getText(size));
        b.append(" ]");
        return b.toString();
    }
}

