/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ComparableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.StringColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractObjectColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractLinkButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class ColumnFilterForm
extends AbstractForm {
    private ITableColumnFilter<?> m_columnFilter;

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"ColumnFilter", (String[])new String[0]);
    }

    @Override
    protected boolean getConfiguredModal() {
        return true;
    }

    public ITableColumnFilter<?> getColumnFilter() {
        return this.m_columnFilter;
    }

    public void setColumnFilter(ITableColumnFilter<?> columnFilter) {
        this.m_columnFilter = columnFilter;
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.ValuesBox.ValuesTableField getValuesTableField() {
        return this.getFieldByClass(MainBox.ValuesBox.ValuesTableField.class);
    }

    public MainBox.StringDetailBox getStringDetailBox() {
        return this.getFieldByClass(MainBox.StringDetailBox.class);
    }

    public MainBox.StringDetailBox.PatternField getPatternField() {
        return this.getFieldByClass(MainBox.StringDetailBox.PatternField.class);
    }

    public MainBox.DateDetailBox getDateDetailBox() {
        return this.getFieldByClass(MainBox.DateDetailBox.class);
    }

    public MainBox.DateDetailBox.DateSequenceBox.DateFromField getDateFromField() {
        return this.getFieldByClass(MainBox.DateDetailBox.DateSequenceBox.DateFromField.class);
    }

    public MainBox.DateDetailBox.DateSequenceBox.DateToField getDateToField() {
        return this.getFieldByClass(MainBox.DateDetailBox.DateSequenceBox.DateToField.class);
    }

    public MainBox.NumberDetailBox getNumberDetailBox() {
        return this.getFieldByClass(MainBox.NumberDetailBox.class);
    }

    public MainBox.NumberDetailBox.NumberSequenceBox.NumberFromField getNumberFromField() {
        return this.getFieldByClass(MainBox.NumberDetailBox.NumberSequenceBox.NumberFromField.class);
    }

    public MainBox.NumberDetailBox.NumberSequenceBox.NumberToField getNumberToField() {
        return this.getFieldByClass(MainBox.NumberDetailBox.NumberSequenceBox.NumberToField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CloseButton getCloseButton() {
        return this.getFieldByClass(MainBox.CloseButton.class);
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    private void setupDateField(IDateField f, IColumn<?> obj) {
        if (obj instanceof IDateColumn) {
            IDateColumn col = (IDateColumn)obj;
            f.setHasTime(col.isHasTime());
            f.setFormat(col.getFormat());
        }
    }

    private void setupNumberField(IDoubleField f, IColumn<?> obj) {
        if (obj instanceof IDoubleColumn) {
            IDoubleColumn col = (IDoubleColumn)obj;
            f.setFormat(col.getFormat());
            f.setGroupingUsed(col.isGroupingUsed());
            f.setMaxFractionDigits(col.getMaxFractionDigits());
            f.setMinFractionDigits(col.getMinFractionDigits());
            f.setMultiplier(col.getMultiplier());
            f.setPercent(col.isPercent());
        } else if (obj instanceof IIntegerColumn) {
            IIntegerColumn col = (IIntegerColumn)obj;
            f.setFormat(col.getFormat());
            f.setGroupingUsed(col.isGroupingUsed());
            f.setMaxFractionDigits(0);
            f.setMinFractionDigits(0);
        } else if (obj instanceof ILongColumn) {
            ILongColumn col = (ILongColumn)obj;
            f.setFormat(col.getFormat());
            f.setGroupingUsed(col.isGroupingUsed());
            f.setMaxFractionDigits(0);
            f.setMinFractionDigits(0);
        }
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridW() {
            return 1;
        }

        @Order(value=110.0)
        public class CloseButton
        extends AbstractCloseButton {
        }

        @Order(value=40.0)
        public class DateDetailBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnFilterDateSection", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Order(value=10.0)
            public class DateSequenceBox
            extends AbstractSequenceBox {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Order(value=10.0)
                public class DateFromField
                extends AbstractDateField {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"from", (String[])new String[0]);
                    }
                }

                @Order(value=20.0)
                public class DateToField
                extends AbstractDateField {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"to", (String[])new String[0]);
                    }
                }
            }
        }

        @Order(value=40.0)
        public class NumberDetailBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnFilterNumberSection", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Order(value=10.0)
            public class NumberSequenceBox
            extends AbstractSequenceBox {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Order(value=10.0)
                public class NumberFromField
                extends AbstractDoubleField {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"from", (String[])new String[0]);
                    }
                }

                @Order(value=20.0)
                public class NumberToField
                extends AbstractDoubleField {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"to", (String[])new String[0]);
                    }
                }
            }
        }

        @Order(value=100.0)
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=120.0)
        public class RemoveButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnFilterRemoveButton", (String[])new String[0]);
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                Object[] objectArray = ((ValuesBox.ValuesTableField.Table)ColumnFilterForm.this.getValuesTableField().getTable()).getRows();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITableRow r = objectArray[n2];
                    r.setChecked(false);
                    ++n2;
                }
                objectArray = ColumnFilterForm.this.getAllFields();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (f instanceof IValueField) {
                        ((IValueField)f).setValue(null);
                    }
                    ++n2;
                }
                ColumnFilterForm.this.doOk();
            }
        }

        @Order(value=10.0)
        public class SortBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnSorting", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Order(value=20.0)
            public class SortDownButton
            extends AbstractLinkButton {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SortDescending", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredProcessButton() {
                    return false;
                }

                @Override
                protected void execClickAction() throws ProcessingException {
                    IColumn<?> col = ColumnFilterForm.this.getColumnFilter().getColumn();
                    col.getTable().getColumnSet().addSortColumn(col, false);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(col.getTable());
                    col.getTable().sort();
                    ColumnFilterForm.this.doOk();
                }
            }

            @Order(value=30.0)
            public class SortNoneButton
            extends AbstractLinkButton {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ClearColumnSorting", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredProcessButton() {
                    return false;
                }

                @Override
                protected void execClickAction() throws ProcessingException {
                    IColumn<?> col = ColumnFilterForm.this.getColumnFilter().getColumn();
                    col.getTable().getColumnSet().removeSortColumn(col);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(col.getTable());
                    col.getTable().sort();
                    ColumnFilterForm.this.doOk();
                }
            }

            @Order(value=10.0)
            public class SortUpButton
            extends AbstractLinkButton {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ColumnSortAscending", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredProcessButton() {
                    return false;
                }

                @Override
                protected void execClickAction() throws ProcessingException {
                    IColumn<?> col = ColumnFilterForm.this.getColumnFilter().getColumn();
                    col.getTable().getColumnSet().addSortColumn(col, true);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(col.getTable());
                    col.getTable().sort();
                    ColumnFilterForm.this.doOk();
                }
            }
        }

        @Order(value=30.0)
        public class StringDetailBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnFilterStringSection", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Order(value=10.0)
            public class PatternField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"StringPattern", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                public boolean isSpellCheckEnabled() {
                    return false;
                }
            }
        }

        @Order(value=20.0)
        public class ValuesBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"ColumnFilterValuesSection", (String[])new String[0]);
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Order(value=10.0)
            public class ButtonsSequenceBox
            extends AbstractSequenceBox {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredAutoCheckFromTo() {
                    return false;
                }

                @Order(value=10.0)
                public class CheckAllButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"CheckAll", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ITableRow[] iTableRowArray = ((ValuesTableField.Table)ColumnFilterForm.this.getValuesTableField().getTable()).getRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            row.setChecked(true);
                            ++n2;
                        }
                    }
                }

                @Order(value=20.0)
                public class UncheckAllButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"UncheckAll", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ITableRow[] iTableRowArray = ((ValuesTableField.Table)ColumnFilterForm.this.getValuesTableField().getTable()).getRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            row.setChecked(false);
                            ++n2;
                        }
                    }
                }
            }

            @Order(value=30.0)
            public class ValuesTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 8;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected void execReloadTableData() throws ProcessingException {
                    List<LookupRow> hist = ColumnFilterForm.this.getColumnFilter().createHistogram();
                    ArrayList<TableRow> rowList = new ArrayList<TableRow>(hist.size() + 1);
                    for (LookupRow histRow : hist) {
                        TableRow tableRow = new TableRow(((Table)this.getTable()).getColumnSet(), new Object[]{histRow.getKey(), histRow.getText()});
                        tableRow.setIconId(histRow.getIconId());
                        tableRow.setForegroundColor(histRow.getForegroundColor());
                        tableRow.setBackgroundColor(histRow.getBackgroundColor());
                        tableRow.setFont(histRow.getFont());
                        rowList.add(tableRow);
                    }
                    ((Table)this.getTable()).discardAllRows();
                    ((Table)this.getTable()).addRows(rowList.toArray(new ITableRow[rowList.size()]));
                    Set<?> selectedKeys = ColumnFilterForm.this.getColumnFilter().getSelectedValues();
                    if (selectedKeys != null) {
                        Table.KeyColumn keyCol = ((Table)this.getTable()).getKeyColumn();
                        ITableRow[] iTableRowArray = ((Table)this.getTable()).getRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            if (selectedKeys.contains(keyCol.getValue(row))) {
                                row.setChecked(true);
                            }
                            ++n2;
                        }
                    }
                }

                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredCheckable() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredHeaderVisible() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    public KeyColumn getKeyColumn() {
                        return this.getColumnSet().getColumnByClass(KeyColumn.class);
                    }

                    public TextColumn getTextColumn() {
                        return this.getColumnSet().getColumnByClass(TextColumn.class);
                    }

                    @Order(value=10.0)
                    public class KeyColumn
                    extends AbstractObjectColumn {
                        @Override
                        protected boolean getConfiguredDisplayable() {
                            return false;
                        }

                        @Override
                        protected boolean getConfiguredPrimaryKey() {
                            return true;
                        }
                    }

                    @Order(value=20.0)
                    public class TextColumn
                    extends AbstractStringColumn {
                        @Override
                        protected String getConfiguredHeaderText() {
                            return ScoutTexts.get((String)"ColumnValues", (String[])new String[0]);
                        }

                        @Override
                        protected int getConfiguredHorizontalAlignment() {
                            return -1;
                        }

                        @Override
                        protected int getConfiguredWidth() {
                            return 200;
                        }
                    }
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            ColumnFilterForm.this.setTitle(ColumnFilterForm.this.getColumnFilter().getColumn().getHeaderCell().getText());
            ColumnFilterForm.this.getValuesTableField().reloadTableData();
            if (ColumnFilterForm.this.getColumnFilter() instanceof StringColumnFilter) {
                StringColumnFilter filter = (StringColumnFilter)ColumnFilterForm.this.getColumnFilter();
                ColumnFilterForm.this.getStringDetailBox().setVisible(true);
                ColumnFilterForm.this.getPatternField().setValue(filter.getPattern());
            } else if (ColumnFilterForm.this.getColumnFilter() instanceof ComparableColumnFilter) {
                ComparableColumnFilter filter = (ComparableColumnFilter)ColumnFilterForm.this.getColumnFilter();
                Class dataType = filter.getColumn().getDataType();
                if (Date.class.isAssignableFrom(dataType)) {
                    ColumnFilterForm.this.getDateDetailBox().setVisible(true);
                    ColumnFilterForm.this.setupDateField(ColumnFilterForm.this.getDateFromField(), ColumnFilterForm.this.getColumnFilter().getColumn());
                    ColumnFilterForm.this.setupDateField(ColumnFilterForm.this.getDateToField(), ColumnFilterForm.this.getColumnFilter().getColumn());
                    ColumnFilterForm.this.getDateFromField().setValue((Date)filter.getMinimumValue());
                    ColumnFilterForm.this.getDateToField().setValue((Date)filter.getMaximumValue());
                } else if (Number.class.isAssignableFrom(dataType)) {
                    ColumnFilterForm.this.getNumberDetailBox().setVisible(true);
                    ColumnFilterForm.this.setupNumberField(ColumnFilterForm.this.getNumberFromField(), ColumnFilterForm.this.getColumnFilter().getColumn());
                    ColumnFilterForm.this.setupNumberField(ColumnFilterForm.this.getNumberToField(), ColumnFilterForm.this.getColumnFilter().getColumn());
                    ColumnFilterForm.this.getNumberFromField().setValue((Double)TypeCastUtility.castValue(filter.getMinimumValue(), Double.class));
                    ColumnFilterForm.this.getNumberToField().setValue((Double)TypeCastUtility.castValue(filter.getMaximumValue(), Double.class));
                }
            }
        }

        @Override
        protected void execPostLoad() throws ProcessingException {
            ColumnFilterForm.this.touch();
        }

        @Override
        protected void execStore() throws ProcessingException {
            T[] checkedKeys = ((MainBox.ValuesBox.ValuesTableField.Table)ColumnFilterForm.this.getValuesTableField().getTable()).getKeyColumn().getValues(((MainBox.ValuesBox.ValuesTableField.Table)ColumnFilterForm.this.getValuesTableField().getTable()).getCheckedRows());
            if (checkedKeys.length > 0) {
                ColumnFilterForm.this.getColumnFilter().setSelectedValues(new HashSet(Arrays.asList(checkedKeys)));
            } else {
                ColumnFilterForm.this.getColumnFilter().setSelectedValues(null);
            }
            if (ColumnFilterForm.this.getColumnFilter() instanceof StringColumnFilter) {
                StringColumnFilter filter = (StringColumnFilter)ColumnFilterForm.this.getColumnFilter();
                filter.setPattern((String)ColumnFilterForm.this.getPatternField().getValue());
            } else if (ColumnFilterForm.this.getColumnFilter() instanceof ComparableColumnFilter) {
                ComparableColumnFilter filter = (ComparableColumnFilter)ColumnFilterForm.this.getColumnFilter();
                Class dataType = filter.getColumn().getDataType();
                if (Date.class.isAssignableFrom(dataType)) {
                    filter.setMinimumValue((Comparable)ColumnFilterForm.this.getDateFromField().getValue());
                    filter.setMaximumValue((Comparable)ColumnFilterForm.this.getDateToField().getValue());
                } else if (Number.class.isAssignableFrom(dataType)) {
                    filter.setMinimumValue((Comparable)TypeCastUtility.castValue(ColumnFilterForm.this.getNumberFromField().getValue(), dataType));
                    filter.setMaximumValue((Comparable)TypeCastUtility.castValue(ColumnFilterForm.this.getNumberToField().getValue(), dataType));
                }
            }
        }
    }
}

