/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.internal;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class InternalTableRow
implements ITableRow,
ICellObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalTableRow.class);
    private ITable m_table;
    private int m_rowIndex;
    private boolean m_enabled;
    private boolean m_checked;
    private String m_iconId;
    private int m_status = 0;
    private Cell[] m_cells;
    private int m_rowChanging = 0;
    private boolean m_rowPropertiesChanged;
    private boolean m_filterAccepted;

    private InternalTableRow() {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTableRow(this);
        }
    }

    public InternalTableRow(ITable table) {
        this();
        this.m_table = table;
        this.m_enabled = true;
        this.m_status = 0;
        this.m_filterAccepted = true;
        this.m_cells = new Cell[table.getColumnCount()];
        int i = 0;
        while (i < this.m_cells.length) {
            this.m_cells[i] = new Cell(this);
            ++i;
        }
    }

    public InternalTableRow(ITable table, ITableRow row) throws ProcessingException {
        this();
        this.m_rowIndex = row.getRowIndex();
        this.m_enabled = row.isEnabled();
        this.m_checked = row.isChecked();
        this.m_status = row.getStatus();
        this.m_cells = new Cell[table.getColumnCount()];
        int i = 0;
        while (i < this.m_cells.length) {
            this.m_cells[i] = new Cell(this, row.getCell(i));
            ++i;
        }
        IColumn<?>[] cols = table.getColumns();
        int i2 = 0;
        while (i2 < this.m_cells.length && i2 < cols.length) {
            Object value = this.m_cells[i2].getValue();
            value = cols[i2].parseValue(this, value);
            this.m_cells[i2].setValue(value);
            ++i2;
        }
        this.m_status = row.getStatus();
        this.m_table = table;
    }

    @Override
    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public void setRowIndex(int index) {
        this.m_rowIndex = index;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        try {
            this.setRowChanging(true);
            if (this.m_status != status) {
                this.m_status = status;
                this.m_rowPropertiesChanged = true;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public void setStatusInserted() {
        this.setStatus(1);
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public void setStatusUpdated() {
        this.setStatus(2);
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public void setStatusDeleted() {
        this.setStatus(3);
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public void setStatusNonchanged() {
        this.setStatus(0);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        try {
            this.setRowChanging(true);
            this.m_enabled = b;
            int i = 0;
            while (i < this.m_cells.length) {
                this.m_cells[i].setEnabled(this.m_enabled);
                ++i;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getTable().isSelectedRow(this);
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public void setChecked(boolean b) {
        block10: {
            if (this.m_checked != b) {
                try {
                    this.setRowChanging(true);
                    this.m_checked = b;
                    this.m_rowPropertiesChanged = true;
                    ITable table = this.getTable();
                    if (table == null) break block10;
                    if (table.getCheckableColumn() != null) {
                        try {
                            table.getCheckableColumn().setValue(this, Boolean.valueOf(b));
                        }
                        catch (ProcessingException e) {
                            LOG.warn("Value could not be set on CheckableColumn", (Throwable)e);
                        }
                    }
                    if (b && !table.isMultiCheck()) {
                        ITableRow[] iTableRowArray = table.getCheckedRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow cr = iTableRowArray[n2];
                            if (cr != this) {
                                cr.setChecked(false);
                            }
                            ++n2;
                        }
                    }
                }
                finally {
                    this.setRowChanging(false);
                }
            }
        }
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    public void setFilterAcceptedInternal(boolean b) {
        this.m_filterAccepted = b;
    }

    @Override
    public int getCellCount() {
        return this.m_cells.length;
    }

    @Override
    public ICell getCell(IColumn column) {
        return this.getCell(column.getColumnIndex());
    }

    @Override
    public ICell getCell(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.m_cells.length) {
            return new Cell();
        }
        return this.m_cells[columnIndex];
    }

    @Override
    public void setCell(IColumn column, ICell cell) throws ProcessingException {
        this.setCell(column.getColumnIndex(), cell);
    }

    @Override
    public void setCell(int columnIndex, ICell cell) throws ProcessingException {
        if (cell != null) {
            try {
                this.setRowChanging(true);
                this.m_cells[columnIndex] = new Cell(this, cell);
            }
            finally {
                this.setRowChanging(false);
            }
        }
    }

    @Override
    public Cell getCellForUpdate(IColumn column) {
        return this.getCellForUpdate(column.getColumnIndex());
    }

    @Override
    public Cell getCellForUpdate(int columnIndex) {
        return this.m_cells[columnIndex];
    }

    @Override
    public Object getCellValue(int columnIndex) {
        return this.m_cells[columnIndex].getValue();
    }

    @Override
    public Object[] getKeyValues() {
        int[] keyColumns = this.getTable().getColumnSet().getKeyColumnIndexes();
        if (keyColumns.length == 0) {
            keyColumns = this.getTable().getColumnSet().getAllColumnIndexes();
        }
        Object[] pk = new Object[keyColumns.length];
        int i = 0;
        while (i < keyColumns.length) {
            pk[i] = this.m_cells[keyColumns[i]].getValue();
            ++i;
        }
        return pk;
    }

    @Override
    public boolean isRowChanging() {
        return this.m_rowChanging > 0;
    }

    @Override
    public void setRowChanging(boolean b) {
        if (b) {
            ++this.m_rowChanging;
        } else {
            --this.m_rowChanging;
            if (this.m_rowChanging == 0 && this.m_rowPropertiesChanged) {
                this.m_rowPropertiesChanged = false;
                if (this.getTable() != null) {
                    this.getTable().updateRow(this);
                }
            }
        }
    }

    @Override
    public boolean isRowPropertiesChanged() {
        return this.m_rowPropertiesChanged;
    }

    @Override
    public void setRowPropertiesChanged(boolean b) {
        this.m_rowPropertiesChanged = b;
    }

    @Override
    public boolean setCellValue(int columnIndex, Object value) throws ProcessingException {
        return this.m_cells[columnIndex].setValue(value);
    }

    @Override
    public boolean setCellValues(Object[] values) throws ProcessingException {
        boolean changed = false;
        int i = 0;
        while (i < values.length) {
            boolean b = this.setCellValue(i, values[i]);
            changed = changed || b;
            ++i;
        }
        return changed;
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public void touch() throws ProcessingException {
        try {
            this.setRowChanging(true);
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void delete() throws ProcessingException {
        if (this.getTable() != null) {
            this.getTable().deleteRow(this);
        }
    }

    @Override
    public void setBackgroundColor(String c) {
        try {
            this.setRowChanging(true);
            int i = 0;
            while (i < this.m_cells.length) {
                this.m_cells[i].setBackgroundColor(c);
                ++i;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setForegroundColor(String c) {
        try {
            this.setRowChanging(true);
            int i = 0;
            while (i < this.m_cells.length) {
                this.m_cells[i].setForegroundColor(c);
                ++i;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setFont(FontSpec f) {
        try {
            this.setRowChanging(true);
            int i = 0;
            while (i < this.m_cells.length) {
                this.m_cells[i].setFont(f);
                ++i;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setTooltipText(String s) {
        try {
            this.setRowChanging(true);
            int i = 0;
            while (i < this.m_cells.length) {
                this.m_cells[i].setTooltipText(s);
                ++i;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setIconId(String id) {
        try {
            this.setRowChanging(true);
            this.m_iconId = id;
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void moveToTop() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), 0);
        }
    }

    @Override
    public void moveToBottom() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getTable().getRowCount());
        }
    }

    @Override
    public void moveUp() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() - 1);
        }
    }

    @Override
    public void moveDown() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() + 1);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) throws ProcessingException {
        Object oldValue = cell.getValue();
        if (CompareUtility.equals((Object)oldValue, (Object)value)) {
            return value;
        }
        if (this.getTable() != null) {
            int colIndex = -1;
            int i = 0;
            while (i < this.m_cells.length) {
                if (this.m_cells[i] == cell) {
                    colIndex = i;
                    break;
                }
                ++i;
            }
            if (colIndex >= 0) {
                IColumn column = this.getTable().getColumnSet().getColumn(colIndex);
                value = column.parseValue(this, value);
            }
        }
        return value;
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        try {
            this.setRowChanging(true);
            if (changedBit == 1 && this.isStatusNonchanged()) {
                this.setStatusUpdated();
            }
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + VerboseUtility.dumpObjects((Object[])this.m_cells) + "]";
    }
}

