/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.datefield;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDateField
extends AbstractValueField<Date>
implements IDateField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDateField.class);
    private static final ThreadLocal<ParseContext> PARSE_CONTEXT = new ThreadLocal();
    private IDateFieldUIFacade m_uiFacade;
    private String m_format;
    private long m_autoTimeMillis;

    @ConfigProperty(value="STRING")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredHasDate() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=241.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredHasTime() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=270.0)
    @ConfigPropertyValue(value="0")
    protected long getConfiguredAutoTimeMillis() {
        return 0L;
    }

    protected void execShiftDate(int level, int value) throws ProcessingException {
        switch (level) {
            case 0: {
                this.adjustDate(value, 0, 0);
                break;
            }
            case 1: {
                this.adjustDate(0, value, 0);
                break;
            }
            case 2: {
                this.adjustDate(0, 0, value);
            }
        }
    }

    protected void execShiftTime(int level, int value) throws ProcessingException {
        switch (level) {
            case 0: {
                this.adjustTime(value, 0, 0);
                break;
            }
            case 1: {
                this.adjustTime(0, value, 0);
                break;
            }
            case 2: {
                this.adjustTime(0, 0, value);
            }
        }
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setHasDate(this.getConfiguredHasDate());
        this.setHasTime(this.getConfiguredHasTime());
        this.setAutoTimeMillis(this.getConfiguredAutoTimeMillis());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Date)this.getValue()));
        }
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public boolean isHasTime() {
        return this.propertySupport.getPropertyBool("hasTime");
    }

    @Override
    public void setHasTime(boolean b) {
        this.propertySupport.setPropertyBool("hasTime", b);
        if (this.isInitialized()) {
            this.setValue((Date)this.getValue());
        }
    }

    @Override
    public boolean isHasDate() {
        return this.propertySupport.getPropertyBool("hasDate");
    }

    @Override
    public void setHasDate(boolean b) {
        this.propertySupport.setPropertyBool("hasDate", b);
        if (this.isInitialized()) {
            this.setValue((Date)this.getValue());
        }
    }

    @Override
    public void setAutoTimeMillis(long l) {
        this.m_autoTimeMillis = l;
    }

    @Override
    public void setAutoTimeMillis(int hour, int minute, int second) {
        this.setAutoTimeMillis((((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000L);
    }

    @Override
    public long getAutoTimeMillis() {
        return this.m_autoTimeMillis;
    }

    @Override
    public void adjustDate(int days, int months, int years) {
        Date d = (Date)this.getValue();
        if (d == null) {
            d = new Date();
            d = this.applyAutoTime(d);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            cal.add(5, days);
            cal.add(2, months);
            cal.add(1, years);
            d = cal.getTime();
        }
        this.setValue(d);
    }

    @Override
    public void adjustTime(int minutes, int hours, int reserved) {
        Date d = (Date)this.getValue();
        if (d == null) {
            d = new Date();
            d = this.applyAutoTime(d);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            cal.add(12, minutes);
            cal.add(11, hours);
            d = cal.getTime();
        }
        this.setValue(d);
    }

    @Override
    public IDateFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String formatValueInternal(Date validValue) {
        if (validValue == null) {
            return "";
        }
        DateFormat df = this.getDateFormat();
        String displayValue = df.format(validValue);
        return displayValue;
    }

    @Override
    protected Date validateValueInternal(Date rawValue) throws ProcessingException {
        Date legacyValue = rawValue;
        if (legacyValue instanceof Number) {
            rawValue = DateUtility.convertDoubleTimeToDate((Number)((Number)((Object)legacyValue)));
        }
        Date validValue = null;
        rawValue = super.validateValueInternal(rawValue);
        try {
            DateFormat df = this.getDateFormat();
            rawValue = df.parse(df.format(rawValue));
        }
        catch (Throwable throwable) {}
        validValue = rawValue;
        return validValue;
    }

    @Override
    protected Date parseValueInternal(String text) throws ProcessingException {
        boolean customFormat;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if (text == null) {
            return null;
        }
        Date d = null;
        boolean bl = customFormat = this.getFormat() != null;
        if (this.isHasDate() && this.isHasTime()) {
            Date currentValue;
            ParseContext pctx = PARSE_CONTEXT.get();
            if (pctx == null) {
                d = this.parseDateTimeInternal(text, customFormat ? this.getDateFormat() : null);
            } else if (pctx == ParseContext.Date) {
                d = this.parseDateInternal(text, customFormat ? this.getIsolatedDateFormat() : null);
                currentValue = (Date)this.getValue();
                if (currentValue != null) {
                    d = DateUtility.createDateTime((Date)d, (Date)currentValue);
                }
            } else if (pctx == ParseContext.Time) {
                d = this.parseTimeInternal(text, customFormat ? this.getIsolatedTimeFormat() : null);
                currentValue = (Date)this.getValue();
                if (currentValue == null) {
                    currentValue = new Date();
                }
                d = DateUtility.createDateTime((Date)currentValue, (Date)d);
            }
        } else if (this.isHasDate() && !this.isHasTime()) {
            d = this.parseDateInternal(text, customFormat ? this.getDateFormat() : null);
        } else if (!this.isHasDate() && this.isHasTime()) {
            d = this.parseTimeInternal(text, customFormat ? this.getDateFormat() : null);
        }
        DateFormat df = this.getDateFormat();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            int year = cal.get(1);
            d = df.parse(df.format(d));
            cal.setTime(d);
            cal.set(1, year);
            d = cal.getTime();
        }
        catch (ParseException e) {
            throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}), (Throwable)e);
        }
        return d;
    }

    @Override
    public Double getTimeValue() {
        return DateUtility.convertDateToDoubleTime((Date)((Date)this.getValue()));
    }

    @Override
    public void setTimeValue(Double d) {
        this.setValue(DateUtility.convertDoubleTimeToDate((Number)d));
    }

    private Date applyAutoTime(Date d) {
        if (d == null) {
            return d;
        }
        Calendar timeCal = Calendar.getInstance();
        long autoTime = this.getAutoTimeMillis();
        if (autoTime != 0L || !this.isHasTime()) {
            timeCal.set(14, (int)(autoTime % 1000L));
            timeCal.set(13, (int)((autoTime /= 1000L) % 60L));
            timeCal.set(12, (int)((autoTime /= 60L) % 60L));
            timeCal.set(11, (int)((autoTime /= 60L) % 24L));
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(14, timeCal.get(14));
        c.set(13, timeCal.get(13));
        c.set(12, timeCal.get(12));
        c.set(11, timeCal.get(11));
        d = c.getTime();
        return d;
    }

    @Override
    public DateFormat getDateFormat() {
        DateFormat df = null;
        if (this.getFormat() != null) {
            df = new SimpleDateFormat(this.getFormat());
        } else {
            df = this.isHasDate() && !this.isHasTime() ? DateFormat.getDateInstance(2) : (!this.isHasDate() && this.isHasTime() ? DateFormat.getTimeInstance(3) : DateFormat.getDateTimeInstance(3, 3));
            df.setLenient(true);
        }
        return df;
    }

    @Override
    public DateFormat getIsolatedDateFormat() {
        String pat;
        int h;
        DateFormat f = this.getDateFormat();
        if (f instanceof SimpleDateFormat && (h = (pat = ((SimpleDateFormat)f).toPattern()).toLowerCase().indexOf(104)) >= 0) {
            try {
                return new SimpleDateFormat(pat.substring(0, h).trim());
            }
            catch (Throwable t) {
                LOG.error("could not isolate date pattern from '" + pat + "'", t);
            }
        }
        return f;
    }

    @Override
    public DateFormat getIsolatedTimeFormat() {
        String pat;
        int h;
        DateFormat f = this.getDateFormat();
        if (f instanceof SimpleDateFormat && (h = (pat = ((SimpleDateFormat)f).toPattern()).toLowerCase().indexOf(104)) >= 0) {
            try {
                return new SimpleDateFormat(pat.substring(h).trim());
            }
            catch (Throwable t) {
                LOG.error("could not isolate time pattern from '" + pat + "'", t);
            }
        }
        return null;
    }

    private Date parseDateInternal(String text, DateFormat defaultFormat) throws ProcessingException {
        Date retVal = null;
        BooleanHolder includesTime = new BooleanHolder(Boolean.valueOf(false));
        Matcher verboseDeltaMatcher = Pattern.compile("([+-])([0-9]+)").matcher(text);
        if (verboseDeltaMatcher.matches()) {
            int i = Integer.parseInt(verboseDeltaMatcher.group(2));
            if (verboseDeltaMatcher.group(1).equals("-")) {
                i = -i;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, i);
            retVal = cal.getTime();
        } else {
            retVal = this.parseDateFormatsInternal(text, defaultFormat, includesTime);
            if (retVal == null) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}));
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(retVal);
        if (cal.get(1) < -2000) {
            cal.set(1, -2000);
        }
        if (cal.get(1) > 9000) {
            cal.set(1, 9000);
        }
        retVal = cal.getTime();
        retVal = this.applyAutoTime(retVal);
        return retVal;
    }

    private Date parseDateTimeInternal(String text, DateFormat defaultFormat) throws ProcessingException {
        Date retVal = null;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if (text == null) {
            return retVal;
        }
        BooleanHolder includesTime = new BooleanHolder(Boolean.valueOf(false));
        Matcher verboseDeltaMatcher = Pattern.compile("([+-])([0-9]+)").matcher(text);
        if (verboseDeltaMatcher.matches()) {
            int i = Integer.parseInt(verboseDeltaMatcher.group(2));
            if (verboseDeltaMatcher.group(1).equals("-")) {
                i = -i;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, i);
            retVal = cal.getTime();
        } else {
            retVal = this.parseDateTimeFormatsInternal(text, defaultFormat, includesTime);
            if (retVal == null) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}));
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(retVal);
        if (cal.get(1) < -2000) {
            cal.set(1, -2000);
        }
        if (cal.get(1) > 9000) {
            cal.set(1, 9000);
        }
        retVal = cal.getTime();
        if (!((Boolean)includesTime.getValue()).booleanValue()) {
            retVal = this.applyAutoTime(retVal);
        }
        return retVal;
    }

    private Date parseTimeInternal(String text, DateFormat defaultFormat) throws ProcessingException {
        Date retVal = null;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if (text == null) {
            return retVal;
        }
        BooleanHolder includesTime = new BooleanHolder(Boolean.valueOf(false));
        retVal = this.parseTimeFormatsInternal(text, defaultFormat, includesTime);
        if (retVal == null) {
            throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(retVal);
        if (cal.get(1) < -2000) {
            cal.set(1, -2000);
        }
        if (cal.get(1) > 9000) {
            cal.set(1, 9000);
        }
        retVal = cal.getTime();
        DateFormat df = this.getDateFormat();
        try {
            cal = Calendar.getInstance();
            cal.setTime(retVal);
            int year = cal.get(1);
            retVal = df.parse(df.format(retVal));
            cal.setTime(retVal);
            cal.set(1, year);
            retVal = cal.getTime();
        }
        catch (ParseException e) {
            throw new ProcessingException(ScoutTexts.get((String)"InvalidValueMessageX", (String[])new String[]{text}), (Throwable)e);
        }
        return retVal;
    }

    private Date parseDateFormatsInternal(String text, DateFormat defaultFormat, BooleanHolder includesTime) {
        DateFormat templateFmt;
        Date d;
        if (defaultFormat != null && (d = this.parseHelper(defaultFormat, text, includesTime)) != null) {
            return d;
        }
        StringBuffer dateFormat = new StringBuffer();
        if (text.matches("[0-9]{6}")) {
            DateFormat templateFmt2 = DateFormat.getDateInstance(3);
            if (templateFmt2 instanceof SimpleDateFormat) {
                String pattern = ((SimpleDateFormat)templateFmt2).toPattern();
                char[] cArray = pattern.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        dateFormat.append(c);
                    }
                    ++n2;
                }
                d = this.parseHelper(new SimpleDateFormat(dateFormat.toString()), text, includesTime);
                return d;
            }
        } else if (text.matches("[0-9]{8}") && (templateFmt = DateFormat.getDateInstance(2)) instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)templateFmt).toPattern();
            char[] cArray = pattern.toCharArray();
            int n = cArray.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    dateFormat.append(c);
                }
                ++n3;
            }
            d = this.parseHelper(new SimpleDateFormat(dateFormat.toString()), text, includesTime);
            return d;
        }
        if ((d = this.parseHelper(DateFormat.getDateInstance(3), text, includesTime)) != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateInstance(2), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateInstance(1), text, includesTime);
        if (d != null) {
            return d;
        }
        if (Locale.getDefault().getLanguage().equals("en")) {
            d = this.parseHelper(new SimpleDateFormat("M / d / yy"), text, includesTime);
            if (d != null) {
                return d;
            }
            d = this.parseHelper(new SimpleDateFormat("MMM d,yyyy"), text, includesTime);
            if (d != null) {
                return d;
            }
            d = this.parseHelper(new SimpleDateFormat("MMMM d,yyyy"), text, includesTime);
            if (d != null) {
                return d;
            }
        }
        return null;
    }

    private Date parseDateTimeFormatsInternal(String text, DateFormat defaultFormat, BooleanHolder includesTime) {
        DateFormat templateFmt;
        Date d = null;
        if (defaultFormat != null && (d = this.parseHelper(defaultFormat, text, includesTime)) != null) {
            return d;
        }
        StringBuffer dateFormat = new StringBuffer();
        if (text.matches("[0-9]{6}")) {
            templateFmt = DateFormat.getDateInstance(3);
            if (templateFmt instanceof SimpleDateFormat) {
                String pattern = ((SimpleDateFormat)templateFmt).toPattern();
                char[] cArray = pattern.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        dateFormat.append(c);
                    }
                    ++n2;
                }
                d = this.parseHelper(new SimpleDateFormat(dateFormat.toString()), text, includesTime);
                return d;
            }
        } else if (text.matches("[0-9]{8}") && (templateFmt = DateFormat.getDateInstance(2)) instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)templateFmt).toPattern();
            char[] cArray = pattern.toCharArray();
            int n = cArray.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    dateFormat.append(c);
                }
                ++n3;
            }
            d = this.parseHelper(new SimpleDateFormat(dateFormat.toString()), text, includesTime);
            return d;
        }
        if ((d = this.parseHelper(DateFormat.getDateTimeInstance(3, 3), text, includesTime)) != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(3, 2), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2)).toPattern()) + ":SSS"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(3, 1), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(2, 3), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(2, 2), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(2, 1), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(1, 3), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(1, 2), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getDateTimeInstance(1, 1), text, includesTime);
        if (d != null) {
            return d;
        }
        DateFormat[] dateFormatArray = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1)};
        int n = dateFormatArray.length;
        int n4 = 0;
        while (n4 < n) {
            DateFormat t = dateFormatArray[n4];
            if (t instanceof SimpleDateFormat) {
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " h:mm a"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " hhmm a"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " hmm a"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " h a"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " h:mma"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " hhmma"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " ha"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " H:mm"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " HHmm"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " HH"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " Hmm"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(new SimpleDateFormat(String.valueOf(((SimpleDateFormat)t).toPattern()) + " H"), text, includesTime);
                if (d != null) {
                    return d;
                }
                d = this.parseHelper(t, text, includesTime);
                if (d != null) {
                    return d;
                }
            }
            ++n4;
        }
        if (Locale.getDefault().getLanguage().equals("en")) {
            d = this.parseHelper(new SimpleDateFormat("M / d / yy"), text, includesTime);
            if (d != null) {
                return d;
            }
            d = this.parseHelper(new SimpleDateFormat("MMM d,yyyy"), text, includesTime);
            if (d != null) {
                return d;
            }
            d = this.parseHelper(new SimpleDateFormat("MMMM d,yyyy"), text, includesTime);
            if (d != null) {
                return d;
            }
        }
        return null;
    }

    private Date parseTimeFormatsInternal(String text, DateFormat defaultFormat, BooleanHolder includesTime) {
        int hours;
        Date d = null;
        if (defaultFormat != null && (d = this.parseHelper(defaultFormat, text, includesTime)) != null) {
            return d;
        }
        if (text.matches("[0-9]{3}")) {
            text = "0" + text;
        }
        if (text.matches("[0-9]{2}") && (hours = Integer.parseInt(text)) >= 24) {
            text = "00" + text;
        }
        if (defaultFormat != null && (d = this.parseHelper(defaultFormat, text, includesTime)) != null) {
            return d;
        }
        d = this.parseHelper(DateFormat.getTimeInstance(3), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("h:mm a"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("hhmm a"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("hmm a"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("h a"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("h:mma"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("hhmma"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("ha"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("H:mm"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("HHmm"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("HH"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("Hmm"), text, includesTime);
        if (d != null) {
            return d;
        }
        d = this.parseHelper(new SimpleDateFormat("H"), text, includesTime);
        if (d != null) {
            return d;
        }
        return null;
    }

    private Date parseHelper(DateFormat df, String text, BooleanHolder includesTime) {
        String pattern;
        Date d = null;
        try {
            df.setLenient(false);
            d = df.parse(text);
        }
        catch (ParseException parseException) {}
        if (d == null) {
            try {
                if (df instanceof SimpleDateFormat && (pattern = ((SimpleDateFormat)df).toPattern()).contains(".")) {
                    SimpleDateFormat df2 = new SimpleDateFormat(pattern.replace(".", ","));
                    df2.setLenient(false);
                    d = df2.parse(text);
                }
            }
            catch (ParseException parseException) {}
        }
        if (d != null) {
            if (df instanceof SimpleDateFormat) {
                pattern = ((SimpleDateFormat)df).toPattern();
                if (pattern.matches(".*[hHM].*")) {
                    includesTime.setValue((Object)true);
                }
            } else {
                includesTime.setValue((Object)true);
            }
        }
        return d;
    }

    private class P_UIFacade
    implements IDateFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setDateTextFromUI(String newDate) {
            if (!AbstractDateField.this.isHasDate()) {
                return false;
            }
            if (newDate != null && newDate.length() == 0) {
                newDate = null;
            }
            if (!AbstractDateField.this.isHasTime()) {
                return AbstractDateField.this.parseValue(newDate);
            }
            if (newDate == null) {
                return AbstractDateField.this.parseValue(null);
            }
            try {
                PARSE_CONTEXT.set(ParseContext.Date);
                boolean bl = AbstractDateField.this.parseValue(newDate);
                return bl;
            }
            finally {
                PARSE_CONTEXT.set(null);
            }
        }

        @Override
        public boolean setTimeTextFromUI(String newTime) {
            if (!AbstractDateField.this.isHasTime()) {
                return false;
            }
            if (newTime != null && newTime.length() == 0) {
                newTime = null;
            }
            if (!AbstractDateField.this.isHasDate()) {
                return AbstractDateField.this.parseValue(newTime);
            }
            try {
                PARSE_CONTEXT.set(ParseContext.Time);
                boolean bl = AbstractDateField.this.parseValue(newTime);
                return bl;
            }
            finally {
                PARSE_CONTEXT.set(null);
            }
        }

        @Override
        public boolean setDateTimeTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractDateField.this.parseValue(newText);
        }

        @Override
        public void setDateFromUI(Date d) {
            try {
                if (d != null) {
                    Date oldDate = (Date)AbstractDateField.this.getValue();
                    if (oldDate != null) {
                        Calendar calOld = Calendar.getInstance();
                        calOld.setTime(oldDate);
                        Calendar calNew = Calendar.getInstance();
                        calNew.setTime(d);
                        calNew.set(10, calOld.get(10));
                        calNew.set(11, calOld.get(11));
                        calNew.set(12, calOld.get(12));
                        calNew.set(13, calOld.get(13));
                        calNew.set(14, calOld.get(14));
                        d = calNew.getTime();
                    } else {
                        d = AbstractDateField.this.applyAutoTime(d);
                    }
                }
                AbstractDateField.this.setValue(d);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }

        @Override
        public void setTimeFromUI(Date d) {
            try {
                Date oldDate = (Date)AbstractDateField.this.getValue();
                if (d != null) {
                    if (oldDate != null) {
                        Calendar calOld = Calendar.getInstance();
                        calOld.setTime(oldDate);
                        Calendar calNew = Calendar.getInstance();
                        calNew.setTime(d);
                        calNew.set(1, calOld.get(1));
                        calNew.set(2, calOld.get(2));
                        calNew.set(5, calOld.get(5));
                        d = calNew.getTime();
                    }
                } else if (AbstractDateField.this.isHasDate() && oldDate != null) {
                    d = AbstractDateField.this.applyAutoTime(oldDate);
                }
                AbstractDateField.this.setValue(d);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }

        @Override
        public void setDateTimeFromUI(Date d) {
            try {
                AbstractDateField.this.setValue(d);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }

        @Override
        public void fireDateShiftActionFromUI(int level, int value) {
            try {
                AbstractDateField.this.execShiftDate(level, value);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }

        @Override
        public void fireTimeShiftActionFromUI(int level, int value) {
            try {
                AbstractDateField.this.execShiftTime(level, value);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    private static enum ParseContext {
        Date,
        Time;

    }
}

