/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.internal.RadioButtonGroupGrid;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractRadioButtonGroup<T>
extends AbstractValueField<T>
implements IRadioButtonGroup<T>,
ICompositeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRadioButtonGroup.class);
    private boolean m_valueAndSelectionMediatorActive;
    private LookupCall m_lookupCall;
    private Class<? extends ICodeType> m_codeTypeClass;
    private RadioButtonGroupGrid m_grid;
    private IFormField[] m_fields;
    private IButton[] m_radioButtons;

    public AbstractRadioButtonGroup() {
        this(true);
    }

    public AbstractRadioButtonGroup(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="lookupCall")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType> getConfiguredCodeType() {
        return null;
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareLookup(LookupCall call) {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execFilterLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        Class<LookupCall> lookupCallClass;
        this.m_fields = new IFormField[0];
        this.m_grid = new RadioButtonGroupGrid(this);
        super.initConfig();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                LookupCall call = lookupCallClass.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
            }
        }
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        Class<IFormField>[] fieldArray = this.getConfiguredFields();
        int i = 0;
        while (i < fieldArray.length) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i]);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + fieldArray[i].getName(), t));
            }
            ++i;
        }
        this.injectFieldsInternal(fieldList);
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        IFormField[] iFormFieldArray = this.m_fields = fieldList.toArray(new IFormField[0]);
        int n = this.m_fields.length;
        int f = 0;
        while (f < n) {
            IFormField f2 = iFormFieldArray[f];
            f2.addPropertyChangeListener(new P_FieldPropertyChangeListenerEx());
            ++f;
        }
        ArrayList<IButton> buttonList = new ArrayList<IButton>();
        IFormField[] iFormFieldArray2 = this.m_fields;
        int n2 = this.m_fields.length;
        n = 0;
        while (n < n2) {
            IFormField f3 = iFormFieldArray2[n];
            IButton b = this.findFirstButtonInFieldTree(f3);
            if (b != null) {
                buttonList.add(b);
            }
            ++n;
        }
        this.m_radioButtons = buttonList.toArray(new IButton[buttonList.size()]);
        iFormFieldArray2 = this.m_radioButtons;
        n2 = this.m_radioButtons.length;
        n = 0;
        while (n < n2) {
            IFormField b = iFormFieldArray2[n];
            b.setDisplayStyleInternal(2);
            b.addPropertyChangeListener(new P_ButtonPropertyChangeListener());
            ++n;
        }
        this.handleFieldVisibilityChanged();
    }

    private IButton findFirstButtonInFieldTree(IFormField f) {
        if (f instanceof IButton) {
            return (IButton)f;
        }
        if (f instanceof ICompositeField) {
            IFormField[] iFormFieldArray = ((ICompositeField)f).getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField sub = iFormFieldArray[n2];
                IButton b = this.findFirstButtonInFieldTree(sub);
                if (b != null) {
                    return b;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void injectFieldsInternal(List<IFormField> fieldList) {
        if (this.getLookupCall() != null) {
            try {
                LookupRow[] lookupRows = this.getLookupRows();
                int i = 0;
                while (i < lookupRows.length) {
                    RadioButton radioButton = new RadioButton();
                    radioButton.setEnabled(lookupRows[i].isEnabled());
                    radioButton.setLabel(lookupRows[i].getText());
                    radioButton.setRadioValue(lookupRows[i].getKey());
                    radioButton.setTooltipText(lookupRows[i].getTooltipText());
                    radioButton.setBackgroundColor(lookupRows[i].getBackgroundColor());
                    radioButton.setForegroundColor(lookupRows[i].getForegroundColor());
                    radioButton.setFont(lookupRows[i].getFont());
                    fieldList.add(radioButton);
                    ++i;
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
            }
        }
    }

    public LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setCodeTypeClass(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = new CodeLookupCall(this.m_codeTypeClass);
        }
        if (this.getConfiguredLabel() == null) {
            this.setLabel(CODES.getCodeType(codeTypeClass).getText());
        }
    }

    protected Class<? extends IFormField>[] getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IFormField.class);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        IButton b = this.getButtonFor(null);
        if (b != null) {
            this.syncValueToButtons();
        }
        super.initFieldInternal();
    }

    private LookupRow[] getLookupRows() throws ProcessingException {
        LookupRow[] data;
        LookupCall call = null;
        if (this.getLookupCall() != null) {
            call = (LookupCall)this.getLookupCall().clone();
            this.prepareLookupCall(call);
            data = call.getDataByAll();
        } else {
            data = new LookupRow[]{};
        }
        ArrayList<Object> result = data != null ? new ArrayList<LookupRow>(Arrays.asList(data)) : new ArrayList();
        this.filterLookup(call, result);
        return result.toArray(new LookupRow[result.size()]);
    }

    private void prepareLookupCall(LookupCall call) {
        this.prepareLookupCallInternal(call);
        this.execPrepareLookup(call);
    }

    private void prepareLookupCallInternal(LookupCall call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    private void filterLookup(LookupCall call, List<LookupRow> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
    }

    @Override
    public void rebuildFieldGrid() {
        if (this.m_grid != null) {
            this.m_grid.validate();
            if (this.isInitialized()) {
                if (this.getParentField() != null) {
                    this.getParentField().rebuildFieldGrid();
                }
                if (this.getForm() != null) {
                    this.getForm().structureChanged(this);
                }
            }
        }
    }

    protected void handleFieldVisibilityChanged() {
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_grid != null ? this.m_grid.getGridColumnCount() : 1;
    }

    @Override
    public final int getGridRowCount() {
        return this.m_grid != null ? this.m_grid.getGridRowCount() : 1;
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setFormInternal(form);
            ++n2;
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToButtons();
    }

    @Override
    protected T validateValueInternal(T rawValue) throws ProcessingException {
        Object validValue;
        if (rawValue == null) {
            validValue = null;
        } else {
            Object t = TypeCastUtility.castValue(rawValue, this.getHolderType());
            IButton b = this.getButtonFor(t);
            if (b != null) {
                validValue = t;
            } else {
                throw new ProcessingException("Illegal radio value: " + rawValue);
            }
        }
        return (T)validValue;
    }

    @Override
    @ConfigPropertyValue(value="0")
    protected double getConfiguredGridWeightY() {
        return 0.0;
    }

    @Override
    public T getSelectedKey() {
        return this.getValue();
    }

    @Override
    public IButton getButtonFor(T value) {
        IButton[] iButtonArray = this.getButtons();
        int n = iButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b = iButtonArray[n2];
            Object radioValue = TypeCastUtility.castValue((Object)b.getRadioValue(), this.getHolderType());
            if (CompareUtility.equals((Object)radioValue, value)) {
                return b;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IButton getSelectedButton() {
        return this.getButtonFor(this.getSelectedKey());
    }

    @Override
    public void selectKey(T key) {
        this.setValue(key);
    }

    @Override
    public void selectButton(IButton button) {
        IButton[] iButtonArray = this.getButtons();
        int n = iButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButton b = iButtonArray[n2];
            if (b == button) {
                button.setSelected(true);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setEnabled(b);
            ++n2;
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.getEnabledPermission() == null) {
                f.setEnabledGranted(b);
            }
            ++n2;
        }
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.length;
    }

    @Override
    public int getFieldIndex(IFormField f) {
        int i = 0;
        while (i < this.m_fields.length) {
            if (this.m_fields[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IFormField[] getFields() {
        IFormField[] a = new IFormField[this.m_fields.length];
        System.arraycopy(this.m_fields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public IButton[] getButtons() {
        return this.m_radioButtons;
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i] instanceof ICompositeField ? !((ICompositeField)f[i]).visitFields(visitor, startLevel + 1) : !visitor.visitField(f[i], startLevel, index)) {
                return false;
            }
            ++index;
            ++i;
        }
        return true;
    }

    private void syncValueToButtons() {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            T selectedKey = this.getSelectedKey();
            IButton selectedButton = this.getButtonFor(selectedKey);
            IButton[] iButtonArray = this.getButtons();
            int n = iButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                IButton b;
                b.setSelected((b = iButtonArray[n2]) == selectedButton);
                ++n2;
            }
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private void syncButtonsToValue(IButton selectedButton) {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            IButton[] iButtonArray = this.getButtons();
            int n = iButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                IButton b;
                b.setSelected((b = iButtonArray[n2]) == selectedButton);
                ++n2;
            }
            Object radioValue = TypeCastUtility.castValue((Object)selectedButton.getRadioValue(), this.getHolderType());
            this.selectKey(radioValue);
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private class P_ButtonPropertyChangeListener
    implements PropertyChangeListener {
        private P_ButtonPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selected") && ((IButton)e.getSource()).isSelected()) {
                AbstractRadioButtonGroup.this.syncButtonsToValue((IButton)e.getSource());
            }
        }
    }

    private class P_FieldPropertyChangeListenerEx
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListenerEx() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractRadioButtonGroup.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractRadioButtonGroup.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractRadioButtonGroup.this.checkEmpty();
            }
        }
    }

    private final class RadioButton
    extends AbstractButton {
        private RadioButton() {
        }

        @Override
        protected void initConfig() {
            super.initConfig();
        }
    }
}

