/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.BlockingCondition;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.wizard.DefaultWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.client.ui.wizard.WizardEvent;
import org.eclipse.scout.rt.client.ui.wizard.WizardListener;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractWizard
extends AbstractPropertyObserver
implements IWizard {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWizard.class);
    private boolean m_initialized;
    private final EventListenerList m_listenerList = new EventListenerList();
    private ArrayList<IWizardStep<? extends IForm>> m_availableStepList;
    private ArrayList<IWizardStep<? extends IForm>> m_stepList;
    private IWizardStep<? extends IForm> m_activeStep;
    private final OptimisticLock m_changingLock = new OptimisticLock();
    private ArrayList<WizardEvent> m_accumulatedEvents = new ArrayList(3);
    private boolean m_displayHintLocked;
    private boolean m_modal;
    private String m_displayViewId;
    private int m_displayHint;
    private final BlockingCondition m_blockingCondition;
    private IWizardContainerForm m_containerForm;
    private PropertyChangeListener m_anyFieldChangeListener;

    public AbstractWizard() {
        this(true);
    }

    public AbstractWizard(boolean callInitializer) {
        this.m_availableStepList = new ArrayList(0);
        this.m_stepList = new ArrayList(0);
        this.m_blockingCondition = new BlockingCondition(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="FORM_DISPLAY_HINT")
    @Order(value=100.0)
    @ConfigPropertyValue(value="DISPLAY_HINT_DIALOG")
    protected int getConfiguredDisplayHint() {
        return 0;
    }

    @ConfigProperty(value="FORM_VIEW_ID")
    @Order(value=105.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDisplayViewId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=106.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredModal() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitleHtml() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredWizardNo() {
        return null;
    }

    private Class<? extends IWizardStep<? extends IForm>>[] getConfiguredAvailableSteps() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IWizardStep.class);
    }

    @ConfigOperation
    @Order(value=5.0)
    protected IWizardContainerForm execCreateContainerForm() throws ProcessingException {
        DefaultWizardContainerForm containerForm = new DefaultWizardContainerForm(this);
        containerForm.setDisplayHint(this.getDisplayHint());
        containerForm.setDisplayViewId(this.getDisplayViewId());
        containerForm.setModal(this.isModal());
        return containerForm;
    }

    @ConfigOperation
    @Order(value=6.0)
    protected void execActiveStepChanged() throws ProcessingException {
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execStart() throws ProcessingException {
        List<IWizardStep<? extends IForm>> steps = this.getAvailableSteps();
        this.setSteps(steps);
        if (steps.size() > 0) {
            this.activateStep(steps.get(0));
        }
    }

    @Order(value=20.0)
    @ConfigOperation
    protected void execNextStep() throws ProcessingException {
        IWizardStep<? extends IForm> step = this.getNextStep();
        this.activateStep(step);
    }

    @Order(value=30.0)
    @ConfigOperation
    protected void execPreviousStep() throws ProcessingException {
        IWizardStep<? extends IForm> step = this.getPreviousStep();
        this.activateStep(step);
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execFinish() throws ProcessingException {
        this.activateStep(null);
        this.close();
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execCancel() throws ProcessingException {
        this.close();
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execSuspend() throws ProcessingException {
        this.close();
    }

    @Order(value=65.0)
    @ConfigOperation
    protected void execReset() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execAnyFieldChanged(IFormField source) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execRefreshButtonPolicy() throws ProcessingException {
        IWizardStep<? extends IForm> prev = this.getPreviousStep();
        IWizardStep<? extends IForm> next = this.getNextStep();
        IButton b = this.getContainerForm().getWizardPreviousStepButton();
        if (b != null) {
            b.setView(true, prev != null, false);
        }
        if ((b = this.getContainerForm().getWizardNextStepButton()) != null) {
            b.setView(next != null, true, false);
        }
        if ((b = this.getContainerForm().getWizardFinishButton()) != null) {
            b.setView(next == null, true, false);
        }
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
        LOG.info("execHyperlinkAction " + url + " (in " + this.getClass().getName() + ")");
    }

    protected void initConfig() {
        Class<? extends IWizardStep<? extends IForm>>[] a;
        this.setDisplayHint(this.getConfiguredDisplayHint());
        this.setDisplayViewId(this.getConfiguredDisplayViewId());
        this.setModal(this.getConfiguredModal());
        this.setTitle(this.getConfiguredTitle());
        this.setTitleHtml(this.getConfiguredTitleHtml());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setIconId(this.getConfiguredIconId());
        this.setWizardNo(this.getConfiguredWizardNo());
        this.propertySupport.setPropertyBool("closed", true);
        this.setCloseTypeInternal(IWizard.CloseType.Unknown);
        ArrayList<IWizardStep<? extends IForm>> list = new ArrayList<IWizardStep<? extends IForm>>();
        Class<? extends IWizardStep<? extends IForm>>[] classArray = a = this.getConfiguredAvailableSteps();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IWizardStep<? extends IForm>> element = classArray[n2];
            try {
                IWizardStep step = (IWizardStep)ConfigurationUtility.newInnerInstance((Object)this, element);
                list.add(step);
            }
            catch (Exception e) {
                LOG.error("failed creating " + element, (Throwable)e);
            }
            ++n2;
        }
        this.injectStepsInternal(list);
        this.setAvailableSteps(list);
        this.m_anyFieldChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                try {
                    AbstractWizard.this.execAnyFieldChanged((IFormField)e.getSource());
                }
                catch (Throwable t) {
                    LOG.error(e.getSource() + " " + e.getPropertyName() + "=" + e.getNewValue(), t);
                }
            }
        };
        this.propertySupport.addPropertyChangeListener("wizardForm", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IForm oldForm = (IForm)e.getOldValue();
                IForm newForm = (IForm)e.getNewValue();
                if (oldForm != null) {
                    oldForm.getRootGroupBox().removeSubtreePropertyChangeListener("value", AbstractWizard.this.m_anyFieldChangeListener);
                }
                if (newForm != null) {
                    newForm.getRootGroupBox().addSubtreePropertyChangeListener("value", AbstractWizard.this.m_anyFieldChangeListener);
                }
            }
        });
    }

    protected void injectStepsInternal(List<IWizardStep<? extends IForm>> steps) {
    }

    @Override
    public void addWizardListener(WizardListener listener) {
        this.m_listenerList.add(WizardListener.class, (EventListener)listener);
    }

    @Override
    public void removeWizardListener(WizardListener listener) {
        this.m_listenerList.remove(WizardListener.class, (EventListener)listener);
    }

    private void fireStateChanged() {
        this.fireWizardEvent(new WizardEvent(this, 10));
    }

    private void fireClosed() {
        this.fireWizardEvent(new WizardEvent(this, 50));
    }

    private void fireWizardEvent(WizardEvent e) {
        if (this.m_changingLock.isAcquired()) {
            Iterator<WizardEvent> it = this.m_accumulatedEvents.iterator();
            while (it.hasNext()) {
                WizardEvent existingEvent = it.next();
                if (existingEvent.getType() != e.getType()) continue;
                it.remove();
            }
            this.m_accumulatedEvents.add(e);
        } else {
            WizardListener[] a = (WizardListener[])this.m_listenerList.getListeners(WizardListener.class);
            if (a != null && a.length > 0) {
                WizardListener[] wizardListenerArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    WizardListener element = wizardListenerArray[n2];
                    element.wizardChanged(e);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void setChanging(boolean b) {
        if (b) {
            this.m_changingLock.acquire();
        } else {
            this.m_changingLock.release();
            if (this.m_changingLock.isReleased()) {
                ArrayList<WizardEvent> list = this.m_accumulatedEvents;
                this.m_accumulatedEvents = new ArrayList(3);
                for (WizardEvent e : list) {
                    this.fireWizardEvent(e);
                }
            }
        }
    }

    @Override
    public boolean isChanging() {
        return this.m_changingLock.isAcquired();
    }

    @Override
    public int getDisplayHint() {
        return this.m_displayHint;
    }

    @Override
    public void setDisplayHint(int i) {
        if (this.m_displayHintLocked) {
            throw new IllegalArgumentException("displayHint cannot be changed once the form handling has started");
        }
        switch (i) {
            case 0: {
                this.m_displayHint = i;
                break;
            }
            case 20: {
                this.m_displayHint = i;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid displayHint " + i);
            }
        }
    }

    @Override
    public String getDisplayViewId() {
        return this.m_displayViewId;
    }

    @Override
    public void setDisplayViewId(String viewId) {
        this.m_displayViewId = viewId;
    }

    @Override
    public boolean isModal() {
        return this.m_modal;
    }

    @Override
    public void setModal(boolean b) {
        this.m_modal = b;
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public String getTitleHtml() {
        return this.propertySupport.getPropertyString("titleHtml");
    }

    @Override
    public void setTitleHtml(String s) {
        this.propertySupport.setPropertyString("titleHtml", s);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String s) {
        this.propertySupport.setPropertyString("tooltipText", s);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    public String getSubTitle() {
        return this.propertySupport.getPropertyString("subTitle");
    }

    @Override
    public void setSubTitle(String s) {
        this.propertySupport.setPropertyString("subTitle", s);
    }

    @Override
    public String getWizardNo() {
        return this.propertySupport.getPropertyString("subTitle");
    }

    @Override
    public void setWizardNo(String s) {
        this.propertySupport.setPropertyString("subTitle", s);
    }

    public IDesktop getDesktop() {
        return ClientSyncJob.getCurrentSession().getDesktop();
    }

    @Override
    public <T extends IWizardStep<? extends IForm>> T getAvailableStep(Class<T> type) {
        for (IWizardStep<? extends IForm> step : this.m_availableStepList) {
            if (!type.isInstance(step)) continue;
            return (T)step;
        }
        return null;
    }

    @Override
    public <T extends IWizardStep<? extends IForm>> T getStep(Class<T> type) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!type.isInstance(step)) continue;
            return (T)step;
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStep(int index) {
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStepBySimpleClassName(String simpleClassName) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!step.getClass().getSimpleName().equals(simpleClassName)) continue;
            return step;
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStepByClassName(String className) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!step.getClass().getName().equals(className)) continue;
            return step;
        }
        return null;
    }

    @Override
    public int getStepIndex(IWizardStep<? extends IForm> step) {
        if (step == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_stepList.size()) {
            if (this.m_stepList.get(i) == step) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<IWizardStep<? extends IForm>> getAvailableSteps() {
        if (this.m_availableStepList != null) {
            return new ArrayList<IWizardStep<? extends IForm>>(this.m_availableStepList);
        }
        return Collections.emptyList();
    }

    @Override
    public void setAvailableSteps(List<IWizardStep<? extends IForm>> steps) {
        this.m_availableStepList = new ArrayList();
        if (steps != null) {
            for (IWizardStep<? extends IForm> step : steps) {
                if (step == null) continue;
                this.m_availableStepList.add(step);
            }
        }
    }

    @Override
    public List<IWizardStep<? extends IForm>> getSteps() {
        if (this.m_stepList != null) {
            return new ArrayList<IWizardStep<? extends IForm>>(this.m_stepList);
        }
        return Collections.emptyList();
    }

    @Override
    public void setSteps(IWizardStep<? extends IForm> ... steps) {
        if (steps == null) {
            steps = new IWizardStep[]{};
        }
        this.setSteps(Arrays.asList(steps));
    }

    @Override
    public void setSteps(List<IWizardStep<? extends IForm>> steps) {
        try {
            this.setChanging(true);
            if (this.m_stepList != null) {
                for (IWizardStep<? extends IForm> step : this.m_stepList) {
                    step.setWizardInternal(null);
                }
            }
            this.m_stepList = new ArrayList();
            if (steps != null) {
                for (IWizardStep<? extends IForm> step : steps) {
                    if (step == null) continue;
                    this.m_stepList.add(step);
                    step.setWizardInternal(this);
                }
            }
            this.fireStateChanged();
        }
        finally {
            this.setChanging(false);
        }
    }

    @Override
    public IWizardStep<? extends IForm> getActiveStep() {
        return this.m_activeStep;
    }

    @Override
    public void activateStep(IWizardStep<? extends IForm> step) throws ProcessingException {
        this.activateStep(step, false, false);
    }

    @Override
    public void activateStep(IWizardStep<? extends IForm> step, boolean jumpForward, boolean jumpBackward) throws ProcessingException {
        if (this.m_activeStep != step) {
            try {
                List<IWizardStep<? extends IForm>> intermediateSteps;
                int kind = this.getStepKind(this.m_activeStep, step);
                if (this.m_activeStep != null) {
                    this.m_activeStep.deactivate(kind);
                }
                if ((intermediateSteps = this.getStepSpan(this.m_activeStep, false, step, false)).size() > 0 && (kind == 1 && !jumpForward || kind == 2 && !jumpBackward)) {
                    for (IWizardStep<? extends IForm> intermediateStep : intermediateSteps) {
                        intermediateStep.activate(kind);
                        intermediateStep.deactivate(kind);
                    }
                }
                this.m_activeStep = step;
                if (this.m_activeStep != null) {
                    this.m_activeStep.activate(kind);
                }
                try {
                    this.execActiveStepChanged();
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                }
            }
            finally {
                this.refreshButtonPolicy();
                this.fireStateChanged();
            }
        }
    }

    @Override
    public void refreshButtonPolicy() {
        try {
            this.execRefreshButtonPolicy();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    public int getStepKind(IWizardStep<? extends IForm> from, IWizardStep<? extends IForm> to) {
        int toIndex;
        if (from == null && to == null) {
            return 1;
        }
        if (from == null) {
            return 1;
        }
        if (to == null) {
            return 1;
        }
        int fromIndex = this.getStepIndex(from);
        if (fromIndex == (toIndex = this.getStepIndex(to))) {
            return 1;
        }
        if (fromIndex < toIndex) {
            return 1;
        }
        if (fromIndex > toIndex) {
            return 2;
        }
        return 1;
    }

    @Override
    public List<IWizardStep<? extends IForm>> getStepSpan(IWizardStep<? extends IForm> from, boolean includeFrom, IWizardStep<? extends IForm> to, boolean includeTo) {
        int toIndex;
        ArrayList<IWizardStep<? extends IForm>> list = new ArrayList<IWizardStep<? extends IForm>>();
        if (from == null && to == null) {
            if (from == null || includeFrom) {
                // empty if block
            }
            if (to == null || includeTo) {
                // empty if block
            }
            return list;
        }
        if (from == null) {
            if (from == null || includeFrom) {
                // empty if block
            }
            if (to != null && includeTo) {
                list.add(to);
            }
            return list;
        }
        if (to == null) {
            if (from != null && includeFrom) {
                list.add(from);
            }
            if (to == null || includeTo) {
                // empty if block
            }
            return list;
        }
        int fromIndex = this.getStepIndex(from);
        if (fromIndex == (toIndex = this.getStepIndex(to))) {
            if (includeFrom) {
                list.add(from);
            } else if (includeTo) {
                list.add(to);
            }
            return list;
        }
        if (fromIndex == toIndex - 1) {
            if (includeFrom) {
                list.add(from);
            }
            if (includeTo) {
                list.add(to);
            }
            return list;
        }
        if (fromIndex < toIndex - 1) {
            if (includeFrom) {
                list.add(from);
            }
            int n = toIndex - fromIndex - 1;
            int i = 0;
            while (i < n) {
                list.add(this.m_stepList.get(fromIndex + 1 + i));
                ++i;
            }
            if (includeTo) {
                list.add(to);
            }
            return list;
        }
        if (fromIndex == toIndex + 1) {
            if (includeFrom) {
                list.add(from);
            }
            if (includeTo) {
                list.add(to);
            }
            return list;
        }
        if (fromIndex > toIndex + 1) {
            if (includeFrom) {
                list.add(from);
            }
            int n = fromIndex - toIndex - 1;
            int i = 0;
            while (i < n) {
                list.add(this.m_stepList.get(fromIndex - 1 - i));
                ++i;
            }
            if (includeTo) {
                list.add(to);
            }
            return list;
        }
        if (includeFrom) {
            list.add(from);
        }
        if (includeTo) {
            list.add(to);
        }
        return list;
    }

    @Override
    public IWizardStep<? extends IForm> getPreviousStep() {
        int index = this.getStepIndex(this.getActiveStep()) - 1;
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getNextStep() {
        int index = this.getStepIndex(this.getActiveStep()) + 1;
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getPreviousEnabledStep() {
        int index = this.getStepIndex(this.getActiveStep()) - 1;
        while (index >= 0 && index < this.m_stepList.size() && !this.m_stepList.get(index).isEnabled()) {
            --index;
        }
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getNextEnabledStep() {
        int index = this.getStepIndex(this.getActiveStep()) + 1;
        while (index >= 0 && index < this.m_stepList.size() && !this.m_stepList.get(index).isEnabled()) {
            ++index;
        }
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    public IWizardStep<? extends IForm>[] getHistory() {
        int index = this.getStepIndex(this.getActiveStep());
        if (this.m_stepList.size() > 0 && index >= 0) {
            return this.m_stepList.subList(0, Math.min(index, this.m_stepList.size())).toArray(new IWizardStep[0]);
        }
        return new IWizardStep[0];
    }

    public IWizardStep<? extends IForm>[] getExpectedFuture() {
        int index = this.getStepIndex(this.getActiveStep());
        if (this.m_stepList.size() > 0 && index < this.m_stepList.size()) {
            return this.m_stepList.subList(Math.max(index + 1, 0), this.m_stepList.size()).toArray(new IWizardStep[0]);
        }
        return new IWizardStep[0];
    }

    @Override
    public void start() throws ProcessingException {
        this.assertClosed();
        if (this.m_blockingCondition.isBlocking()) {
            throw new ProcessingException("The wizard " + this.getClass().getSimpleName() + " has already been started");
        }
        this.m_blockingCondition.setBlocking(true);
        this.propertySupport.setPropertyBool("closed", false);
        this.setCloseTypeInternal(IWizard.CloseType.Unknown);
        this.createContainerForm();
        this.execStart();
        if (this.m_containerForm != null && !this.m_containerForm.isFormOpen()) {
            this.m_containerForm.startWizard();
        }
    }

    @Override
    public void close() throws ProcessingException {
        if (!this.isClosed()) {
            try {
                if (this.m_containerForm != null) {
                    this.m_containerForm.doClose();
                    this.m_containerForm = null;
                }
            }
            catch (Throwable t) {
                LOG.error("closing " + this.getTitle(), t);
            }
            HashSet<IWizardStep<? extends IForm>> set = new HashSet<IWizardStep<? extends IForm>>();
            set.addAll(this.getAvailableSteps());
            set.addAll(this.getSteps());
            for (IWizardStep iWizardStep : set) {
                try {
                    iWizardStep.dispose();
                }
                catch (Throwable t) {
                    LOG.error("closing " + this.getTitle(), t);
                }
            }
            if (this.getCloseType() == IWizard.CloseType.Unknown) {
                this.setCloseTypeInternal(IWizard.CloseType.Closed);
            }
            this.propertySupport.setPropertyBool("closed", true);
            this.fireClosed();
            this.m_blockingCondition.release();
        }
    }

    @Override
    public void waitFor() throws ProcessingException {
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop == null || !desktop.isOpened()) {
            throw new ProcessingException("Cannot wait for " + this.getClass().getName() + ". There is no desktop or the desktop has not yet been opened in the ui", null, 69218);
        }
        try {
            this.m_blockingCondition.waitFor();
        }
        catch (InterruptedException e) {
            throw new ProcessingException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.propertySupport.getPropertyBool("closed");
    }

    @Override
    public IWizard.CloseType getCloseType() {
        return (IWizard.CloseType)((Object)this.propertySupport.getProperty("closeType"));
    }

    private void setCloseTypeInternal(IWizard.CloseType t) {
        this.propertySupport.setProperty("closeType", (Object)t);
    }

    @Override
    public void doNextStep() throws ProcessingException {
        if (this.isOpen()) {
            try {
                this.execNextStep();
            }
            catch (ProcessingException pe) {
                throw pe;
            }
            catch (Throwable t) {
                throw new ProcessingException("Unexpected", t);
            }
        }
    }

    @Override
    public void doPreviousStep() throws ProcessingException {
        if (this.isOpen()) {
            try {
                this.execPreviousStep();
            }
            catch (ProcessingException pe) {
                throw pe;
            }
            catch (Throwable t) {
                throw new ProcessingException("Unexpected", t);
            }
        }
    }

    @Override
    public void doFinish() throws ProcessingException {
        if (this.isOpen()) {
            IWizard.CloseType oldType = this.getCloseType();
            try {
                this.setCloseTypeInternal(IWizard.CloseType.Finished);
                this.execFinish();
            }
            catch (ProcessingException pe) {
                this.setCloseTypeInternal(oldType);
                throw pe;
            }
            catch (Throwable t) {
                this.setCloseTypeInternal(oldType);
                throw new ProcessingException("Unexpected", t);
            }
        }
    }

    @Override
    public void doCancel() throws ProcessingException {
        if (this.isOpen()) {
            IWizard.CloseType oldType = this.getCloseType();
            try {
                this.setCloseTypeInternal(IWizard.CloseType.Cancelled);
                this.execCancel();
            }
            catch (ProcessingException pe) {
                this.setCloseTypeInternal(oldType);
                throw pe;
            }
            catch (Throwable t) {
                this.setCloseTypeInternal(oldType);
                throw new ProcessingException("Unexpected", t);
            }
        }
    }

    @Override
    public void doSuspend() throws ProcessingException {
        if (this.isOpen()) {
            IWizard.CloseType oldType = this.getCloseType();
            try {
                this.setCloseTypeInternal(IWizard.CloseType.Suspended);
                this.execSuspend();
            }
            catch (ProcessingException pe) {
                this.setCloseTypeInternal(oldType);
                throw pe;
            }
            catch (Throwable t) {
                this.setCloseTypeInternal(oldType);
                throw new ProcessingException("Unexpected", t);
            }
        }
    }

    @Override
    public void doReset() throws ProcessingException {
        try {
            this.execReset();
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected", t);
        }
    }

    @Override
    public void doHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
        if (this.isOpen()) {
            this.execHyperlinkAction(url, path, local);
        }
    }

    private void assertOpen() throws ProcessingException {
        if (this.isClosed()) {
            throw new ProcessingException("wizard is closed");
        }
    }

    private void assertClosed() throws ProcessingException {
        if (!this.isClosed()) {
            throw new ProcessingException("wizard is already started");
        }
    }

    @Override
    public IForm getWizardForm() {
        return (IForm)this.propertySupport.getProperty("wizardForm");
    }

    @Override
    public void setWizardForm(IForm form) {
        this.propertySupport.setProperty("wizardForm", (Object)form);
    }

    @Override
    public IWizardContainerForm createContainerForm() throws ProcessingException {
        if (this.m_containerForm == null) {
            this.m_containerForm = this.execCreateContainerForm();
        }
        return this.m_containerForm;
    }

    @Override
    public IWizardContainerForm getContainerForm() {
        return this.m_containerForm;
    }
}

