/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.services.common.jdbc.style;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;

public class DerbySqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;

    protected int getMaxListSize() {
        return 1000;
    }

    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    public boolean isBlobEnabled() {
        return true;
    }

    public boolean isClobEnabled() {
        return true;
    }

    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 FROM SYSIBM.SYSDUMMY1");
        }
        catch (Throwable throwable) {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (testStatement != null) {
            try {
                testStatement.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String createDateIsToday(String attribute) {
        return "CAST(" + attribute + " AS DATE) >= CURRENT_DATE AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInLastDays(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_DAY, :" + bindName + ", CURRENT_TIMESTAMP)} AS DATE) AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInNextDays(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CURRENT_DATE AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, :" + bindName + " + 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInDays(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_DAY, :" + bindName + ", CURRENT_TIMESTAMP)} AS DATE) AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, :" + bindName + " + 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInWeeks(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_WEEK, :" + bindName + ", CURRENT_TIMESTAMP)} AS DATE) AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, {FN TIMESTAMPADD(SQL_TSI_WEEK, :" + bindName + ", CURRENT_TIMESTAMP)})} AS DATE)";
    }

    public String createDateIsInLastMonths(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_MONTH,(-1)*:" + bindName + ", CURRENT_TIMESTAMP)} AS DATE) AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInNextMonths(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CURRENT_DATE AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, {FN TIMESTAMPADD(SQL_TSI_MONTH, :" + bindName + ", CURRENT_TIMESTAMP)})} AS DATE)";
    }

    public String createDateIsInMonths(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_MONTH,:" + bindName + ", CURRENT_TIMESTAMP)} AS DATE) AND CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, {FN TIMESTAMPADD(SQL_TSI_MONTH, :" + bindName + ", CURRENT_TIMESTAMP)})} AS DATE)";
    }

    public String createDateIsInLEDays(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY,:" + bindName + " + 1, CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInLEWeeks(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, {FN TIMESTAMPADD(SQL_TSI_WEEK, :" + bindName + ", CURRENT_TIMESTAMP)})} AS DATE)";
    }

    public String createDateIsInLEMonths(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) < CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, {FN TIMESTAMPADD(SQL_TSI_MONTH, :" + bindName + ", CURRENT_TIMESTAMP)})} AS DATE)";
    }

    public String createDateIsInGEDays(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_DAY,:" + bindName + ", CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInGEWeeks(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_WEEK, :" + bindName + ", CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsInGEMonths(String attribute, String bindName) {
        return "CAST(" + attribute + " AS DATE) >= CAST({FN TIMESTAMPADD(SQL_TSI_MONTH, :" + bindName + ", CURRENT_TIMESTAMP)} AS DATE)";
    }

    public String createDateIsNotToday(String attribute) {
        return "(CAST(" + attribute + " AS DATE) < CURRENT_DATE OR " + attribute + ">= CAST({FN TIMESTAMPADD(SQL_TSI_DAY, 1, CURRENT_TIMESTAMP)} AS DATE))";
    }

    public String createDateTimeIsNow(String attribute) {
        return String.valueOf(attribute) + " >= {FN TIMESTAMPADD(SQL_TSI_MINUTE, -1, CURRENT_TIMESTAMP)} AND " + attribute + " < {FN TIMESTAMPADD(SQL_TSI_MINUTE, 1, CURRENT_TIMESTAMP)}";
    }

    public String createDateTimeIsInLEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + " < {FN TIMESTAMPADD(SQL_TSI_MINUTE, :" + bindName + "+1, CURRENT_TIMESTAMP)}";
    }

    public String createDateTimeIsInLEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + " < {FN TIMESTAMPADD(SQL_TSI_HOUR, :" + bindName + "+1, CURRENT_TIMESTAMP)}";
    }

    public String createDateTimeIsInGEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + " >= {FN TIMESTAMPADD(SQL_TSI_MINUTE, :" + bindName + ", CURRENT_TIMESTAMP)}";
    }

    public String createDateTimeIsInGEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + " >= {FN TIMESTAMPADD(SQL_TSI_HOUR, :" + bindName + ", CURRENT_TIMESTAMP)}";
    }

    public String createDateTimeIsNotNow(String attribute) {
        return "(" + attribute + " < CURRENT_TIMESTAMP OR " + attribute + " >= {FN TIMESTAMPADD(SQL_TSI_MINUTE, 1, CURRENT_TIMESTAMP)})";
    }

    public String createTimeIsNow(String attribute) {
        return String.valueOf(attribute) + ">=(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP))/24.0/60 AND " + attribute + "<(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(1/24.0/60))/24.0/60";
    }

    public String createTimeIsNotNow(String attribute) {
        return String.valueOf(attribute) + "<(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP))/24.0/60 OR " + attribute + ">((HOUR(CURRENT_TIMESTAMP)*60)+MINUTE(CURRENT_TIMESTAMP)+(1/24.0/60))/24.0/60";
    }

    public String createTimeIsInMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0/60))/24/60 AND " + attribute + "<((HOUR(CURRENT_TIMESTAMP)*60)+MINUTE(CURRENT_TIMESTAMP)+((:" + bindName + "+1)/24.0/60))/24.0/60";
    }

    public String createTimeIsInHours(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0))/24/60 AND " + attribute + "<((HOUR(CURRENT_TIMESTAMP)*60)+MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0)+(1/24.0/60))/24.0/60";
    }

    public String createTimeIsInLEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + "<(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+((:" + bindName + "+1)/24.0/60))/24/60";
    }

    public String createTimeIsInLEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + "<(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0)+(1/24.0/60))/24/60";
    }

    public String createTimeIsInGEMinutes(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0/60))/24.0/60";
    }

    public String createTimeIsInGEHours(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=(HOUR(CURRENT_TIMESTAMP)*60 + MINUTE(CURRENT_TIMESTAMP)+(:" + bindName + "/24.0))/24.0/60";
    }
}

