/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.nls.DynamicNls;
import org.eclipse.scout.commons.nls.NlsLocale;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.SessionFilter;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedContextChangedNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public abstract class AbstractServerSession
implements IServerSession {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractServerSession.class);
    private Bundle m_bundle;
    private boolean m_initialized;
    private boolean m_active;
    private NlsLocale m_nlsLocale;
    private Locale m_locale;
    private Pattern[] m_userIdSearchPatterns = new Pattern[]{Pattern.compile(".*\\\\([^/@]+)"), Pattern.compile(".*\\\\([^/@]+)[/@].*"), Pattern.compile("([^/@]+)"), Pattern.compile("([^/@]+)[/@].*")};
    private HashMap<Object, Object> m_attributes;
    private SharedVariableMap m_sharedVariableMap;
    private boolean m_webSession;

    public AbstractServerSession(boolean autoInitConfig) {
        this.m_locale = LocaleThreadLocal.get();
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        this.m_nlsLocale = NlsLocale.getDefault();
        this.m_attributes = new HashMap();
        this.m_sharedVariableMap = new SharedVariableMap();
        if (autoInitConfig) {
            this.initConfig();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredWebSession() {
        return false;
    }

    @Override
    public Map<String, Object> getSharedVariableMap() {
        return this.m_sharedVariableMap;
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    protected <T> void setSharedContextVariable(String name, Class<T> type, T value) {
        Object typedValue = TypeCastUtility.castValue(value, type);
        this.m_sharedVariableMap.put(name, typedValue);
    }

    private void assignUserId() {
        String foundName = null;
        Subject s = Subject.getSubject(AccessController.getContext());
        if (s != null && this.m_userIdSearchPatterns != null) {
            block0: for (Principal p : s.getPrincipals()) {
                String name = p.getName().toLowerCase();
                Pattern[] patternArray = this.m_userIdSearchPatterns;
                int n = this.m_userIdSearchPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern pat = patternArray[n2];
                    Matcher m = pat.matcher(name);
                    if (m.matches()) {
                        foundName = m.group(1);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        if (foundName != null) {
            this.setUserIdInternal(foundName);
        } else {
            this.setUserIdInternal(null);
        }
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    @Override
    public final String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    private void setUserIdInternal(String newValue) {
        this.setSharedContextVariable("userId", String.class, newValue);
    }

    protected Pattern[] getUserIdSearchPatterns() {
        return this.m_userIdSearchPatterns;
    }

    protected void setUserIdSearchPatterns(Pattern ... patterns) {
        this.m_userIdSearchPatterns = patterns;
        this.assignUserId();
    }

    protected void setUserIdSearchPatterns(String ... patterns) {
        Pattern[] a = new Pattern[patterns.length];
        int i = 0;
        while (i < a.length) {
            a[i] = Pattern.compile(patterns[i]);
            ++i;
        }
        this.setUserIdSearchPatterns(a);
    }

    @Override
    public NlsLocale getNlsLocale() {
        return this.m_nlsLocale;
    }

    @Override
    public void setNlsLocale(NlsLocale l) {
        if (l != null) {
            this.m_nlsLocale = l;
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void setLocale(Locale l) {
        if (l != null) {
            this.m_locale = l;
        }
    }

    @Override
    public DynamicNls getNlsTexts() {
        return null;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.m_attributes.get(key);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        this.m_attributes.put(key, value);
    }

    protected void initConfig() {
        this.m_webSession = this.getConfiguredWebSession();
        if (!this.isWebSession()) {
            this.m_sharedVariableMap.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new SharedContextChangedNotification(new SharedVariableMap(AbstractServerSession.this.m_sharedVariableMap)), new SessionFilter(AbstractServerSession.this, 60000L));
                }
            });
        }
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public final void loadSession(Bundle bundle) throws ProcessingException {
        if (this.isActive()) {
            throw new IllegalStateException("session is active");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        this.m_bundle = bundle;
        this.m_active = true;
        this.assignUserId();
        this.execLoadSession();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() throws ProcessingException {
    }

    @Deprecated
    protected void execLocaleChanged() throws ProcessingException {
    }

    @Override
    public boolean isWebSession() {
        return this.m_webSession;
    }
}

