/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.http.servletfilter.HttpServletEx;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.SERVICES;

public class RemoteFileServlet
extends HttpServletEx {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RemoteFileServlet.class);
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String m_folder = "";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String f = config.getInitParameter("folder");
        if (f != null) {
            f = f.replaceAll("\\\\", "/");
            while (f.startsWith("/")) {
                f = f.substring(1);
            }
            while (f.endsWith("/")) {
                f = f.substring(0, f.lastIndexOf(47));
            }
            this.m_folder = String.valueOf('/') + f;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleHttpRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleHttpRequest(req, res);
    }

    protected void handleHttpRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            String pathInfo = req.getPathInfo();
            List<String> fileList = Arrays.asList(pathInfo);
            if (StringUtility.isNullOrEmpty((String)pathInfo) || pathInfo.replaceAll("\\\\", "/").endsWith("/")) {
                String prefix = "/";
                if (pathInfo != null && pathInfo.replaceAll("\\\\", "/").endsWith("/")) {
                    prefix = pathInfo.replaceAll("\\\\", "/");
                }
                fileList = Arrays.asList(String.valueOf(prefix) + "index.html", String.valueOf(prefix) + "index.htm", String.valueOf(prefix) + "default.html", String.valueOf(prefix) + "default.htm", String.valueOf(prefix) + "index.jsp", String.valueOf(prefix) + "index.php");
            }
            try {
                List<String> fileListParam = fileList;
                Iterator<String> pathIter = fileListParam.iterator();
                boolean success = false;
                while (!success && pathIter.hasNext()) {
                    success = this.writeResource(req, res, pathIter.next());
                }
                if (!success) {
                    res.sendError(404, pathInfo);
                }
            }
            catch (Exception ex) {
                if (ex.toString().indexOf("Connection reset by peer: socket write error") >= 0) break block6;
                LOG.warn("Failed to get remotefile " + pathInfo + ".", (Throwable)ex);
                res.setStatus(500);
            }
        }
    }

    private boolean writeResource(HttpServletRequest req, HttpServletResponse resp, String resourcePath) throws ProcessingException, IOException {
        RemoteFile spec;
        IRemoteFileService rfs = (IRemoteFileService)SERVICES.getService(IRemoteFileService.class);
        RemoteFile remoteFile = rfs.getRemoteFileHeader(spec = new RemoteFile(resourcePath == null ? null : String.valueOf(this.m_folder) + resourcePath, -1L));
        if (!remoteFile.exists()) {
            return false;
        }
        long lastModified = remoteFile.getLastModified();
        int contentLength = remoteFile.getContentLength();
        if (this.setResponseParameters(req, resp, resourcePath, remoteFile.getContentType(), lastModified, contentLength) == 304) {
            return true;
        }
        rfs.streamRemoteFile(remoteFile, (OutputStream)resp.getOutputStream());
        return true;
    }

    protected int setResponseParameters(HttpServletRequest req, HttpServletResponse resp, String resourcePath, String contentType, long lastModified, int contentLength) {
        String ifNoneMatch;
        String etag = null;
        if (lastModified != -1L && contentLength != -1) {
            etag = "W/\"" + contentLength + "-" + lastModified + "\"";
        }
        if ((ifNoneMatch = req.getHeader(IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
            resp.setStatus(304);
            return 304;
        }
        long ifModifiedSince = req.getDateHeader(IF_MODIFIED_SINCE);
        if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
            resp.setStatus(304);
            return 304;
        }
        if (contentLength != -1) {
            resp.setContentLength(contentLength);
        }
        if (contentType != null) {
            resp.setContentType(contentType);
        }
        if (lastModified > 0L) {
            resp.setDateHeader(LAST_MODIFIED, lastModified);
        }
        if (etag != null) {
            resp.setHeader(ETAG, etag);
        }
        return 202;
    }
}

