/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.nls.NlsLocale;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.IServerSessionProvider;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.transaction.BasicTransaction;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class ServerJob
extends JobEx
implements IServerSessionProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerJob.class);
    private IServerSession m_serverSession;
    private Subject m_subject;

    public ServerJob(String name, IServerSession serverSession) {
        this(name, serverSession, null);
    }

    public ServerJob(String name, IServerSession serverSession, Subject subject) {
        super(name);
        if (serverSession == null) {
            throw new IllegalArgumentException("serverSession is null");
        }
        this.m_serverSession = serverSession;
        this.m_subject = subject;
        this.setProperty(ScoutTexts.JOB_PROPERTY_NAME, this.m_serverSession.getNlsTexts());
    }

    @Override
    public IServerSession getServerSession() {
        return this.m_serverSession;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public void setSubject(Subject subject) {
        if (this.getState() != 0) {
            throw new IllegalStateException("This job is already scheduled/running");
        }
        this.m_subject = subject;
    }

    public boolean shouldSchedule() {
        if (this.getServerSession() != null && this.getServerSession().isWebSession()) {
            this.runNow((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        return super.shouldSchedule();
    }

    public final IStatus runNow(IProgressMonitor monitor) {
        Job job = ServerJob.getJobManager().currentJob();
        if (job != null && job instanceof ServerJob) {
            throw new IllegalStateException("Nested server jobs are not allowed within the same thread.");
        }
        IStatus status = null;
        try {
            ThreadContext.put(this.getServerSession());
            status = super.runNow(monitor);
        }
        finally {
            ThreadContext.clear(this.getServerSession());
        }
        return status;
    }

    protected final IStatus run(final IProgressMonitor monitor) {
        try {
            if (this.m_subject != null) {
                try {
                    return Subject.doAs(this.m_subject, new PrivilegedExceptionAction<IStatus>(){

                        @Override
                        public IStatus run() throws Exception {
                            return ServerJob.this.runTransactionWrapper(monitor);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof ProcessingException) {
                        return ((ProcessingException)t).getStatus();
                    }
                    return new ProcessingStatus(t.getMessage(), t, 0, 4);
                }
            }
            return this.runTransactionWrapper(monitor);
        }
        catch (Throwable t) {
            if (t instanceof ProcessingException) {
                return ((ProcessingException)t).getStatus();
            }
            return new ProcessingStatus(t.getMessage(), t, 0, 4);
        }
    }

    private IStatus runTransactionWrapper(IProgressMonitor monitor) throws Exception {
        BasicTransaction transaction = new BasicTransaction();
        Map<Class, Object> backup = ThreadContext.backup();
        Locale oldLocale = LocaleThreadLocal.get();
        NlsLocale oldNlsLocale = NlsLocale.getDefault();
        try {
            ThreadContext.put(this.m_serverSession);
            ThreadContext.put(transaction);
            LocaleThreadLocal.set((Locale)this.m_serverSession.getLocale());
            NlsLocale.setThreadDefault((NlsLocale)this.m_serverSession.getNlsLocale());
            IStatus status = this.runTransaction(monitor);
            if (status == null) {
                status = Status.OK_STATUS;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (Throwable t) {
            ProcessingException pe;
            Throwable test;
            if (t instanceof UndeclaredThrowableException && (test = ((UndeclaredThrowableException)t).getUndeclaredThrowable()) != null) {
                t = test;
            }
            if (t.getCause() instanceof ProcessingException) {
                t = t.getCause();
            }
            transaction.addFailure(t);
            String contextMsg = "Identity=" + ServerJob.getIdentity() + ", Job=" + this.getName();
            if (t instanceof ProcessingException) {
                pe = (ProcessingException)t;
                pe.addContextMessage(contextMsg);
            } else {
                pe = new ProcessingException(contextMsg, t);
            }
            throw pe;
        }
        finally {
            if (transaction.hasFailures()) {
                transaction.rollback();
            } else if (transaction.commitPhase1()) {
                transaction.commitPhase2();
            }
            try {
                transaction.release();
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            try {
                ThreadContext.restore(backup);
            }
            catch (Throwable t) {
                LOG.warn(null, t);
            }
            LocaleThreadLocal.set((Locale)oldLocale);
            NlsLocale.setThreadDefault((NlsLocale)oldNlsLocale);
        }
    }

    protected abstract IStatus runTransaction(IProgressMonitor var1) throws Exception;

    public static final IServerSession getCurrentSession() {
        return ServerJob.getCurrentSession(IServerSession.class);
    }

    public static final <T extends IServerSession> T getCurrentSession(Class<T> type) {
        IServerSession s;
        Job job = ServerJob.getJobManager().currentJob();
        if (job instanceof IServerSessionProvider && (s = ((IServerSessionProvider)job).getServerSession()) != null && type.isAssignableFrom(s.getClass())) {
            return (T)s;
        }
        return (T)((IServerSession)ThreadContext.get(type));
    }

    public static String getIdentity() {
        Iterator<Principal> iterator;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (iterator = subject.getPrincipals().iterator()).hasNext()) {
            Principal p = iterator.next();
            return p.getName();
        }
        return "anonymous";
    }
}

