/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.nls.NlsLocale;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.transaction.ITransaction;

public final class ThreadContext {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ThreadContext.class);
    private static final Object MAP_LOCK = new Object();
    private static final WeakHashMap<Thread, HashMap<Class, Object>> MAP = new WeakHashMap();

    private ThreadContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Class, Object> getThreadMap(boolean autoCreate) {
        Object object = MAP_LOCK;
        synchronized (object) {
            HashMap<Class<Object>, Object> threadMap = MAP.get(Thread.currentThread());
            if (threadMap == null && autoCreate) {
                threadMap = new HashMap();
                MAP.put(Thread.currentThread(), threadMap);
            }
            return threadMap;
        }
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ThreadContext.getInternal(HttpServletRequest.class);
    }

    public static HttpServletResponse getHttpServletResponse() {
        return ThreadContext.getInternal(HttpServletResponse.class);
    }

    public static IServerSession getServerSession() {
        return ThreadContext.getInternal(IServerSession.class);
    }

    public static ITransaction getTransaction() {
        return ThreadContext.getInternal(ITransaction.class);
    }

    public static <T> T get(Class<T> key) {
        return ThreadContext.getInternal(key);
    }

    public static <T> T getCustomValue(Class<T> key) {
        return ThreadContext.getInternal(key);
    }

    private static <T> T getInternal(Class<T> key) {
        if (key == Locale.class) {
            return (T)LocaleThreadLocal.get();
        }
        if (key == NlsLocale.class) {
            return (T)NlsLocale.getDefault();
        }
        HashMap<Class, Object> threadMap = ThreadContext.getThreadMap(false);
        if (threadMap != null) {
            return (T)threadMap.get(key);
        }
        return null;
    }

    public static Map<Class, Object> backup() {
        HashMap<Class, Object> map = ThreadContext.getThreadMap(false);
        if (map != null) {
            return new HashMap<Class, Object>(map);
        }
        return new HashMap<Class, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(Map<Class, Object> map) {
        Object object = MAP_LOCK;
        synchronized (object) {
            if (map != null) {
                MAP.put(Thread.currentThread(), new HashMap<Class, Object>(map));
            } else {
                MAP.remove(Thread.currentThread());
            }
        }
    }

    public static <T extends HttpServletRequest> void put(T value) {
        ThreadContext.putInternal(value);
    }

    public static <T extends HttpServletResponse> void put(T value) {
        ThreadContext.putInternal(value);
    }

    public static <T extends IServerSession> void put(T value) {
        ThreadContext.putInternal(value);
    }

    public static <T extends ITransaction> void put(T value) {
        ThreadContext.putInternal(value);
    }

    public static <T> void putCustomValue(T value) {
        ThreadContext.putInternal(value);
    }

    private static <T> void putInternal(T value) {
        if (value == null) {
            return;
        }
        if (value instanceof Locale) {
            LocaleThreadLocal.set((Locale)((Locale)value));
        }
        if (value instanceof NlsLocale) {
            NlsLocale.setThreadDefault((NlsLocale)((NlsLocale)value));
        }
        HashMap<Class, Object> threadMap = ThreadContext.getThreadMap(true);
        HashSet<Class> keys = new HashSet<Class>();
        ThreadContext.enumKeys(value.getClass(), keys);
        for (Class key : keys) {
            threadMap.put(key, value);
        }
    }

    public static <T> void clear(T value) {
        ThreadContext.clearInternal(value);
    }

    public static <T> void clearInternal(T value) {
        if (value == null) {
            return;
        }
        HashMap<Class, Object> threadMap = ThreadContext.getThreadMap(false);
        if (threadMap != null) {
            HashSet<Class> keys = new HashSet<Class>();
            ThreadContext.enumKeys(value.getClass(), keys);
            for (Class key : keys) {
                threadMap.remove(key);
            }
        }
    }

    private static void enumKeys(Class c, HashSet<Class> keys) {
        if (c != null) {
            keys.add(c);
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                ThreadContext.enumKeys(i, keys);
                ++n2;
            }
            ThreadContext.enumKeys(c.getSuperclass(), keys);
        }
    }
}

